/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.Component;
import tech.kronicle.sdk.models.Link;
import tech.kronicle.sdk.models.ObjectWithId;
import tech.kronicle.sdk.models.ObjectWithReference;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=TeamBuilder.class)
public final class Team
implements ObjectWithId,
ObjectWithReference {
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String id;
    @NotBlank
    private final String name;
    @Email
    private final String emailAddress;
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String areaId;
    private final List<@NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String> tags;
    private final String description;
    private final String notes;
    private final List<@Valid Link> links;
    private final List<@Valid Component> components;

    public Team(String id, String name, String emailAddress, String areaId, List<String> tags, String description, String notes, List<Link> links, List<Component> components) {
        this.id = id;
        this.name = name;
        this.emailAddress = emailAddress;
        this.areaId = areaId;
        this.tags = ListUtils.createUnmodifiableList(tags);
        this.description = description;
        this.notes = notes;
        this.links = ListUtils.createUnmodifiableList(links);
        this.components = ListUtils.createUnmodifiableList(components);
    }

    @Override
    public String reference() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static TeamBuilder builder() {
        return new TeamBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public TeamBuilder toBuilder() {
        return new TeamBuilder().id(this.id).name(this.name).emailAddress(this.emailAddress).areaId(this.areaId).tags(this.tags).description(this.description).notes(this.notes).links(this.links).components(this.components);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getAreaId() {
        return this.areaId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String> getTags() {
        return this.tags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getNotes() {
        return this.notes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Link> getLinks() {
        return this.links;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Component> getComponents() {
        return this.components;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Team)) {
            return false;
        }
        Team other = (Team)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$emailAddress = this.getEmailAddress();
        String other$emailAddress = other.getEmailAddress();
        if (this$emailAddress == null ? other$emailAddress != null : !this$emailAddress.equals(other$emailAddress)) {
            return false;
        }
        String this$areaId = this.getAreaId();
        String other$areaId = other.getAreaId();
        if (this$areaId == null ? other$areaId != null : !this$areaId.equals(other$areaId)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$notes = this.getNotes();
        String other$notes = other.getNotes();
        if (this$notes == null ? other$notes != null : !this$notes.equals(other$notes)) {
            return false;
        }
        List<Link> this$links = this.getLinks();
        List<Link> other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        List<Component> this$components = this.getComponents();
        List<Component> other$components = other.getComponents();
        return !(this$components == null ? other$components != null : !((Object)this$components).equals(other$components));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $emailAddress = this.getEmailAddress();
        result = result * 59 + ($emailAddress == null ? 43 : $emailAddress.hashCode());
        String $areaId = this.getAreaId();
        result = result * 59 + ($areaId == null ? 43 : $areaId.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $notes = this.getNotes();
        result = result * 59 + ($notes == null ? 43 : $notes.hashCode());
        List<Link> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        List<Component> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Team(id=" + this.getId() + ", name=" + this.getName() + ", emailAddress=" + this.getEmailAddress() + ", areaId=" + this.getAreaId() + ", tags=" + this.getTags() + ", description=" + this.getDescription() + ", notes=" + this.getNotes() + ", links=" + this.getLinks() + ", components=" + this.getComponents() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Team withId(String id) {
        return this.id == id ? this : new Team(id, this.name, this.emailAddress, this.areaId, this.tags, this.description, this.notes, this.links, this.components);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Team withName(String name) {
        return this.name == name ? this : new Team(this.id, name, this.emailAddress, this.areaId, this.tags, this.description, this.notes, this.links, this.components);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Team withEmailAddress(String emailAddress) {
        return this.emailAddress == emailAddress ? this : new Team(this.id, this.name, emailAddress, this.areaId, this.tags, this.description, this.notes, this.links, this.components);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Team withAreaId(String areaId) {
        return this.areaId == areaId ? this : new Team(this.id, this.name, this.emailAddress, areaId, this.tags, this.description, this.notes, this.links, this.components);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Team withTags(List<@NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String> tags) {
        return this.tags == tags ? this : new Team(this.id, this.name, this.emailAddress, this.areaId, tags, this.description, this.notes, this.links, this.components);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Team withDescription(String description) {
        return this.description == description ? this : new Team(this.id, this.name, this.emailAddress, this.areaId, this.tags, description, this.notes, this.links, this.components);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Team withNotes(String notes) {
        return this.notes == notes ? this : new Team(this.id, this.name, this.emailAddress, this.areaId, this.tags, this.description, notes, this.links, this.components);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Team withLinks(List<@Valid Link> links) {
        return this.links == links ? this : new Team(this.id, this.name, this.emailAddress, this.areaId, this.tags, this.description, this.notes, links, this.components);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Team withComponents(List<@Valid Component> components) {
        return this.components == components ? this : new Team(this.id, this.name, this.emailAddress, this.areaId, this.tags, this.description, this.notes, this.links, components);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class TeamBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String id;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String emailAddress;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String areaId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String> tags;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String notes;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Link> links;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Component> components;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        TeamBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TeamBuilder id(String id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TeamBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TeamBuilder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TeamBuilder areaId(String areaId) {
            this.areaId = areaId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TeamBuilder tags(List<@NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String> tags) {
            this.tags = tags;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TeamBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TeamBuilder notes(String notes) {
            this.notes = notes;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TeamBuilder links(List<@Valid Link> links) {
            this.links = links;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public TeamBuilder components(List<@Valid Component> components) {
            this.components = components;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Team build() {
            return new Team(this.id, this.name, this.emailAddress, this.areaId, this.tags, this.description, this.notes, this.links, this.components);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Team.TeamBuilder(id=" + this.id + ", name=" + this.name + ", emailAddress=" + this.emailAddress + ", areaId=" + this.areaId + ", tags=" + this.tags + ", description=" + this.description + ", notes=" + this.notes + ", links=" + this.links + ", components=" + this.components + ")";
        }
    }
}

