/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.ComponentState;
import tech.kronicle.sdk.models.graphql.GraphQlSchema;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=GraphQlSchemasStateBuilder.class)
public final class GraphQlSchemasState
implements ComponentState {
    public static final String TYPE = "graphql-schemas";
    private final String type = "graphql-schemas";
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String pluginId;
    private final @NotNull List<@Valid GraphQlSchema> graphQlSchemas;

    public GraphQlSchemasState(String pluginId, List<@Valid GraphQlSchema> graphQlSchemas) {
        this.pluginId = pluginId;
        this.graphQlSchemas = ListUtils.createUnmodifiableList(graphQlSchemas);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static GraphQlSchemasStateBuilder builder() {
        return new GraphQlSchemasStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphQlSchemasStateBuilder toBuilder() {
        return new GraphQlSchemasStateBuilder().pluginId(this.pluginId).graphQlSchemas(this.graphQlSchemas);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public @NotNull List<@Valid GraphQlSchema> getGraphQlSchemas() {
        return this.graphQlSchemas;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphQlSchemasState)) {
            return false;
        }
        GraphQlSchemasState other = (GraphQlSchemasState)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        List<GraphQlSchema> this$graphQlSchemas = this.getGraphQlSchemas();
        List<GraphQlSchema> other$graphQlSchemas = other.getGraphQlSchemas();
        return !(this$graphQlSchemas == null ? other$graphQlSchemas != null : !((Object)this$graphQlSchemas).equals(other$graphQlSchemas));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        List<GraphQlSchema> $graphQlSchemas = this.getGraphQlSchemas();
        result = result * 59 + ($graphQlSchemas == null ? 43 : ((Object)$graphQlSchemas).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "GraphQlSchemasState(type=" + this.getType() + ", pluginId=" + this.getPluginId() + ", graphQlSchemas=" + this.getGraphQlSchemas() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphQlSchemasState withPluginId(String pluginId) {
        return this.pluginId == pluginId ? this : new GraphQlSchemasState(pluginId, this.graphQlSchemas);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public GraphQlSchemasState withGraphQlSchemas(@NotNull List<@Valid GraphQlSchema> graphQlSchemas) {
        return this.graphQlSchemas == graphQlSchemas ? this : new GraphQlSchemasState(this.pluginId, graphQlSchemas);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class GraphQlSchemasStateBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String pluginId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid GraphQlSchema> graphQlSchemas;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        GraphQlSchemasStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphQlSchemasStateBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphQlSchemasStateBuilder graphQlSchemas(@NotNull List<@Valid GraphQlSchema> graphQlSchemas) {
            this.graphQlSchemas = graphQlSchemas;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public GraphQlSchemasState build() {
            return new GraphQlSchemasState(this.pluginId, this.graphQlSchemas);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "GraphQlSchemasState.GraphQlSchemasStateBuilder(pluginId=" + this.pluginId + ", graphQlSchemas=" + this.graphQlSchemas + ")";
        }
    }
}

