/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.DiagramConnection;
import tech.kronicle.sdk.models.DiagramState;
import tech.kronicle.sdk.models.ObjectWithId;
import tech.kronicle.sdk.models.ObjectWithReference;
import tech.kronicle.sdk.models.Tag;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=DiagramBuilder.class)
public final class Diagram
implements ObjectWithId,
ObjectWithReference {
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String id;
    @NotBlank
    private final String name;
    private final Boolean discovered;
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String type;
    private final String description;
    private final List<@Valid Tag> tags;
    private final List<@Valid DiagramConnection> connections;
    private final List<@Valid DiagramState> states;

    public Diagram(String id, String name, Boolean discovered, String type, String description, List<@Valid Tag> tags, List<@Valid DiagramConnection> connections, List<@Valid DiagramState> states) {
        this.id = id;
        this.name = name;
        this.discovered = discovered;
        this.type = type;
        this.description = description;
        this.tags = ListUtils.createUnmodifiableList(tags);
        this.connections = ListUtils.createUnmodifiableList(connections);
        this.states = ListUtils.createUnmodifiableList(states);
    }

    @Override
    public String reference() {
        return this.id;
    }

    public Diagram addState(DiagramState state) {
        return this.withStates(ListUtils.unmodifiableUnionOfLists(List.of(this.states, List.of(state))));
    }

    public Diagram addStates(List<DiagramState> states) {
        return this.withStates(ListUtils.unmodifiableUnionOfLists(List.of(this.states, states)));
    }

    @JsonIgnore
    public <T extends DiagramState> List<T> getStates(String type) {
        return this.states.stream().filter(state -> Objects.equals(state.getType(), type)).map(state -> state).collect(Collectors.toUnmodifiableList());
    }

    @JsonIgnore
    public <T extends DiagramState> T getState(String type) {
        List<T> matches = this.getStates(type);
        if (matches.size() > 1) {
            throw new IllegalArgumentException("There are more than 1 states with type \"" + type + "\"");
        }
        if (matches.isEmpty()) {
            return null;
        }
        return (T)((DiagramState)matches.get(0));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static DiagramBuilder builder() {
        return new DiagramBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DiagramBuilder toBuilder() {
        return new DiagramBuilder().id(this.id).name(this.name).discovered(this.discovered).type(this.type).description(this.description).tags(this.tags).connections(this.connections).states(this.states);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Boolean getDiscovered() {
        return this.discovered;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDescription() {
        return this.description;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Tag> getTags() {
        return this.tags;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid DiagramConnection> getConnections() {
        return this.connections;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid DiagramState> getStates() {
        return this.states;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Diagram)) {
            return false;
        }
        Diagram other = (Diagram)o;
        Boolean this$discovered = this.getDiscovered();
        Boolean other$discovered = other.getDiscovered();
        if (this$discovered == null ? other$discovered != null : !((Object)this$discovered).equals(other$discovered)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<Tag> this$tags = this.getTags();
        List<Tag> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        List<DiagramConnection> this$connections = this.getConnections();
        List<DiagramConnection> other$connections = other.getConnections();
        if (this$connections == null ? other$connections != null : !((Object)this$connections).equals(other$connections)) {
            return false;
        }
        List<DiagramState> this$states = this.getStates();
        List<DiagramState> other$states = other.getStates();
        return !(this$states == null ? other$states != null : !((Object)this$states).equals(other$states));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $discovered = this.getDiscovered();
        result = result * 59 + ($discovered == null ? 43 : ((Object)$discovered).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<Tag> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        List<DiagramConnection> $connections = this.getConnections();
        result = result * 59 + ($connections == null ? 43 : ((Object)$connections).hashCode());
        List<DiagramState> $states = this.getStates();
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Diagram(id=" + this.getId() + ", name=" + this.getName() + ", discovered=" + this.getDiscovered() + ", type=" + this.getType() + ", description=" + this.getDescription() + ", tags=" + this.getTags() + ", connections=" + this.getConnections() + ", states=" + this.getStates() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Diagram withId(String id) {
        return this.id == id ? this : new Diagram(id, this.name, this.discovered, this.type, this.description, this.tags, this.connections, this.states);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Diagram withName(String name) {
        return this.name == name ? this : new Diagram(this.id, name, this.discovered, this.type, this.description, this.tags, this.connections, this.states);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Diagram withDiscovered(Boolean discovered) {
        return this.discovered == discovered ? this : new Diagram(this.id, this.name, discovered, this.type, this.description, this.tags, this.connections, this.states);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Diagram withType(String type) {
        return this.type == type ? this : new Diagram(this.id, this.name, this.discovered, type, this.description, this.tags, this.connections, this.states);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Diagram withDescription(String description) {
        return this.description == description ? this : new Diagram(this.id, this.name, this.discovered, this.type, description, this.tags, this.connections, this.states);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Diagram withTags(List<@Valid Tag> tags) {
        return this.tags == tags ? this : new Diagram(this.id, this.name, this.discovered, this.type, this.description, tags, this.connections, this.states);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Diagram withConnections(List<@Valid DiagramConnection> connections) {
        return this.connections == connections ? this : new Diagram(this.id, this.name, this.discovered, this.type, this.description, this.tags, connections, this.states);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Diagram withStates(List<@Valid DiagramState> states) {
        return this.states == states ? this : new Diagram(this.id, this.name, this.discovered, this.type, this.description, this.tags, this.connections, states);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class DiagramBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String id;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String name;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Boolean discovered;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String type;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String description;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Tag> tags;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid DiagramConnection> connections;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid DiagramState> states;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        DiagramBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DiagramBuilder id(String id) {
            this.id = id;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DiagramBuilder name(String name) {
            this.name = name;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DiagramBuilder discovered(Boolean discovered) {
            this.discovered = discovered;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DiagramBuilder type(String type) {
            this.type = type;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DiagramBuilder description(String description) {
            this.description = description;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DiagramBuilder tags(List<@Valid Tag> tags) {
            this.tags = tags;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DiagramBuilder connections(List<@Valid DiagramConnection> connections) {
            this.connections = connections;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public DiagramBuilder states(List<@Valid DiagramState> states) {
            this.states = states;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Diagram build() {
            return new Diagram(this.id, this.name, this.discovered, this.type, this.description, this.tags, this.connections, this.states);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "Diagram.DiagramBuilder(id=" + this.id + ", name=" + this.name + ", discovered=" + this.discovered + ", type=" + this.type + ", description=" + this.description + ", tags=" + this.tags + ", connections=" + this.connections + ", states=" + this.states + ")";
        }
    }
}

