/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import tech.kronicle.sdk.models.Area;
import tech.kronicle.sdk.models.Component;
import tech.kronicle.sdk.models.ComponentType;
import tech.kronicle.sdk.models.Diagram;
import tech.kronicle.sdk.models.ObjectWithReference;
import tech.kronicle.sdk.models.Platform;
import tech.kronicle.sdk.models.Repo;
import tech.kronicle.sdk.models.Team;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=ComponentMetadataBuilder.class)
public final class ComponentMetadata
implements ObjectWithReference {
    private final List<@Valid Repo> repos;
    private final List<@Valid ComponentType> componentTypes;
    private final List<@Valid Platform> platforms;
    private final List<@Valid Area> areas;
    private final List<@Valid Team> teams;
    private final List<@Valid Component> components;
    private final List<@Valid Diagram> diagrams;

    public ComponentMetadata(List<Repo> repos, List<ComponentType> componentTypes, List<Platform> platforms, List<Area> areas, List<Team> teams, List<Component> components, List<Diagram> diagrams) {
        this.repos = ListUtils.createUnmodifiableList(repos);
        this.componentTypes = ListUtils.createUnmodifiableList(componentTypes);
        this.platforms = ListUtils.createUnmodifiableList(platforms);
        this.areas = ListUtils.createUnmodifiableList(areas);
        this.teams = ListUtils.createUnmodifiableList(teams);
        this.components = ListUtils.createUnmodifiableList(components);
        this.diagrams = ListUtils.createUnmodifiableList(diagrams);
    }

    @Override
    public String reference() {
        return "component-metadata";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ComponentMetadataBuilder builder() {
        return new ComponentMetadataBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentMetadataBuilder toBuilder() {
        return new ComponentMetadataBuilder().repos(this.repos).componentTypes(this.componentTypes).platforms(this.platforms).areas(this.areas).teams(this.teams).components(this.components).diagrams(this.diagrams);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Repo> getRepos() {
        return this.repos;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid ComponentType> getComponentTypes() {
        return this.componentTypes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Platform> getPlatforms() {
        return this.platforms;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Area> getAreas() {
        return this.areas;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Team> getTeams() {
        return this.teams;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Component> getComponents() {
        return this.components;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@Valid Diagram> getDiagrams() {
        return this.diagrams;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentMetadata)) {
            return false;
        }
        ComponentMetadata other = (ComponentMetadata)o;
        List<Repo> this$repos = this.getRepos();
        List<Repo> other$repos = other.getRepos();
        if (this$repos == null ? other$repos != null : !((Object)this$repos).equals(other$repos)) {
            return false;
        }
        List<ComponentType> this$componentTypes = this.getComponentTypes();
        List<ComponentType> other$componentTypes = other.getComponentTypes();
        if (this$componentTypes == null ? other$componentTypes != null : !((Object)this$componentTypes).equals(other$componentTypes)) {
            return false;
        }
        List<Platform> this$platforms = this.getPlatforms();
        List<Platform> other$platforms = other.getPlatforms();
        if (this$platforms == null ? other$platforms != null : !((Object)this$platforms).equals(other$platforms)) {
            return false;
        }
        List<Area> this$areas = this.getAreas();
        List<Area> other$areas = other.getAreas();
        if (this$areas == null ? other$areas != null : !((Object)this$areas).equals(other$areas)) {
            return false;
        }
        List<Team> this$teams = this.getTeams();
        List<Team> other$teams = other.getTeams();
        if (this$teams == null ? other$teams != null : !((Object)this$teams).equals(other$teams)) {
            return false;
        }
        List<Component> this$components = this.getComponents();
        List<Component> other$components = other.getComponents();
        if (this$components == null ? other$components != null : !((Object)this$components).equals(other$components)) {
            return false;
        }
        List<Diagram> this$diagrams = this.getDiagrams();
        List<Diagram> other$diagrams = other.getDiagrams();
        return !(this$diagrams == null ? other$diagrams != null : !((Object)this$diagrams).equals(other$diagrams));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Repo> $repos = this.getRepos();
        result = result * 59 + ($repos == null ? 43 : ((Object)$repos).hashCode());
        List<ComponentType> $componentTypes = this.getComponentTypes();
        result = result * 59 + ($componentTypes == null ? 43 : ((Object)$componentTypes).hashCode());
        List<Platform> $platforms = this.getPlatforms();
        result = result * 59 + ($platforms == null ? 43 : ((Object)$platforms).hashCode());
        List<Area> $areas = this.getAreas();
        result = result * 59 + ($areas == null ? 43 : ((Object)$areas).hashCode());
        List<Team> $teams = this.getTeams();
        result = result * 59 + ($teams == null ? 43 : ((Object)$teams).hashCode());
        List<Component> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        List<Diagram> $diagrams = this.getDiagrams();
        result = result * 59 + ($diagrams == null ? 43 : ((Object)$diagrams).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ComponentMetadata(repos=" + this.getRepos() + ", componentTypes=" + this.getComponentTypes() + ", platforms=" + this.getPlatforms() + ", areas=" + this.getAreas() + ", teams=" + this.getTeams() + ", components=" + this.getComponents() + ", diagrams=" + this.getDiagrams() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentMetadata withRepos(List<@Valid Repo> repos) {
        return this.repos == repos ? this : new ComponentMetadata(repos, this.componentTypes, this.platforms, this.areas, this.teams, this.components, this.diagrams);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentMetadata withComponentTypes(List<@Valid ComponentType> componentTypes) {
        return this.componentTypes == componentTypes ? this : new ComponentMetadata(this.repos, componentTypes, this.platforms, this.areas, this.teams, this.components, this.diagrams);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentMetadata withPlatforms(List<@Valid Platform> platforms) {
        return this.platforms == platforms ? this : new ComponentMetadata(this.repos, this.componentTypes, platforms, this.areas, this.teams, this.components, this.diagrams);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentMetadata withAreas(List<@Valid Area> areas) {
        return this.areas == areas ? this : new ComponentMetadata(this.repos, this.componentTypes, this.platforms, areas, this.teams, this.components, this.diagrams);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentMetadata withTeams(List<@Valid Team> teams) {
        return this.teams == teams ? this : new ComponentMetadata(this.repos, this.componentTypes, this.platforms, this.areas, teams, this.components, this.diagrams);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentMetadata withComponents(List<@Valid Component> components) {
        return this.components == components ? this : new ComponentMetadata(this.repos, this.componentTypes, this.platforms, this.areas, this.teams, components, this.diagrams);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentMetadata withDiagrams(List<@Valid Diagram> diagrams) {
        return this.diagrams == diagrams ? this : new ComponentMetadata(this.repos, this.componentTypes, this.platforms, this.areas, this.teams, this.components, diagrams);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class ComponentMetadataBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Repo> repos;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid ComponentType> componentTypes;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Platform> platforms;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Area> areas;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Team> teams;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Component> components;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid Diagram> diagrams;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ComponentMetadataBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentMetadataBuilder repos(List<@Valid Repo> repos) {
            this.repos = repos;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentMetadataBuilder componentTypes(List<@Valid ComponentType> componentTypes) {
            this.componentTypes = componentTypes;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentMetadataBuilder platforms(List<@Valid Platform> platforms) {
            this.platforms = platforms;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentMetadataBuilder areas(List<@Valid Area> areas) {
            this.areas = areas;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentMetadataBuilder teams(List<@Valid Team> teams) {
            this.teams = teams;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentMetadataBuilder components(List<@Valid Component> components) {
            this.components = components;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentMetadataBuilder diagrams(List<@Valid Diagram> diagrams) {
            this.diagrams = diagrams;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentMetadata build() {
            return new ComponentMetadata(this.repos, this.componentTypes, this.platforms, this.areas, this.teams, this.components, this.diagrams);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ComponentMetadata.ComponentMetadataBuilder(repos=" + this.repos + ", componentTypes=" + this.componentTypes + ", platforms=" + this.platforms + ", areas=" + this.areas + ", teams=" + this.teams + ", components=" + this.components + ", diagrams=" + this.diagrams + ")";
        }
    }
}

