/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models.zipkin;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;
import tech.kronicle.sdk.models.ComponentState;
import tech.kronicle.sdk.models.zipkin.ZipkinDependency;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=ZipkinStateBuilder.class)
public final class ZipkinState
implements ComponentState {
    public static final String TYPE = "zipkin";
    private final String type = "zipkin";
    @NotBlank
    @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*")
    private final @NotBlank @Pattern(regexp="[a-z][a-z0-9]*(-[a-z0-9]+)*") String pluginId;
    @NotBlank
    private final String serviceName;
    @NotNull
    private final Boolean used;
    private final @NotNull List<@Valid ZipkinDependency> upstream;
    private final @NotNull List<@Valid ZipkinDependency> downstream;

    public ZipkinState(String pluginId, String serviceName, Boolean used, List<ZipkinDependency> upstream, List<ZipkinDependency> downstream) {
        this.pluginId = pluginId;
        this.serviceName = serviceName;
        this.used = used;
        this.upstream = ListUtils.createUnmodifiableList(upstream);
        this.downstream = ListUtils.createUnmodifiableList(downstream);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ZipkinStateBuilder builder() {
        return new ZipkinStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZipkinStateBuilder toBuilder() {
        return new ZipkinStateBuilder().pluginId(this.pluginId).serviceName(this.serviceName).used(this.used).upstream(this.upstream).downstream(this.downstream);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getPluginId() {
        return this.pluginId;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Boolean getUsed() {
        return this.used;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public @NotNull List<@Valid ZipkinDependency> getUpstream() {
        return this.upstream;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public @NotNull List<@Valid ZipkinDependency> getDownstream() {
        return this.downstream;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZipkinState)) {
            return false;
        }
        ZipkinState other = (ZipkinState)o;
        Boolean this$used = this.getUsed();
        Boolean other$used = other.getUsed();
        if (this$used == null ? other$used != null : !((Object)this$used).equals(other$used)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$pluginId = this.getPluginId();
        String other$pluginId = other.getPluginId();
        if (this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId)) {
            return false;
        }
        String this$serviceName = this.getServiceName();
        String other$serviceName = other.getServiceName();
        if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
            return false;
        }
        List<ZipkinDependency> this$upstream = this.getUpstream();
        List<ZipkinDependency> other$upstream = other.getUpstream();
        if (this$upstream == null ? other$upstream != null : !((Object)this$upstream).equals(other$upstream)) {
            return false;
        }
        List<ZipkinDependency> this$downstream = this.getDownstream();
        List<ZipkinDependency> other$downstream = other.getDownstream();
        return !(this$downstream == null ? other$downstream != null : !((Object)this$downstream).equals(other$downstream));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $used = this.getUsed();
        result = result * 59 + ($used == null ? 43 : ((Object)$used).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $pluginId = this.getPluginId();
        result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
        String $serviceName = this.getServiceName();
        result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
        List<ZipkinDependency> $upstream = this.getUpstream();
        result = result * 59 + ($upstream == null ? 43 : ((Object)$upstream).hashCode());
        List<ZipkinDependency> $downstream = this.getDownstream();
        result = result * 59 + ($downstream == null ? 43 : ((Object)$downstream).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ZipkinState(type=" + this.getType() + ", pluginId=" + this.getPluginId() + ", serviceName=" + this.getServiceName() + ", used=" + this.getUsed() + ", upstream=" + this.getUpstream() + ", downstream=" + this.getDownstream() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZipkinState withPluginId(String pluginId) {
        return this.pluginId == pluginId ? this : new ZipkinState(pluginId, this.serviceName, this.used, this.upstream, this.downstream);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZipkinState withServiceName(String serviceName) {
        return this.serviceName == serviceName ? this : new ZipkinState(this.pluginId, serviceName, this.used, this.upstream, this.downstream);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZipkinState withUsed(@NotNull Boolean used) {
        return this.used == used ? this : new ZipkinState(this.pluginId, this.serviceName, used, this.upstream, this.downstream);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZipkinState withUpstream(@NotNull List<@Valid ZipkinDependency> upstream) {
        return this.upstream == upstream ? this : new ZipkinState(this.pluginId, this.serviceName, this.used, upstream, this.downstream);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ZipkinState withDownstream(@NotNull List<@Valid ZipkinDependency> downstream) {
        return this.downstream == downstream ? this : new ZipkinState(this.pluginId, this.serviceName, this.used, this.upstream, downstream);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class ZipkinStateBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String pluginId;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private String serviceName;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Boolean used;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid ZipkinDependency> upstream;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@Valid ZipkinDependency> downstream;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ZipkinStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ZipkinStateBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ZipkinStateBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ZipkinStateBuilder used(@NotNull Boolean used) {
            this.used = used;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ZipkinStateBuilder upstream(@NotNull List<@Valid ZipkinDependency> upstream) {
            this.upstream = upstream;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ZipkinStateBuilder downstream(@NotNull List<@Valid ZipkinDependency> downstream) {
            this.downstream = downstream;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ZipkinState build() {
            return new ZipkinState(this.pluginId, this.serviceName, this.used, this.upstream, this.downstream);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ZipkinState.ZipkinStateBuilder(pluginId=" + this.pluginId + ", serviceName=" + this.serviceName + ", used=" + this.used + ", upstream=" + this.upstream + ", downstream=" + this.downstream + ")";
        }
    }
}

