/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import tech.kronicle.sdk.models.EnvironmentState;
import tech.kronicle.sdk.utils.ListUtils;
import tech.kronicle.sdk.utils.ObjectWithIdListUtils;

@JsonDeserialize(builder=ComponentStateBuilder.class)
public final class ComponentState {
    public static final ComponentState EMPTY = ComponentState.builder().build();
    private final List<@NotNull @Valid EnvironmentState> environments;

    public ComponentState(List<@NotNull @Valid EnvironmentState> environments) {
        this.environments = ListUtils.createUnmodifiableList(environments);
    }

    public ComponentState withUpdatedEnvironment(String environmentId, UnaryOperator<EnvironmentState> action) {
        ArrayList<EnvironmentState> newEnvironments = new ArrayList<EnvironmentState>(this.environments);
        OptionalInt environmentIndex = IntStream.range(0, newEnvironments.size()).filter(it -> Objects.equals(((EnvironmentState)newEnvironments.get(it)).getId(), environmentId)).findFirst();
        EnvironmentState environment = environmentIndex.isPresent() ? (EnvironmentState)newEnvironments.get(environmentIndex.getAsInt()) : EnvironmentState.builder().id(environmentId).build();
        environment = (EnvironmentState)action.apply(environment);
        if (environmentIndex.isPresent()) {
            newEnvironments.set(environmentIndex.getAsInt(), environment);
        } else {
            newEnvironments.add(environment);
        }
        return this.withEnvironments(newEnvironments);
    }

    public ComponentState merge(ComponentState state) {
        return this.withEnvironments(ObjectWithIdListUtils.mergeObjectWithIdLists(this.environments, state.environments));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static ComponentStateBuilder builder() {
        return new ComponentStateBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentStateBuilder toBuilder() {
        return new ComponentStateBuilder().environments(this.environments);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@NotNull @Valid EnvironmentState> getEnvironments() {
        return this.environments;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentState)) {
            return false;
        }
        ComponentState other = (ComponentState)o;
        List<EnvironmentState> this$environments = this.getEnvironments();
        List<EnvironmentState> other$environments = other.getEnvironments();
        return !(this$environments == null ? other$environments != null : !((Object)this$environments).equals(other$environments));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<EnvironmentState> $environments = this.getEnvironments();
        result = result * 59 + ($environments == null ? 43 : ((Object)$environments).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "ComponentState(environments=" + this.getEnvironments() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ComponentState withEnvironments(List<@NotNull @Valid EnvironmentState> environments) {
        return this.environments == environments ? this : new ComponentState(environments);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class ComponentStateBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@NotNull @Valid EnvironmentState> environments;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        ComponentStateBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentStateBuilder environments(List<@NotNull @Valid EnvironmentState> environments) {
            this.environments = environments;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ComponentState build() {
            return new ComponentState(this.environments);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "ComponentState.ComponentStateBuilder(environments=" + this.environments + ")";
        }
    }
}

