/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.sdk.models;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDateTime;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import tech.kronicle.sdk.models.ObjectWithSourceIndexAndTargetIndex;
import tech.kronicle.sdk.models.SummaryComponentDependencyDuration;
import tech.kronicle.sdk.utils.ListUtils;

@JsonDeserialize(builder=SummaryComponentDependencyBuilder.class)
public final class SummaryComponentDependency
implements ObjectWithSourceIndexAndTargetIndex {
    @Min(value=0L)
    private final @Min(value=0L) Integer sourceIndex;
    @NotNull
    @Min(value=0L)
    private final @NotNull @Min(value=0L) Integer targetIndex;
    @NotNull
    private final @NotNull List<@NotNull @Min(value=0L) Integer> relatedIndexes;
    @NotNull
    private final Boolean manual;
    private final Integer sampleSize;
    private final LocalDateTime startTimestamp;
    private final LocalDateTime endTimestamp;
    private final SummaryComponentDependencyDuration duration;

    public SummaryComponentDependency(Integer sourceIndex, Integer targetIndex, List<Integer> relatedIndexes, Boolean manual, Integer sampleSize, LocalDateTime startTimestamp, LocalDateTime endTimestamp, SummaryComponentDependencyDuration duration) {
        this.sourceIndex = sourceIndex;
        this.targetIndex = targetIndex;
        this.relatedIndexes = ListUtils.createUnmodifiableList(relatedIndexes);
        this.manual = manual;
        this.sampleSize = sampleSize;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.duration = duration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static SummaryComponentDependencyBuilder builder() {
        return new SummaryComponentDependencyBuilder();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SummaryComponentDependencyBuilder toBuilder() {
        return new SummaryComponentDependencyBuilder().sourceIndex(this.sourceIndex).targetIndex(this.targetIndex).relatedIndexes(this.relatedIndexes).manual(this.manual).sampleSize(this.sampleSize).startTimestamp(this.startTimestamp).endTimestamp(this.endTimestamp).duration(this.duration);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getSourceIndex() {
        return this.sourceIndex;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getTargetIndex() {
        return this.targetIndex;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<@NotNull @Min(value=0L) Integer> getRelatedIndexes() {
        return this.relatedIndexes;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Boolean getManual() {
        return this.manual;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Integer getSampleSize() {
        return this.sampleSize;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDateTime getStartTimestamp() {
        return this.startTimestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public LocalDateTime getEndTimestamp() {
        return this.endTimestamp;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SummaryComponentDependencyDuration getDuration() {
        return this.duration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SummaryComponentDependency)) {
            return false;
        }
        SummaryComponentDependency other = (SummaryComponentDependency)o;
        Integer this$sourceIndex = this.getSourceIndex();
        Integer other$sourceIndex = other.getSourceIndex();
        if (this$sourceIndex == null ? other$sourceIndex != null : !((Object)this$sourceIndex).equals(other$sourceIndex)) {
            return false;
        }
        Integer this$targetIndex = this.getTargetIndex();
        Integer other$targetIndex = other.getTargetIndex();
        if (this$targetIndex == null ? other$targetIndex != null : !((Object)this$targetIndex).equals(other$targetIndex)) {
            return false;
        }
        Boolean this$manual = this.getManual();
        Boolean other$manual = other.getManual();
        if (this$manual == null ? other$manual != null : !((Object)this$manual).equals(other$manual)) {
            return false;
        }
        Integer this$sampleSize = this.getSampleSize();
        Integer other$sampleSize = other.getSampleSize();
        if (this$sampleSize == null ? other$sampleSize != null : !((Object)this$sampleSize).equals(other$sampleSize)) {
            return false;
        }
        List<Integer> this$relatedIndexes = this.getRelatedIndexes();
        List<Integer> other$relatedIndexes = other.getRelatedIndexes();
        if (this$relatedIndexes == null ? other$relatedIndexes != null : !((Object)this$relatedIndexes).equals(other$relatedIndexes)) {
            return false;
        }
        LocalDateTime this$startTimestamp = this.getStartTimestamp();
        LocalDateTime other$startTimestamp = other.getStartTimestamp();
        if (this$startTimestamp == null ? other$startTimestamp != null : !((Object)this$startTimestamp).equals(other$startTimestamp)) {
            return false;
        }
        LocalDateTime this$endTimestamp = this.getEndTimestamp();
        LocalDateTime other$endTimestamp = other.getEndTimestamp();
        if (this$endTimestamp == null ? other$endTimestamp != null : !((Object)this$endTimestamp).equals(other$endTimestamp)) {
            return false;
        }
        SummaryComponentDependencyDuration this$duration = this.getDuration();
        SummaryComponentDependencyDuration other$duration = other.getDuration();
        return !(this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $sourceIndex = this.getSourceIndex();
        result = result * 59 + ($sourceIndex == null ? 43 : ((Object)$sourceIndex).hashCode());
        Integer $targetIndex = this.getTargetIndex();
        result = result * 59 + ($targetIndex == null ? 43 : ((Object)$targetIndex).hashCode());
        Boolean $manual = this.getManual();
        result = result * 59 + ($manual == null ? 43 : ((Object)$manual).hashCode());
        Integer $sampleSize = this.getSampleSize();
        result = result * 59 + ($sampleSize == null ? 43 : ((Object)$sampleSize).hashCode());
        List<Integer> $relatedIndexes = this.getRelatedIndexes();
        result = result * 59 + ($relatedIndexes == null ? 43 : ((Object)$relatedIndexes).hashCode());
        LocalDateTime $startTimestamp = this.getStartTimestamp();
        result = result * 59 + ($startTimestamp == null ? 43 : ((Object)$startTimestamp).hashCode());
        LocalDateTime $endTimestamp = this.getEndTimestamp();
        result = result * 59 + ($endTimestamp == null ? 43 : ((Object)$endTimestamp).hashCode());
        SummaryComponentDependencyDuration $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "SummaryComponentDependency(sourceIndex=" + this.getSourceIndex() + ", targetIndex=" + this.getTargetIndex() + ", relatedIndexes=" + this.getRelatedIndexes() + ", manual=" + this.getManual() + ", sampleSize=" + this.getSampleSize() + ", startTimestamp=" + this.getStartTimestamp() + ", endTimestamp=" + this.getEndTimestamp() + ", duration=" + this.getDuration() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SummaryComponentDependency withSourceIndex(Integer sourceIndex) {
        return this.sourceIndex == sourceIndex ? this : new SummaryComponentDependency(sourceIndex, this.targetIndex, this.relatedIndexes, this.manual, this.sampleSize, this.startTimestamp, this.endTimestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SummaryComponentDependency withTargetIndex(Integer targetIndex) {
        return this.targetIndex == targetIndex ? this : new SummaryComponentDependency(this.sourceIndex, targetIndex, this.relatedIndexes, this.manual, this.sampleSize, this.startTimestamp, this.endTimestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SummaryComponentDependency withRelatedIndexes(List<@NotNull @Min(value=0L) Integer> relatedIndexes) {
        return this.relatedIndexes == relatedIndexes ? this : new SummaryComponentDependency(this.sourceIndex, this.targetIndex, relatedIndexes, this.manual, this.sampleSize, this.startTimestamp, this.endTimestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SummaryComponentDependency withManual(Boolean manual) {
        return this.manual == manual ? this : new SummaryComponentDependency(this.sourceIndex, this.targetIndex, this.relatedIndexes, manual, this.sampleSize, this.startTimestamp, this.endTimestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SummaryComponentDependency withSampleSize(Integer sampleSize) {
        return this.sampleSize == sampleSize ? this : new SummaryComponentDependency(this.sourceIndex, this.targetIndex, this.relatedIndexes, this.manual, sampleSize, this.startTimestamp, this.endTimestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SummaryComponentDependency withStartTimestamp(LocalDateTime startTimestamp) {
        return this.startTimestamp == startTimestamp ? this : new SummaryComponentDependency(this.sourceIndex, this.targetIndex, this.relatedIndexes, this.manual, this.sampleSize, startTimestamp, this.endTimestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SummaryComponentDependency withEndTimestamp(LocalDateTime endTimestamp) {
        return this.endTimestamp == endTimestamp ? this : new SummaryComponentDependency(this.sourceIndex, this.targetIndex, this.relatedIndexes, this.manual, this.sampleSize, this.startTimestamp, endTimestamp, this.duration);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public SummaryComponentDependency withDuration(SummaryComponentDependencyDuration duration) {
        return this.duration == duration ? this : new SummaryComponentDependency(this.sourceIndex, this.targetIndex, this.relatedIndexes, this.manual, this.sampleSize, this.startTimestamp, this.endTimestamp, duration);
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public static class SummaryComponentDependencyBuilder {
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer sourceIndex;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer targetIndex;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private List<@NotNull @Min(value=0L) Integer> relatedIndexes;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Boolean manual;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private Integer sampleSize;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDateTime startTimestamp;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private LocalDateTime endTimestamp;
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private SummaryComponentDependencyDuration duration;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        SummaryComponentDependencyBuilder() {
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SummaryComponentDependencyBuilder sourceIndex(Integer sourceIndex) {
            this.sourceIndex = sourceIndex;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SummaryComponentDependencyBuilder targetIndex(Integer targetIndex) {
            this.targetIndex = targetIndex;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SummaryComponentDependencyBuilder relatedIndexes(List<@NotNull @Min(value=0L) Integer> relatedIndexes) {
            this.relatedIndexes = relatedIndexes;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SummaryComponentDependencyBuilder manual(Boolean manual) {
            this.manual = manual;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SummaryComponentDependencyBuilder sampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SummaryComponentDependencyBuilder startTimestamp(LocalDateTime startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SummaryComponentDependencyBuilder endTimestamp(LocalDateTime endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SummaryComponentDependencyBuilder duration(SummaryComponentDependencyDuration duration) {
            this.duration = duration;
            return this;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SummaryComponentDependency build() {
            return new SummaryComponentDependency(this.sourceIndex, this.targetIndex, this.relatedIndexes, this.manual, this.sampleSize, this.startTimestamp, this.endTimestamp, this.duration);
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "SummaryComponentDependency.SummaryComponentDependencyBuilder(sourceIndex=" + this.sourceIndex + ", targetIndex=" + this.targetIndex + ", relatedIndexes=" + this.relatedIndexes + ", manual=" + this.manual + ", sampleSize=" + this.sampleSize + ", startTimestamp=" + this.startTimestamp + ", endTimestamp=" + this.endTimestamp + ", duration=" + this.duration + ")";
        }
    }
}

