/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.pluginapi.scanners.models;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import tech.kronicle.sdk.models.ScannerError;
import tech.kronicle.sdk.utils.ListUtils;

public final class Output<O, T> {
    private final O output;
    private final UnaryOperator<T> transformer;
    @NotNull
    private final List<ScannerError> errors;
    private final Duration cacheTtl;

    public Output(O output, UnaryOperator<T> transformer, List<ScannerError> errors, Duration cacheTtl) {
        this.output = output;
        this.transformer = transformer;
        this.errors = ListUtils.createUnmodifiableList(errors);
        this.cacheTtl = cacheTtl;
    }

    public static <O> Output<O, Void> ofOutput(O output, Duration cacheTtl) {
        return new Output(output, null, null, cacheTtl);
    }

    public static <O, T> Output<O, T> ofTransformer(UnaryOperator<T> transformer, Duration cacheTtl) {
        return new Output<Object, T>(null, transformer, null, cacheTtl);
    }

    public static <O, T> Output<O, T> ofErrors(List<ScannerError> errors, Duration cacheTtl) {
        Objects.requireNonNull(errors, "errors");
        return new Output<Object, T>(null, null, errors, cacheTtl);
    }

    public static <O, T> Output<O, T> ofError(ScannerError error, Duration cacheTtl) {
        Objects.requireNonNull(error, "error");
        return new Output<Object, T>(null, null, List.of(error), cacheTtl);
    }

    public static <O, T> Output<O, T> empty(Duration cacheTtl) {
        return new Output<Object, T>(null, null, null, cacheTtl);
    }

    public static OutputBuilder<Void, Void> builder(Duration cacheTtl) {
        return new OutputBuilder<Void, Void>(cacheTtl);
    }

    public boolean success() {
        return this.errors.isEmpty();
    }

    public boolean failed() {
        return !this.success();
    }

    public boolean hasOutput() {
        return Objects.nonNull(this.output);
    }

    public <O2> Optional<O2> mapOutput(Function<O, O2> mapper) {
        return Optional.ofNullable(this.output).map(mapper);
    }

    public O getOutputOrElse(O other) {
        return Objects.nonNull(this.output) ? this.output : other;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public O getOutput() {
        return this.output;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UnaryOperator<T> getTransformer() {
        return this.transformer;
    }

    @NotNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public List<ScannerError> getErrors() {
        return this.errors;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Duration getCacheTtl() {
        return this.cacheTtl;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Output)) {
            return false;
        }
        Output other = (Output)o;
        O this$output = this.getOutput();
        O other$output = other.getOutput();
        if (this$output == null ? other$output != null : !this$output.equals(other$output)) {
            return false;
        }
        UnaryOperator<T> this$transformer = this.getTransformer();
        UnaryOperator<T> other$transformer = other.getTransformer();
        if (this$transformer == null ? other$transformer != null : !this$transformer.equals(other$transformer)) {
            return false;
        }
        List<ScannerError> this$errors = this.getErrors();
        List<ScannerError> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        Duration this$cacheTtl = this.getCacheTtl();
        Duration other$cacheTtl = other.getCacheTtl();
        return !(this$cacheTtl == null ? other$cacheTtl != null : !((Object)this$cacheTtl).equals(other$cacheTtl));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        O $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : $output.hashCode());
        UnaryOperator<T> $transformer = this.getTransformer();
        result = result * 59 + ($transformer == null ? 43 : $transformer.hashCode());
        List<ScannerError> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        Duration $cacheTtl = this.getCacheTtl();
        result = result * 59 + ($cacheTtl == null ? 43 : ((Object)$cacheTtl).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "Output(output=" + this.getOutput() + ", transformer=" + this.getTransformer() + ", errors=" + this.getErrors() + ", cacheTtl=" + this.getCacheTtl() + ")";
    }

    public static class OutputBuilder<O, T> {
        private O output;
        private UnaryOperator<T> transformer;
        private List<ScannerError> errors = new ArrayList<ScannerError>();
        private Duration cacheTtl;

        public OutputBuilder(Duration cacheTtl) {
            this.cacheTtl = cacheTtl;
        }

        public <O2> OutputBuilder<O2, T> output(O2 output) {
            return new OutputBuilder<O2, T>(output, this.transformer, this.errors, this.cacheTtl);
        }

        public <T2> OutputBuilder<O, T2> transformer(UnaryOperator<T2> transformer) {
            return new OutputBuilder<O, T2>(this.output, transformer, this.errors, this.cacheTtl);
        }

        public OutputBuilder<O, T> errors(List<ScannerError> errors) {
            Objects.requireNonNull(errors, "errors");
            this.errors = new ArrayList<ScannerError>(errors);
            return this;
        }

        public OutputBuilder<O, T> error(ScannerError error) {
            Objects.requireNonNull(error, "error");
            this.errors.add(error);
            return this;
        }

        public Output<O, T> build() {
            return new Output<O, T>(this.output, this.transformer, this.errors, this.cacheTtl);
        }

        @ConstructorProperties(value={"output", "transformer", "errors", "cacheTtl"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        private OutputBuilder(O output, UnaryOperator<T> transformer, List<ScannerError> errors, Duration cacheTtl) {
            this.output = output;
            this.transformer = transformer;
            this.errors = errors;
            this.cacheTtl = cacheTtl;
        }
    }
}

