/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.common;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Set;
import javax.validation.Validator;
import lombok.Generated;
import tech.kronicle.common.ValidationConstraintViolationTransformer;
import tech.kronicle.common.ValidationException;

public class ValidatorService {
    private final Validator validator;
    private final ValidationConstraintViolationTransformer constraintViolationTransformer;

    public <T> void validate(T value) {
        this.validate(value, "Validation failed");
    }

    public <T> void validate(T value, String failureMessage) {
        Set constraintViolations = this.validator.validate(value, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new ValidationException(String.format(failureMessage + ":%n%s", this.constraintViolationTransformer.transform(constraintViolations)));
        }
    }

    @ConstructorProperties(value={"validator", "constraintViolationTransformer"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ValidatorService(Validator validator, ValidationConstraintViolationTransformer constraintViolationTransformer) {
        this.validator = validator;
        this.constraintViolationTransformer = constraintViolationTransformer;
    }
}

