/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.buildgradlevisitor;

import java.util.Objects;
import java.util.Set;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.kronicle.common.StringEscapeUtils;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.ProcessPhase;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.buildgradlevisitor.BaseArtifactVisitor;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.buildgradlevisitor.BaseArtifactVisitorDependencies;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.buildgradlevisitor.PlatformVisitor;
import tech.kronicle.gradlestaticanalyzer.internal.models.PomOutcome;
import tech.kronicle.gradlestaticanalyzer.internal.services.ArtifactVersionResolver;
import tech.kronicle.gradlestaticanalyzer.internal.services.PomFetcher;
import tech.kronicle.gradlestaticanalyzer.internal.utils.InheritingHashSet;
import tech.kronicle.sdk.models.Software;
import tech.kronicle.sdk.models.SoftwareDependencyType;
import tech.kronicle.sdk.models.SoftwareType;

public class DependenciesVisitor
extends BaseArtifactVisitor {
    private static final Logger log = LoggerFactory.getLogger(DependenciesVisitor.class);
    private final ArtifactVersionResolver artifactVersionResolver;
    private final PomFetcher pomFetcher;
    private final PlatformVisitor platformVisitor;

    public DependenciesVisitor(BaseArtifactVisitorDependencies dependencies, ArtifactVersionResolver artifactVersionResolver, PomFetcher pomFetcher, PlatformVisitor platformVisitor) {
        super(dependencies);
        this.artifactVersionResolver = artifactVersionResolver;
        this.pomFetcher = pomFetcher;
        this.platformVisitor = platformVisitor;
    }

    @Override
    protected Logger log() {
        return log;
    }

    @Override
    protected void processPlatform(MethodCallExpression call) {
        this.log().debug("Found platform");
        this.visit((Expression)call, this.platformVisitor);
    }

    @Override
    protected void addArtifact(String groupId, String artifactId, String version, String packaging) {
        String versionSelector;
        Set<String> versions;
        String name = this.artifactUtils().createName(groupId, artifactId);
        if (Objects.nonNull(version)) {
            String newVersion2 = this.artifactVersionResolver.resolveArtifactVersion(groupId, artifactId, version, this.getSoftwareRepositories());
            versions = Set.of(newVersion2);
            versionSelector = !Objects.equals(version, newVersion2) ? version : null;
        } else {
            versions = this.visitorState().getDependencyVersions().get(name);
            if (Objects.isNull(versions) || versions.isEmpty()) {
                throw new IllegalArgumentException("Version could not be found for artifact \"" + StringEscapeUtils.escapeString((String)name) + "\"");
            }
            versionSelector = null;
        }
        String scope = this.visitorState().getProcessPhase() == ProcessPhase.BUILDSCRIPT_DEPENDENCIES ? "buildscript" : null;
        InheritingHashSet<Software> software = this.visitorState().getSoftware();
        versions.forEach(newVersion -> {
            software.add(new Software(null, SoftwareType.JVM, SoftwareDependencyType.DIRECT, name, newVersion, versionSelector, packaging, scope));
            PomOutcome pomOutcome = this.pomFetcher.fetchPom(this.artifactUtils().createArtifact(groupId, artifactId, (String)newVersion), this.getSoftwareRepositories());
            if (!pomOutcome.isJarOnly() && Objects.nonNull(pomOutcome.getPom().getDependencies())) {
                software.addAll(pomOutcome.getPom().getDependencies());
            }
        });
    }
}

