/*
 * Decompiled with CFR 0.152.
 */
package tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.buildgradlevisitor;

import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.BaseBuildFileVisitor;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.BaseBuildFileVisitorDependencies;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.ExpressionVisitOutcome;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.ProcessPhase;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.buildgradlevisitor.DependenciesVisitor;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.buildgradlevisitor.ExtOuterVisitor;
import tech.kronicle.gradlestaticanalyzer.internal.groovyscriptvisitors.buildgradlevisitor.RepositoriesVisitor;

public class BuildscriptVisitor
extends BaseBuildFileVisitor {
    private static final Logger log = LoggerFactory.getLogger(BuildscriptVisitor.class);
    private final RepositoriesVisitor repositoriesVisitor;
    private final DependenciesVisitor dependenciesVisitor;
    private final ExtOuterVisitor extOuterVisitor;

    public BuildscriptVisitor(BaseBuildFileVisitorDependencies dependencies, RepositoriesVisitor repositoriesVisitor, DependenciesVisitor dependenciesVisitor, ExtOuterVisitor extOuterVisitor) {
        super(dependencies);
        this.repositoriesVisitor = repositoriesVisitor;
        this.dependenciesVisitor = dependenciesVisitor;
        this.extOuterVisitor = extOuterVisitor;
    }

    @Override
    protected Logger log() {
        return log;
    }

    @Override
    protected ExpressionVisitOutcome processMethodCallExpression(MethodCallExpression call) {
        if (call.getMethodAsString().equals("repositories")) {
            if (this.visitorState().getProcessPhase() == ProcessPhase.BUILDSCRIPT_REPOSITORIES) {
                log.debug("Found buildscript repositories");
                int count = this.getSoftwareRepositories().size();
                this.visit(call.getArguments(), this.repositoriesVisitor);
                log.debug("Found {} repositories", (Object)(this.getSoftwareRepositories().size() - count));
                return ExpressionVisitOutcome.PROCESSED;
            }
            return ExpressionVisitOutcome.IGNORED_NO_WARNING;
        }
        if (call.getMethodAsString().equals("dependencies")) {
            if (this.visitorState().getProcessPhase() == ProcessPhase.BUILDSCRIPT_DEPENDENCIES) {
                log.debug("Found buildscript dependencies");
                int count = this.visitorState().getSoftware().size();
                this.visit(call.getArguments(), this.dependenciesVisitor);
                log.debug("Found {} dependencies", (Object)(this.visitorState().getSoftware().size() - count));
                return ExpressionVisitOutcome.PROCESSED;
            }
            return ExpressionVisitOutcome.IGNORED_NO_WARNING;
        }
        if (call.getMethodAsString().equals("ext")) {
            if (this.visitorState().getProcessPhase() == ProcessPhase.PROPERTIES) {
                log.debug("Found buildscript ext");
                int count = this.visitorState().getProperties().size();
                this.visit((Expression)call, this.extOuterVisitor);
                log.debug("Found {} project properties", (Object)(this.visitorState().getProperties().size() - count));
                return ExpressionVisitOutcome.PROCESSED;
            }
            return ExpressionVisitOutcome.IGNORED_NO_WARNING;
        }
        return ExpressionVisitOutcome.IGNORED;
    }
}

