/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.time.schedule.impl;

import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.harmonysoft.oss.common.time.clock.ClockProvider;
import tech.harmonysoft.oss.common.time.schedule.impl.TimeProcessingStrategy;
import tech.harmonysoft.oss.common.time.util.TimeUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0002H\u0002J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \b*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \b*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ltech/harmonysoft/oss/common/time/schedule/impl/TimeMillisProcessingStrategy;", "Ltech/harmonysoft/oss/common/time/schedule/impl/TimeProcessingStrategy;", "", "clockProvider", "Ltech/harmonysoft/oss/common/time/clock/ClockProvider;", "(Ltech/harmonysoft/oss/common/time/clock/ClockProvider;)V", "calendarInstance", "Ljava/util/Calendar;", "kotlin.jvm.PlatformType", "lastMondayStartTimeDstOffset", "", "lastMondayStartTimeMillis", "timeZone", "Ljava/util/TimeZone;", "useDst", "", "zoneId", "Ljava/time/ZoneId;", "anchorMondayStartMillisBeforeTime", "time", "getDstOffset", "timeMsBeforeEndOfTheDay", "timeMsFromStartOfTheDay", "toDayOfWeek", "Ljava/time/DayOfWeek;", "harmonysoft-common"})
public final class TimeMillisProcessingStrategy
implements TimeProcessingStrategy<Long> {
    private final long lastMondayStartTimeMillis;
    private final int lastMondayStartTimeDstOffset;
    private final ZoneId zoneId;
    private final TimeZone timeZone;
    private final boolean useDst;
    private final Calendar calendarInstance;

    public TimeMillisProcessingStrategy(@NotNull ClockProvider clockProvider) {
        Intrinsics.checkNotNullParameter((Object)clockProvider, (String)"clockProvider");
        this.zoneId = ((Clock)clockProvider.getData()).getZone();
        this.timeZone = TimeZone.getTimeZone(this.zoneId);
        this.useDst = this.timeZone.useDaylightTime();
        this.calendarInstance = Calendar.getInstance(this.timeZone);
        long currentTimeMillis = ((Clock)clockProvider.getData()).millis();
        ZonedDateTime beginningOfToday = ZonedDateTime.ofInstant(Instant.ofEpochMilli(currentTimeMillis), this.zoneId).toLocalDate().atStartOfDay(this.zoneId);
        this.lastMondayStartTimeMillis = beginningOfToday.minusDays(beginningOfToday.getDayOfWeek().ordinal()).toInstant().toEpochMilli();
        this.lastMondayStartTimeDstOffset = this.getDstOffset(this.lastMondayStartTimeMillis);
    }

    @Override
    @NotNull
    public DayOfWeek toDayOfWeek(long time) {
        long anchorMondayStartMillisBeforeTime = this.anchorMondayStartMillisBeforeTime(time);
        long dayShift = (time - anchorMondayStartMillisBeforeTime) / TimeUtil.Millis.INSTANCE.getDAY();
        DayOfWeek dayOfWeek = DayOfWeek.MONDAY.plus(dayShift);
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"plus(...)");
        return dayOfWeek;
    }

    private final long anchorMondayStartMillisBeforeTime(long time) {
        if (this.lastMondayStartTimeMillis <= time) {
            return this.lastMondayStartTimeMillis;
        }
        long weeksToRollback = (this.lastMondayStartTimeMillis - time) / TimeUtil.Millis.INSTANCE.getWEEK() + 1L;
        long base = this.lastMondayStartTimeMillis - weeksToRollback * TimeUtil.Millis.INSTANCE.getWEEK();
        return this.useDst ? base + (long)this.lastMondayStartTimeDstOffset - (long)this.getDstOffset(time) : base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getDstOffset(long time) {
        int n;
        Calendar calendar = this.calendarInstance;
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"calendarInstance");
        Calendar calendar2 = calendar;
        synchronized (calendar2) {
            boolean bl = false;
            this.calendarInstance.setTimeInMillis(time);
            n = this.calendarInstance.get(16);
        }
        return n;
    }

    @Override
    public long timeMsFromStartOfTheDay(long time) {
        int n;
        long anchorMondayStartTimeMillis = this.anchorMondayStartMillisBeforeTime(time);
        if (this.useDst) {
            int timeDstOffset = this.getDstOffset(time);
            n = timeDstOffset - (anchorMondayStartTimeMillis == this.lastMondayStartTimeMillis ? this.lastMondayStartTimeDstOffset : this.getDstOffset(anchorMondayStartTimeMillis));
        } else {
            n = 0;
        }
        int dstOffsetShift = n;
        return (time + (long)dstOffsetShift - anchorMondayStartTimeMillis) % TimeUtil.Millis.INSTANCE.getDAY();
    }

    @Override
    public long timeMsBeforeEndOfTheDay(long time) {
        return TimeUtil.Millis.INSTANCE.getDAY() - this.timeMsFromStartOfTheDay(time);
    }
}

