/*
 * Decompiled with CFR 0.152.
 */
package tech.harmonysoft.oss.common.info.impl;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Map;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.harmonysoft.oss.common.info.CommonInfoKey;
import tech.harmonysoft.oss.common.info.CommonInfoProvider;
import tech.harmonysoft.oss.common.time.clock.ClockProvider;
import tech.harmonysoft.oss.common.time.util.DateTimeHelper;

@Named
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Ltech/harmonysoft/oss/common/info/impl/StartTimeInfoProvider;", "Ltech/harmonysoft/oss/common/info/CommonInfoProvider;", "clockProvider", "Ltech/harmonysoft/oss/common/time/clock/ClockProvider;", "dateTimeHelper", "Ltech/harmonysoft/oss/common/time/util/DateTimeHelper;", "(Ltech/harmonysoft/oss/common/time/clock/ClockProvider;Ltech/harmonysoft/oss/common/time/util/DateTimeHelper;)V", "info", "", "", "getInfo", "()Ljava/util/Map;", "startTimeMs", "", "getStartTimeMs", "()J", "startTimeString", "getStartTimeString", "()Ljava/lang/String;", "harmonysoft-common"})
public final class StartTimeInfoProvider
implements CommonInfoProvider {
    private final long startTimeMs;
    @NotNull
    private final String startTimeString;
    @NotNull
    private final Map<String, String> info;

    public StartTimeInfoProvider(@NotNull ClockProvider clockProvider, @NotNull DateTimeHelper dateTimeHelper) {
        Intrinsics.checkNotNullParameter((Object)clockProvider, (String)"clockProvider");
        Intrinsics.checkNotNullParameter((Object)dateTimeHelper, (String)"dateTimeHelper");
        this.startTimeMs = ((Clock)clockProvider.getData()).millis();
        LocalDateTime localDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.startTimeMs), ((Clock)clockProvider.getData()).getZone()).toLocalDateTime();
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"ofInstant(\n        Insta\u2026e\n    ).toLocalDateTime()");
        this.startTimeString = dateTimeHelper.formatDateTime(localDateTime);
        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)CommonInfoKey.INSTANCE.getSTART_TIME(), (Object)this.startTimeString));
    }

    public final long getStartTimeMs() {
        return this.startTimeMs;
    }

    @NotNull
    public final String getStartTimeString() {
        return this.startTimeString;
    }

    @Override
    @NotNull
    public Map<String, String> getInfo() {
        return this.info;
    }
}

