/*
 * Decompiled with CFR 0.152.
 */
package tech.gujin.toast;

import android.content.Context;
import android.os.Build;
import android.os.Looper;
import android.widget.Toast;
import androidx.annotation.Nullable;
import tech.gujin.toast.ToastConfig;
import tech.gujin.toast.ToastInfo;
import tech.gujin.toast.ToastUtil;
import tech.gujin.toast.ToastUtilHandler;

class ToastShow {
    private static final ToastUtilHandler sHandler = new ToastUtilHandler(Looper.getMainLooper());
    private static Toast sReplaceToast;
    private static int sDuration;

    ToastShow() {
    }

    static void show(CharSequence text, boolean durationLong, @Nullable ToastUtil.Mode mode) {
        int duration;
        int n = duration = durationLong ? 1 : 0;
        if (mode == null) {
            mode = ToastConfig.getDefaultMode();
        }
        if (ToastUtil.Mode.NORMAL == mode) {
            Toast.makeText((Context)ToastConfig.getContext(), (CharSequence)text, (int)duration).show();
            return;
        }
        if (sReplaceToast == null || sDuration != duration) {
            sDuration = duration;
            sReplaceToast = ToastShow.makeReplaceToast(text, duration);
        } else {
            try {
                sReplaceToast.setText(text);
            }
            catch (RuntimeException e) {
                sReplaceToast = ToastShow.makeReplaceToast(text, duration);
            }
        }
        sReplaceToast.show();
    }

    static void postShow(CharSequence text, boolean durationLong, @Nullable ToastUtil.Mode mode) {
        ToastInfo info = new ToastInfo(text, durationLong, mode);
        sHandler.obtainMessage(1, info).sendToTarget();
    }

    private static Toast makeReplaceToast(CharSequence text, int duration) {
        Toast toast = Toast.makeText((Context)ToastConfig.getContext(), (CharSequence)text, (int)duration);
        if (Build.VERSION.SDK_INT >= 30) {
            toast.addCallback(new Toast.Callback(){

                public void onToastHidden() {
                    sReplaceToast = null;
                }
            });
        }
        return toast;
    }
}

