/*
 * Decompiled with CFR 0.152.
 */
package tech.guazi.component.upgrade;

import android.content.Context;
import com.mobile.base.http.BaseController;
import com.mobile.base.http.BaseProtocol;
import com.mobile.base.http.BaseRequest;
import java.util.HashMap;
import java.util.Map;
import tech.guazi.component.upgrade.HostManager;
import tech.guazi.component.upgrade.UpgradeInfo;
import tech.guazi.component.upgrade.UpgradeListener;
import tech.guazi.component.upgrade.UpgradeProtocol;
import tech.guazi.component.upgrade.utils.PackageUtils;

final class UpgradeController
extends BaseController {
    private static UpgradeController mInstance;
    private Context mContext;
    private int mAppId;

    private UpgradeController(Context context) {
        this.mContext = context;
        this.init(this.mContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UpgradeController getInstance(Context context) {
        if (mInstance != null) return mInstance;
        Class<UpgradeController> clazz = UpgradeController.class;
        synchronized (UpgradeController.class) {
            if (mInstance != null) return mInstance;
            mInstance = new UpgradeController(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    protected Map<String, String> getDefaultHeader() {
        return new HashMap<String, String>();
    }

    public void requestVersionInfo(boolean isAuto, final UpgradeListener listener) {
        String url = HostManager.getInstance(this.mContext).getHost() + "/guazi/version/update";
        BaseRequest baseRequest = this.getDefaultBaseRequest(url);
        baseRequest.putPostParams("app_id", this.mAppId);
        baseRequest.putPostParams("ori_version", PackageUtils.getAppVersionName(this.mContext));
        BaseController.BaseCallBack<UpgradeProtocol> callback = new BaseController.BaseCallBack<UpgradeProtocol>(){

            public void onSuccess(UpgradeProtocol protocol) {
                if (listener != null) {
                    UpgradeInfo info = protocol.getUpgradeInfo();
                    if (info != null && info.isNewVersion()) {
                        listener.onUpgrade(UpgradeController.this.mContext, true, info);
                    } else {
                        listener.onUpgrade(UpgradeController.this.mContext, false, info);
                    }
                }
            }

            public void onFail(UpgradeProtocol protocol, int i) {
                listener.onUpgrade(UpgradeController.this.mContext, false, null);
            }
        };
        UpgradeProtocol protocol = new UpgradeProtocol();
        BaseController.AsyncHttpResponseHandlerWrapper asyncHttpResponseHandlerWrapper = new BaseController.AsyncHttpResponseHandlerWrapper((BaseController)this, (BaseController.BaseCallBack)callback, (BaseProtocol)protocol);
        this.getBaseClientWithHeader().post(baseRequest, asyncHttpResponseHandlerWrapper);
    }

    protected void setAppId(int appId) {
        this.mAppId = appId;
    }

    protected int getAppId() {
        return this.mAppId;
    }
}

