/*
 * Decompiled with CFR 0.152.
 */
package tech.guazi.component.upgrade_with_ui;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import tech.guazi.component.upgrade_with_ui.R;

public class UpgradeConfirmDialog
extends Dialog {
    private Context mContext;
    private LayoutInflater mInflater;
    private View mThisView;
    private TextView title;
    private TextView msg;
    private LinearLayout mCancleButton;
    private LinearLayout mOKButton;
    private OnButtonClickListener mClickListener;
    private LinearLayout mContainer;
    private OnCheckChangedListener mCheckChangeListener;
    private CheckBox mTipCheckBox;

    public UpgradeConfirmDialog(Context context, String title, String msg, OnButtonClickListener clickListener) {
        super(context);
        this.createConfirmDialog(context);
        this.setTitleText(title);
        this.setMessage(msg);
        this.setOnClickListener(clickListener);
    }

    public UpgradeConfirmDialog(Context context, String title, String msg, OnButtonClickListener clickListener, boolean isNeedCancleButton) {
        super(context);
        this.createConfirmDialog(context);
        this.setTitleText(title);
        this.setMessage(msg);
        if (!isNeedCancleButton) {
            this.mCancleButton.setVisibility(8);
        }
        this.setOnClickListener(clickListener);
    }

    public UpgradeConfirmDialog(Context context, String title, OnButtonClickListener clickListener, View view) {
        super(context);
        this.createConfirmDialog(context);
        this.setTitleText(title);
        this.setOnClickListener(clickListener);
        this.mContainer.setVisibility(0);
        this.mContainer.addView(view);
        this.msg.setVisibility(8);
    }

    public void setOKButtonText(String str) {
        TextView okTextView = (TextView)this.mOKButton.findViewById(R.id.tv_ok_btn);
        if (okTextView != null) {
            okTextView.setText((CharSequence)str);
        }
    }

    public void setCancelButtonText(String str) {
        TextView calcelTextView = (TextView)this.mCancleButton.findViewById(R.id.tv_cancel_btn);
        if (calcelTextView != null) {
            calcelTextView.setText((CharSequence)str);
        }
    }

    public void setOnCheckChangeListener(OnCheckChangedListener listener) {
        this.mCheckChangeListener = listener;
    }

    public void setCheckboxVisiable(boolean isVisiable) {
        this.mTipCheckBox.setVisibility(isVisiable ? 0 : 8);
    }

    @SuppressLint(value={"InflateParams"})
    private void createConfirmDialog(Context context) {
        this.mContext = context;
        this.mInflater = LayoutInflater.from((Context)context);
        Window win = this.getWindow();
        win.requestFeature(1);
        win.setBackgroundDrawableResource(17170445);
        this.mThisView = this.mInflater.inflate(R.layout.com_upgrade_dialog_confirm_view, null);
        this.init();
        this.setContentView(this.mThisView);
    }

    private void init() {
        this.title = (TextView)this.mThisView.findViewById(R.id.tv_title);
        this.msg = (TextView)this.mThisView.findViewById(R.id.tv_content);
        this.mCancleButton = (LinearLayout)this.mThisView.findViewById(R.id.cancel_button);
        this.mOKButton = (LinearLayout)this.mThisView.findViewById(R.id.ok_button);
        this.mContainer = (LinearLayout)this.mThisView.findViewById(R.id.layout_dialog_container);
        this.mTipCheckBox = (CheckBox)this.mThisView.findViewById(R.id.cb_disable_tip);
        this.mTipCheckBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (UpgradeConfirmDialog.this.mCheckChangeListener != null) {
                    UpgradeConfirmDialog.this.mCheckChangeListener.onCheckedChanged(isChecked);
                }
            }
        });
    }

    public void setTitleTextColor(int color) {
        if (this.title != null) {
            this.title.setTextColor(color);
        }
    }

    private void setTitleText(String text) {
        if (this.title != null) {
            if (TextUtils.isEmpty((CharSequence)text)) {
                this.title.setVisibility(8);
            } else {
                this.title.setVisibility(0);
                this.title.setText((CharSequence)text);
            }
        }
    }

    public void setButtonTextColor(int color) {
        TextView cancelTextView;
        TextView okTextView = (TextView)this.mOKButton.findViewById(R.id.tv_ok_btn);
        if (okTextView != null) {
            okTextView.setTextColor(color);
        }
        if ((cancelTextView = (TextView)this.mOKButton.findViewById(R.id.tv_cancel_btn)) != null) {
            cancelTextView.setTextColor(color);
        }
    }

    private void setMessage(String text) {
        if (this.msg != null) {
            if (TextUtils.isEmpty((CharSequence)text)) {
                return;
            }
            this.msg.setText((CharSequence)text);
        }
    }

    private void setOnClickListener(OnButtonClickListener clickListener) {
        this.mClickListener = clickListener;
        if (this.mCancleButton != null) {
            this.mCancleButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (UpgradeConfirmDialog.this.mClickListener != null) {
                        UpgradeConfirmDialog.this.mClickListener.onCancleButtonClick(v);
                    }
                    if (UpgradeConfirmDialog.this != null && UpgradeConfirmDialog.this.isShowing()) {
                        UpgradeConfirmDialog.this.dismiss();
                    }
                }
            });
        }
        if (this.mOKButton != null) {
            this.mOKButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (UpgradeConfirmDialog.this.mClickListener != null) {
                        UpgradeConfirmDialog.this.mClickListener.onOkButtonClick(v);
                    }
                    if (UpgradeConfirmDialog.this != null && UpgradeConfirmDialog.this.isShowing()) {
                        UpgradeConfirmDialog.this.dismiss();
                    }
                }
            });
        }
    }

    public static interface OnCheckChangedListener {
        public void onCheckedChanged(boolean var1);
    }

    public static interface OnButtonClickListener {
        public void onOkButtonClick(View var1);

        public void onCancleButtonClick(View var1);
    }
}

