/*
 * Decompiled with CFR 0.152.
 */
package tech.guazi.component.upgrade_with_ui;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.RemoteViews;
import android.widget.Toast;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import tech.guazi.component.upgrade.DownloadStateListener;
import tech.guazi.component.upgrade.HostEnvironment;
import tech.guazi.component.upgrade.UpgradeInfo;
import tech.guazi.component.upgrade.UpgradeListener;
import tech.guazi.component.upgrade.UpgradeManager;
import tech.guazi.component.upgrade.utils.Md5Utils;
import tech.guazi.component.upgrade.utils.NetworkUtils;
import tech.guazi.component.upgrade.utils.PackageUtils;
import tech.guazi.component.upgrade.utils.ShellUtils;
import tech.guazi.component.upgrade_with_ui.R;
import tech.guazi.component.upgrade_with_ui.UpgradeConfirmDialog;
import tech.guazi.component.upgrade_with_ui.UpgradeProgressDialog;

public final class UpgradeHelper {
    private static UpgradeHelper mInstance;
    private Context mContext;
    private int mAppIconResId;

    private UpgradeHelper(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UpgradeHelper getInstance(Context context) {
        if (mInstance != null) return mInstance;
        Class<UpgradeHelper> clazz = UpgradeHelper.class;
        synchronized (UpgradeHelper.class) {
            if (mInstance != null) return mInstance;
            mInstance = new UpgradeHelper(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    public void init(int appId) {
        UpgradeManager.getInstance((Context)this.mContext).init(appId);
    }

    public void setEnvironment(HostEnvironment environment) {
        UpgradeManager.getInstance((Context)this.mContext).setEnvironment(environment);
    }

    public void checkVersion(final boolean isAuto, final DialogInterface.OnDismissListener dismissListener) {
        UpgradeManager.getInstance((Context)this.mContext).checkVersion(isAuto, new UpgradeListener(){

            public void onUpgrade(Context context, boolean hasNewVersion, final UpgradeInfo upgradeInfo) {
                boolean isNotifyDisabled = UpgradeManager.getInstance((Context)UpgradeHelper.this.mContext).isVersionNotifyDisabled();
                if (hasNewVersion) {
                    if (isNotifyDisabled && !isAuto || !isNotifyDisabled) {
                        UpgradeHelper.this.showUpgradeDialog(upgradeInfo, isAuto, new DialogInterface.OnDismissListener(){

                            public void onDismiss(DialogInterface dialog) {
                                UpgradeManager.getInstance((Context)UpgradeHelper.this.mContext).storeVersionNotifyData(isAuto, upgradeInfo);
                                if (dismissListener != null) {
                                    dismissListener.onDismiss(dialog);
                                }
                            }
                        });
                    }
                } else if (!isAuto) {
                    Toast.makeText((Context)context, (CharSequence)"\u5f53\u524d\u5df2\u7ecf\u662f\u6700\u65b0\u7248\u672c", (int)0).show();
                }
            }
        });
    }

    public void cancelUpgradeVeresion(UpgradeInfo upgradeInfo) {
        if (upgradeInfo.isForceVersion()) {
            try {
                System.exit(0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void showUpgradeDialog(final UpgradeInfo upgradeInfo, final boolean isAuto, final DialogInterface.OnDismissListener dismissListener) {
        if (upgradeInfo != null && upgradeInfo.isNewVersion()) {
            UpgradeConfirmDialog.OnButtonClickListener buttonClickListener = new UpgradeConfirmDialog.OnButtonClickListener(){

                @Override
                public void onOkButtonClick(View v) {
                    if (UpgradeManager.getInstance((Context)UpgradeHelper.this.mContext).checkLocalVersionAndInstall()) {
                        return;
                    }
                    if (!NetworkUtils.isNetworkAvailable((Context)UpgradeHelper.this.mContext)) {
                        UpgradeHelper.this.toast("\u7f51\u7edc\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
                        if (upgradeInfo.isForceVersion()) {
                            UpgradeHelper.this.showUpgradeDialog(upgradeInfo, isAuto, dismissListener);
                        }
                        return;
                    }
                    if (!UpgradeHelper.this.isSDMounted()) {
                        UpgradeHelper.this.toast("SD\u5361\u72b6\u6001\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5");
                        if (upgradeInfo.isForceVersion()) {
                            UpgradeHelper.this.showUpgradeDialog(upgradeInfo, isAuto, dismissListener);
                        }
                        return;
                    }
                    UpgradeHelper.this.doOnlineUpgrade(upgradeInfo);
                }

                @Override
                public void onCancleButtonClick(View v) {
                    UpgradeHelper.this.cancelUpgradeVeresion(upgradeInfo);
                }
            };
            UpgradeConfirmDialog.OnCheckChangedListener checkChangeListener = new UpgradeConfirmDialog.OnCheckChangedListener(){

                @Override
                public void onCheckedChanged(boolean isCheck) {
                    UpgradeManager.getInstance((Context)UpgradeHelper.this.mContext).storeVersionNotifyDisableData(isCheck);
                }
            };
            this.showUpgradeConfigDialog(upgradeInfo, buttonClickListener, dismissListener, checkChangeListener);
        } else if (!isAuto) {
            this.toast("\u5f53\u524d\u5df2\u7ecf\u662f\u6700\u65b0\u7248\u672c");
        }
    }

    public void doOnlineUpgrade(UpgradeInfo upgradeInfo) {
        if (upgradeInfo == null || TextUtils.isEmpty((CharSequence)upgradeInfo.getVersionUrl())) {
            return;
        }
        String inUri = upgradeInfo.getVersionUrl();
        String localUri = "/GuaZi/upgrade/" + Md5Utils.toMd5((byte[])inUri.getBytes()) + ".apk";
        localUri = this.getInternalSDPath(localUri);
        Object listener = null;
        listener = upgradeInfo.isForceVersion() ? new VersionDownloadDialogListener(upgradeInfo, localUri) : new VersionDownloadNotiListener(upgradeInfo, localUri);
        listener.setTotalSize(upgradeInfo.getVersionSize());
        Log.d((String)"upgrade_debug", (String)("inUri=" + inUri + ", outUri=" + localUri + ", totalSize=" + listener.getTotalSize()));
        UpgradeManager.getInstance((Context)this.mContext).download(inUri, localUri, (DownloadStateListener)listener);
    }

    public void resetVersionData() {
        UpgradeManager.getInstance((Context)this.mContext).resetVersionNotifyData();
    }

    public void setNotificationAppIcon(int appIconResId) {
        this.mAppIconResId = appIconResId;
    }

    private void showUpgradeConfigDialog(UpgradeInfo info, UpgradeConfirmDialog.OnButtonClickListener listener, DialogInterface.OnDismissListener dismissListener, UpgradeConfirmDialog.OnCheckChangedListener checkListener) {
        String tipStr = "\u53d1\u73b0\u65b0\u7248\u672c\uff08" + info.getVersionName() + "\uff09";
        String msgStr = info.getVersionText();
        UpgradeConfirmDialog dialog = new UpgradeConfirmDialog(this.mContext, tipStr, msgStr, listener, !info.isForceVersion());
        dialog.setOKButtonText("\u53bb\u66f4\u65b0");
        dialog.setCancelButtonText("\u53d6\u6d88");
        dialog.setCanceledOnTouchOutside(false);
        dialog.setCancelable(false);
        dialog.setOnDismissListener(dismissListener);
        if (!info.isForceVersion()) {
            dialog.setCheckboxVisiable(true);
            dialog.setOnCheckChangeListener(checkListener);
        } else {
            dialog.setCheckboxVisiable(false);
        }
        dialog.show();
    }

    private void toast(String str) {
        Toast.makeText((Context)this.mContext, (CharSequence)str, (int)0).show();
    }

    private boolean isSDMounted() {
        boolean flag = false;
        if ("mounted".equals(Environment.getExternalStorageState())) {
            flag = true;
        }
        return flag;
    }

    private String getInternalSDPath(String localPath) {
        String sdPathStr = null;
        sdPathStr = Integer.valueOf(Build.VERSION.SDK_INT) >= 16 ? "/storage/sdcard0" : "/mnt/sdcard";
        sdPathStr = sdPathStr + (localPath.startsWith("/") ? localPath : "/" + localPath);
        return sdPathStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doCheckApk(Context context, long fileSize, String apkPath) {
        boolean flag = false;
        if (TextUtils.isEmpty((CharSequence)apkPath)) {
            return flag;
        }
        FileInputStream fis = null;
        try {
            File apkFile = new File(apkPath);
            if (!apkFile.exists() || !apkFile.canRead()) {
                boolean bl = flag;
                return bl;
            }
            fis = new FileInputStream(apkFile);
            long apkFileSize = fis.available();
            if (apkFileSize >= fileSize || (float)Math.abs(apkFileSize - fileSize) < (float)fileSize * 0.05f) {
                flag = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    private void doInstallApk(final Context context, final String apkPath) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                boolean slient = PackageUtils.isSystemApplication((Context)context) || ShellUtils.checkRootPermission();
                int resInt = PackageUtils.install((Context)context, (String)apkPath);
                String installResult = 1 == resInt ? "INSTALL_SUCCEEDED" : "INSTALL_FAILURE";
                Log.d((String)"upgrade_debug", (String)("[doInstallApk()] <" + installResult + ", slient=" + slient + ", apkPath=" + apkPath + ">"));
            }
        }).start();
    }

    private class VersionDownloadDialogListener
    implements DownloadStateListener {
        private long mTotalSize;
        private UpgradeProgressDialog mProgressDialog = null;
        private UpgradeInfo mUpgradeInfo;
        private long mDownloadSize;
        private long mPreDownloadSize;
        private int mPercent;
        private ScheduledExecutorService mExecutorService;
        private Handler mHandler = new Handler(Looper.getMainLooper());
        private Runnable mUpdateRunnalbe = new Runnable(){

            @Override
            public void run() {
                VersionDownloadDialogListener.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        VersionDownloadDialogListener.this.mPreDownloadSize = VersionDownloadDialogListener.this.mDownloadSize;
                        VersionDownloadDialogListener.this.mDownloadSize = (long)((float)VersionDownloadDialogListener.this.mPercent / 100.0f * (float)VersionDownloadDialogListener.this.mTotalSize);
                    }
                });
            }
        };

        public VersionDownloadDialogListener(UpgradeInfo upgradeInfo, String localUri) {
            this.mUpgradeInfo = upgradeInfo;
        }

        public void onStart() {
            Log.d((String)"upgrade_debug", (String)"dialog.onStart()");
            this.mProgressDialog = new UpgradeProgressDialog(UpgradeHelper.this.mContext);
            this.mProgressDialog.setMessage("\u6b63\u5728\u4e0b\u8f7d\u65b0\u7248\u672c(" + this.mUpgradeInfo.getVersionName() + ")...");
            this.mProgressDialog.setMax(100);
            this.mProgressDialog.setProgress(0);
            this.mProgressDialog.setCancelable(false);
            this.mProgressDialog.setCanceledOnTouchOutside(false);
            this.mProgressDialog.show();
            this.initService();
        }

        public void onProgress(int curPercent) {
            Log.d((String)"upgrade_debug", (String)("dialog.onProgress(" + curPercent + ")"));
            this.mPercent = curPercent;
            if (this.mProgressDialog != null) {
                this.mProgressDialog.setProgress(curPercent);
                this.mProgressDialog.setSize(this.getSizeStr());
                this.mProgressDialog.setSpeed(this.getSpeedStr());
            }
        }

        public void onFinish(String localUri) {
            Log.d((String)"upgrade_debug", (String)"dialog.onFinish()");
            this.shutdownService();
            boolean flag = UpgradeHelper.this.doCheckApk(UpgradeHelper.this.mContext, this.mTotalSize, localUri);
            if (flag) {
                UpgradeHelper.this.doInstallApk(UpgradeHelper.this.mContext, localUri);
                UpgradeManager.getInstance((Context)UpgradeHelper.this.mContext).storeVersionLocalUrl(localUri);
            }
            Log.d((String)"upgrade_debug", (String)("dialog.onFinish(), doCheckApk()=" + flag));
        }

        public void onCancel() {
            Log.d((String)"upgrade_debug", (String)"dialog.onCancel()");
            this.shutdownService();
        }

        public void onFailure(int reson, Object obj) {
            Log.d((String)"upgrade_debug", (String)("dialog.onFailure(" + reson + ", " + obj + ")"));
            this.shutdownService();
            UpgradeHelper.this.toast("\u7f51\u7edc\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u4e0b\u8f7d");
        }

        public void setTotalSize(long totalSize) {
            Log.d((String)"upgrade_debug", (String)("dialog.setTotalSize(" + totalSize + ")"));
            this.mTotalSize = totalSize;
        }

        public long getTotalSize() {
            return this.mTotalSize;
        }

        private String getSizeStr() {
            float apkSize = (float)this.mUpgradeInfo.getVersionSize() / 1048576.0f;
            float downloadSize = (float)this.mPercent / 100.0f * apkSize;
            downloadSize = downloadSize > apkSize ? apkSize : downloadSize;
            return String.format("%.1f", Float.valueOf(downloadSize)) + "M/" + String.format("%.1f", Float.valueOf(apkSize)) + "M";
        }

        private String getSpeedStr() {
            if (this.isFinished()) {
                return "";
            }
            int speed = (int)(this.mDownloadSize - this.mPreDownloadSize) / 1024;
            return speed + "KB/S";
        }

        private boolean isFinished() {
            return this.mPercent >= 100;
        }

        private void initService() {
            this.shutdownService();
            this.mExecutorService = Executors.newScheduledThreadPool(1);
            this.mExecutorService.scheduleAtFixedRate(this.mUpdateRunnalbe, 0L, 500L, TimeUnit.MILLISECONDS);
        }

        private void shutdownService() {
            if (this.mExecutorService != null && !this.mExecutorService.isShutdown()) {
                this.mExecutorService.shutdownNow();
            }
        }
    }

    private class VersionDownloadNotiListener
    implements DownloadStateListener {
        private static final String UPGRADE_NOTIFICATION_CANCEL_ACTION = "com_upgrade_notification_cancel_action";
        private Handler mHandler = new Handler(Looper.getMainLooper());
        private long mTotalSize;
        private NotificationManager mNotificationManager;
        private Notification.Builder mNotificationBuilder;
        private Notification mNotification;
        private UpgradeInfo mUpgradeInfo;
        private int mPercent;
        private long mDownloadSize;
        private long mPreDownloadSize;
        private String mLocalUri;
        private ScheduledExecutorService mExecutorService;
        private Runnable mUpdateRunnalbe = new Runnable(){

            @Override
            public void run() {
                VersionDownloadNotiListener.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        VersionDownloadNotiListener.this.mPreDownloadSize = VersionDownloadNotiListener.this.mDownloadSize;
                        VersionDownloadNotiListener.this.mDownloadSize = (long)((float)VersionDownloadNotiListener.this.mPercent / 100.0f * (float)VersionDownloadNotiListener.this.mTotalSize);
                        VersionDownloadNotiListener.this.updateNotification();
                    }
                });
            }
        };
        private BroadcastReceiver mCancelReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                VersionDownloadNotiListener.this.shutdownService();
                UpgradeManager.getInstance((Context)UpgradeHelper.this.mContext).cancelDownload((DownloadStateListener)VersionDownloadNotiListener.this);
                VersionDownloadNotiListener.this.mNotificationBuilder.setContentIntent(null);
            }
        };

        public VersionDownloadNotiListener(UpgradeInfo upgradeInfo, String localUri) {
            this.mUpgradeInfo = upgradeInfo;
            this.mLocalUri = localUri;
        }

        public void onStart() {
            Log.d((String)"upgrade_debug", (String)"notification.onStart()");
            this.initNotification();
            this.initService();
        }

        public void onProgress(int percent) {
            Log.d((String)"upgrade_debug", (String)("notification.onProgress(" + percent + ")"));
            this.mPercent = percent;
        }

        public void onFinish(String localUri) {
            Log.d((String)"upgrade_debug", (String)"notification.onFinish()");
            this.shutdownService();
            this.updateNotification();
            boolean flag = UpgradeHelper.this.doCheckApk(UpgradeHelper.this.mContext, this.mTotalSize, localUri);
            if (flag) {
                UpgradeHelper.this.doInstallApk(UpgradeHelper.this.mContext, localUri);
                UpgradeManager.getInstance((Context)UpgradeHelper.this.mContext).storeVersionLocalUrl(localUri);
            }
            Log.d((String)"upgrade_debug", (String)("dialog.onFinish(), doCheckApk()=" + flag));
        }

        public void onCancel() {
            Log.d((String)"upgrade_debug", (String)"notification.onCancel()");
            if (this.mNotificationManager != null) {
                this.mNotificationManager.cancel(1001);
            }
            this.shutdownService();
            this.mNotificationBuilder.setContentIntent(null);
        }

        public void onFailure(int reson, Object obj) {
            Log.d((String)"upgrade_debug", (String)("notification.onFailure(" + reson + ", " + obj + ")"));
            if (this.mNotificationManager != null) {
                this.mNotificationManager.cancel(1001);
            }
            this.shutdownService();
            UpgradeHelper.this.toast("\u7f51\u7edc\u8fde\u63a5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u4e0b\u8f7d");
            this.mNotificationBuilder.setContentIntent(null);
        }

        public void setTotalSize(long totalSize) {
            Log.d((String)"upgrade_debug", (String)("notification.setTotalSize(" + totalSize + ")"));
            this.mTotalSize = totalSize;
        }

        public long getTotalSize() {
            return this.mTotalSize;
        }

        private void initService() {
            this.shutdownService();
            this.mExecutorService = Executors.newScheduledThreadPool(1);
            this.mExecutorService.scheduleAtFixedRate(this.mUpdateRunnalbe, 0L, 500L, TimeUnit.MILLISECONDS);
        }

        private void shutdownService() {
            if (this.mExecutorService != null && !this.mExecutorService.isShutdown()) {
                this.mExecutorService.shutdownNow();
            }
        }

        private void initNotification() {
            try {
                Context context = UpgradeHelper.this.mContext;
                Intent intent = PackageUtils.getInstallIntent((Context)context, (String)this.mLocalUri);
                PendingIntent contentIndent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x8000000);
                this.mNotificationBuilder = new Notification.Builder(context);
                this.mNotificationBuilder.setContentIntent((PendingIntent)(this.isFinished() ? contentIndent : null)).setSmallIcon(R.drawable.com_upgrade_app_icon).setWhen(System.currentTimeMillis()).setAutoCancel(true);
                this.mNotification = this.mNotificationBuilder.getNotification();
                this.mNotification.contentView = new RemoteViews(context.getPackageName(), R.layout.com_upgrade_notification_view);
                int appIconId = UpgradeHelper.this.mAppIconResId > 0 ? UpgradeHelper.this.mAppIconResId : R.drawable.com_upgrade_app_icon;
                this.mNotification.contentView.setImageViewResource(R.id.icon_view, appIconId);
                String versionName = this.mUpgradeInfo.getVersionUrl().substring(this.mUpgradeInfo.getVersionUrl().lastIndexOf(47) + 1);
                this.mNotification.contentView.setTextViewText(R.id.name_view, (CharSequence)versionName);
                if (this.isFinished()) {
                    this.mNotification.contentView.setViewVisibility(R.id.progress_view, 8);
                } else {
                    this.mNotification.contentView.setProgressBar(R.id.progress_view, 100, 0, false);
                }
                this.mNotification.contentView.setTextViewText(R.id.size_view, (CharSequence)this.getSizeStr());
                this.mNotification.contentView.setTextViewText(R.id.speed_view, (CharSequence)this.getSpeedStr());
                this.mNotification.contentView.setTextViewText(R.id.percent_view, (CharSequence)this.getPercentStr());
                this.mNotificationManager = (NotificationManager)context.getSystemService("notification");
                this.mNotificationManager.notify(1001, this.mNotification);
                Intent buttonIntent = new Intent(UPGRADE_NOTIFICATION_CANCEL_ACTION);
                PendingIntent cancelIntent = PendingIntent.getBroadcast((Context)UpgradeHelper.this.mContext, (int)0, (Intent)buttonIntent, (int)0);
                this.mNotification.contentView.setOnClickPendingIntent(R.id.iv_cancel, cancelIntent);
                IntentFilter filter = new IntentFilter();
                filter.addAction(UPGRADE_NOTIFICATION_CANCEL_ACTION);
                UpgradeHelper.this.mContext.registerReceiver(this.mCancelReceiver, filter);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private void updateNotification() {
            try {
                if (this.isFinished()) {
                    this.initNotification();
                    return;
                }
                if (this.mNotificationManager != null) {
                    this.mNotification.contentView.setTextViewText(R.id.size_view, (CharSequence)this.getSizeStr());
                    this.mNotification.contentView.setProgressBar(R.id.progress_view, 100, this.mPercent, false);
                    this.mNotification.contentView.setTextViewText(R.id.speed_view, (CharSequence)this.getSpeedStr());
                    this.mNotification.contentView.setTextViewText(R.id.percent_view, (CharSequence)this.getPercentStr());
                    this.mNotificationManager = (NotificationManager)UpgradeHelper.this.mContext.getSystemService("notification");
                    this.mNotificationManager.notify(1001, this.mNotification);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        private String getSizeStr() {
            float apkSize = (float)this.mUpgradeInfo.getVersionSize() / 1048576.0f;
            float downloadSize = (float)this.mPercent / 100.0f * apkSize;
            downloadSize = downloadSize > apkSize ? apkSize : downloadSize;
            return String.format("%.1f", Float.valueOf(downloadSize)) + "M/" + String.format("%.1f", Float.valueOf(apkSize)) + "M";
        }

        private String getPercentStr() {
            if (this.isFinished()) {
                return "\u4e0b\u8f7d\u5b8c\u6210\uff0c\u70b9\u51fb\u5b89\u88c5";
            }
            return this.mPercent + "%";
        }

        private String getSpeedStr() {
            if (this.isFinished()) {
                return "";
            }
            int speed = (int)(this.mDownloadSize - this.mPreDownloadSize) / 1024;
            return speed + "KB/S";
        }

        private boolean isFinished() {
            return this.mPercent >= 100;
        }
    }
}

