/*
 * Decompiled with CFR 0.152.
 */
package com.mobile.base.http;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class BaseRequest {
    private String requestName;
    private CacheType cacheType = CacheType.NO_CACHE;
    public static final int TIME_HOUR = 3600;
    public static final int TIME_MONTH = 2592000;
    private int cacheSecond = 3600;
    public Map<String, String> header = new HashMap<String, String>();
    private HashMap<String, String> getParams = new HashMap();
    private HashMap<String, String> postParams = new HashMap();
    private HashMap<String, File> fileParams = new HashMap();
    public JSONObject jsonObject;

    public BaseRequest(String name) {
        this.requestName = name;
    }

    public void setHeader(Map<String, String> header) {
        this.header = header;
    }

    public int getCacheSecond() {
        return this.cacheSecond;
    }

    public String getRequestName() {
        return this.requestName;
    }

    public void setJsonObject(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public void putPostParams(String key, String value) {
        this.postParams.put(key, value);
    }

    public void putPostParams(String key, double value) {
        this.putPostParams(key, value + "");
    }

    public void putPostParams(String key, int value) {
        this.putPostParams(key, value + "");
    }

    public void putPostParams(String key, float value) {
        this.putPostParams(key, value + "");
    }

    public void putPostParams(String key, long value) {
        this.putPostParams(key, value + "");
    }

    public void putGetParams(String key, String value) {
        try {
            value = URLEncoder.encode(value, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.getParams.put(key, value);
    }

    public void putFileParams(String key, File file) {
        this.fileParams.put(key, file);
    }

    public HashMap<String, File> getFileParams() {
        return this.fileParams;
    }

    public HashMap<String, String> postParams() {
        return this.postParams;
    }

    public HashMap<String, String> getParams() {
        return this.getParams;
    }

    public void setCacheSecond(int second) {
        this.setCacheType(CacheType.TIME_CACHE);
        this.cacheSecond = second;
    }

    private void setCacheType(CacheType cacheType) {
        this.cacheType = cacheType;
    }

    public CacheType getCacheType() {
        return this.cacheType;
    }

    public void setCacheWhenNoNet() {
        this.setCacheType(CacheType.CACHE_WHEN_NO_NET);
        this.cacheSecond = 2592000;
    }

    public static enum CacheType {
        NO_CACHE,
        TIME_CACHE,
        CACHE_WHEN_NO_NET;

    }
}

