/*
 * Decompiled with CFR 0.152.
 */
package com.mobile.base.http;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.PersistentCookieStore;
import com.mobile.base.http.BaseCache;
import com.mobile.base.http.BaseClient;
import com.mobile.base.http.BaseProtocol;
import com.mobile.base.http.BaseRequest;
import com.mobile.base.phoneinfo.PhoneInfoHelper;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.client.CookieStore;
import org.apache.http.protocol.HttpContext;

public abstract class BaseController {
    private static final String TAG = BaseController.class.getSimpleName();
    private BaseClient baseClient;
    private Context context;

    public void init(Context context) {
        this.context = context;
        this.baseClient = new BaseClient(context);
    }

    public void setHost(String host) {
        this.baseClient.setHost(host);
    }

    public BaseClient getBaseClientWithHeader(BaseRequest baseRequest) {
        this.baseClient.setHeader(baseRequest.header);
        return this.baseClient;
    }

    public BaseClient getBaseClientWithHeader() {
        this.baseClient.setHeader(this.getDefaultHeader());
        return this.baseClient;
    }

    protected abstract Map<String, String> getDefaultHeader();

    private void saveCookies() {
        HttpContext httpContext = this.baseClient.getHttpContext();
        PersistentCookieStore myCookieStore = new PersistentCookieStore(this.context);
        this.baseClient.setCookieStore((CookieStore)myCookieStore);
        CookieStore cookies = (CookieStore)httpContext.getAttribute("http.cookie-store");
    }

    public Context getContext() {
        return this.context;
    }

    public BaseRequest getDefaultBaseRequest(String action) {
        BaseRequest baseRequest = new BaseRequest(action);
        this.putNotNullGetParams(baseRequest, "installId", PhoneInfoHelper.installId);
        this.putNotNullGetParams(baseRequest, "customerId", PhoneInfoHelper.customerId);
        this.putNotNullGetParams(baseRequest, "versionId", PhoneInfoHelper.versionCode + "");
        this.putNotNullGetParams(baseRequest, "deviceId", PhoneInfoHelper.IMEI);
        this.putNotNullGetParams(baseRequest, "dpi", PhoneInfoHelper.density + "");
        this.putNotNullGetParams(baseRequest, "screenWH", PhoneInfoHelper.screenWidth + "X" + PhoneInfoHelper.screenHeight);
        this.putNotNullGetParams(baseRequest, "osv", PhoneInfoHelper.osv + "");
        this.putNotNullGetParams(baseRequest, "model", PhoneInfoHelper.model);
        this.putNotNullGetParams(baseRequest, "platform", PhoneInfoHelper.platform);
        this.putNotNullGetParams(baseRequest, "sv", PhoneInfoHelper.versionName);
        this.putNotNullGetParams(baseRequest, "net", PhoneInfoHelper.netType);
        return baseRequest;
    }

    public void putNotNullGetParams(BaseRequest baseRequest, String key, String value) {
        if (!TextUtils.isEmpty((CharSequence)value)) {
            baseRequest.putGetParams(key, value);
        }
    }

    public static interface BaseCallBack<T extends BaseProtocol> {
        public void onSuccess(T var1);

        public void onFail(T var1, int var2);
    }

    public class AsyncHttpResponseHandlerWrapper
    extends AsyncHttpResponseHandler {
        private BaseProtocol protocol;
        private BaseCallBack callback;
        private String cacheKey = "";
        private int second = 3600;

        public void setCacheKey(String key) {
            this.cacheKey = key;
        }

        public void setCacheSecond(int second) {
            this.second = second;
        }

        public AsyncHttpResponseHandlerWrapper(BaseCallBack callback, BaseProtocol protocol) {
            this.protocol = protocol;
            this.callback = callback;
        }

        public boolean successFromCache(String cacheResult) {
            if (this.protocol.parseFromJSON(cacheResult)) {
                this.callback.onSuccess(this.protocol);
                return true;
            }
            return false;
        }

        public void onSuccess(int statusCode, Header[] headers, byte[] response) {
            BaseController.this.saveCookies();
            String result = null;
            try {
                result = new String(response, "UTF-8");
                Log.d((String)TAG, (String)result);
                if (!TextUtils.isEmpty((CharSequence)this.cacheKey)) {
                    BaseCache.getInstance(BaseController.this.context).putString(this.cacheKey, result, this.second);
                }
            }
            catch (UnsupportedEncodingException e) {
                this.callback.onFail(this.protocol, -100);
                e.printStackTrace();
            }
            if (this.protocol.parseFromJSON(result)) {
                this.callback.onSuccess(this.protocol);
            } else {
                this.callback.onFail(this.protocol, 2);
            }
        }

        public void onFailure(int statusCode, Header[] headers, byte[] errorResponse, Throwable e) {
            this.callback.onFail(this.protocol, 1);
            Log.d((String)TAG, (String)("file statusCode = " + statusCode));
        }
    }
}

