/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.tablecell;

import org.vandeseer.easytable.drawing.Drawer;
import org.vandeseer.easytable.split.MinimumHeightSplitCellException;
import org.vandeseer.easytable.split.SplitCellData;
import org.vandeseer.easytable.split.TableContainRowSpanCellsException;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.tablecell.TableWithinTableDrawer;

public class TableWithinTableCell
extends AbstractCell {
    private Table table;

    public float getMinHeight() {
        return this.table.getHeight() + this.getVerticalPadding();
    }

    protected Drawer createDefaultDrawer() {
        return new TableWithinTableDrawer(this);
    }

    public SplitCellData splitCell(float height) {
        this.checkForRowSpanCells();
        if (((Row)this.table.getRows().get(0)).getHeight() + this.getVerticalPadding() > height) {
            throw new MinimumHeightSplitCellException();
        }
        SplitCellData data = new SplitCellData();
        Table.TableBuilder samePageTableBuilder = Table.builder().settings(this.table.getSettings());
        Table.TableBuilder nextPageTableBuilder = Table.builder().settings(this.table.getSettings());
        this.table.getColumns().forEach(col -> {
            samePageTableBuilder.addColumnOfWidth(col.getWidth());
            nextPageTableBuilder.addColumnOfWidth(col.getWidth());
        });
        float rowHeightSum = this.getVerticalPadding();
        boolean samePageTableExists = false;
        boolean nextPageTableExists = false;
        for (Row row : this.table.getRows()) {
            if ((rowHeightSum += row.getHeight()) < height) {
                samePageTableExists = true;
                samePageTableBuilder.addRow(row);
                continue;
            }
            nextPageTableExists = true;
            nextPageTableBuilder.addRow(row);
        }
        if (samePageTableExists) {
            Table samePageTable = samePageTableBuilder.build();
            data.setSamePageCell(((TableWithinTableCellBuilder)TableWithinTableCell.builder().table(samePageTable).settings(this.getSettings())).build());
            data.setSamePageCellPresent(true);
            data.setSamePageCellHeight(samePageTable.getHeight() + this.getVerticalPadding());
        } else {
            data.setSamePageCell((AbstractCell)TextCell.builder().text("").build());
            data.setSamePageCellPresent(false);
            data.setSamePageCellHeight(this.getVerticalPadding());
        }
        if (nextPageTableExists) {
            Table nextPageTable = nextPageTableBuilder.build();
            data.setNextPageCell(((TableWithinTableCellBuilder)TableWithinTableCell.builder().table(nextPageTable).settings(this.getSettings())).build());
            data.setNextPageCellPresent(true);
            data.setNextPageCellHeight(nextPageTable.getHeight() + this.getVerticalPadding());
        } else {
            data.setNextPageCell((AbstractCell)TextCell.builder().text("").build());
            data.setNextPageCellPresent(false);
            data.setNextPageCellHeight(this.getVerticalPadding());
        }
        return data;
    }

    private void checkForRowSpanCells() {
        if (this.table.getRows().stream().flatMap(r -> r.getCells().stream()).filter(c -> c.getRowSpan() > 1).count() > 0L) {
            throw new TableContainRowSpanCellsException("TableWithinTable containing cells with rowspan value greater than 1 cannot be split.");
        }
    }

    protected TableWithinTableCell(TableWithinTableCellBuilder<?, ?> b) {
        super(b);
        this.table = ((TableWithinTableCellBuilder)b).table;
    }

    public static TableWithinTableCellBuilder<?, ?> builder() {
        return new TableWithinTableCellBuilderImpl();
    }

    public TableWithinTableCellBuilder<?, ?> toBuilder() {
        return new TableWithinTableCellBuilderImpl().$fillValuesFrom(this);
    }

    public Table getTable() {
        return this.table;
    }

    private static final class TableWithinTableCellBuilderImpl
    extends TableWithinTableCellBuilder<TableWithinTableCell, TableWithinTableCellBuilderImpl> {
        private TableWithinTableCellBuilderImpl() {
        }

        @Override
        protected TableWithinTableCellBuilderImpl self() {
            return this;
        }

        @Override
        public TableWithinTableCell build() {
            return new TableWithinTableCell(this);
        }
    }

    public static abstract class TableWithinTableCellBuilder<C extends TableWithinTableCell, B extends TableWithinTableCellBuilder<C, B>>
    extends AbstractCell.AbstractCellBuilder<C, B> {
        private Table table;

        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            TableWithinTableCellBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(TableWithinTableCell instance, TableWithinTableCellBuilder<?, ?> b) {
            b.table(instance.table);
        }

        protected abstract B self();

        public abstract C build();

        public B table(Table table) {
            this.table = table;
            return (B)this.self();
        }

        public String toString() {
            return "TableWithinTableCell.TableWithinTableCellBuilder(super=" + super.toString() + ", table=" + this.table + ")";
        }
    }
}

