/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.feature;

import java.awt.Color;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.annotation.Annotation;
import tech.grasshopper.pdf.annotation.cell.TextLinkCell;
import tech.grasshopper.pdf.data.FeatureData;
import tech.grasshopper.pdf.font.ReportFont;
import tech.grasshopper.pdf.optimizer.TextLengthOptimizer;
import tech.grasshopper.pdf.optimizer.TextSanitizer;
import tech.grasshopper.pdf.pojo.cucumber.Feature;
import tech.grasshopper.pdf.structure.Display;
import tech.grasshopper.pdf.structure.PageCreator;
import tech.grasshopper.pdf.structure.TableCreator;
import tech.grasshopper.pdf.structure.footer.CroppedMessage;
import tech.grasshopper.pdf.structure.paginate.PaginationData;
import tech.grasshopper.pdf.util.DateUtil;
import tech.grasshopper.pdf.util.TextUtil;

public class FeatureScenarioDetails
extends Display {
    private PaginationData paginationData;
    private Table.TableBuilder tableBuilder;
    private static final int TABLE_X_AXIS_START = 40;
    private static final int TABLE_Y_AXIS_START = 330;
    private static final PDFont HEADER_FONT = ReportFont.BOLD_ITALIC_FONT;
    private static final int HEADER_FONT_SIZE = 12;
    private static final PDFont NAME_FONT = ReportFont.ITALIC_FONT;
    private static final int NAME_FONT_SIZE = 11;
    private static final float FEATURE_NAME_COLUMN_WIDTH = 490.0f;
    private static final float HEADER_PADDING = 7.0f;
    private static final float DATA_PADDING = 6.0f;
    public static final float TABLE_SPACE = 290.0f;
    public static final TextLengthOptimizer featureNameTextOptimizer = TextLengthOptimizer.builder().font(NAME_FONT).fontsize(11).availableSpace(478.0f).maxLines(2).build();
    private static final String CROPPED_MESSAGE = "* The feature name has been cropped to fit in the available space.";
    private boolean nameCropped;

    public static float headerRowHeight() {
        return TextUtil.builder().font(HEADER_FONT).fontSize(12).text("Feature Name").width(490.0f).padding(7.0f).build().tableRowHeight();
    }

    public static TextUtil featureNameTextUtil() {
        return TextUtil.builder().font(NAME_FONT).fontSize(11).text("").width(490.0f).padding(6.0f).build();
    }

    @Override
    public void display() {
        this.createTableBuilder();
        this.createHeaderRow();
        this.createDataRows();
        this.drawTable();
        this.croppedMessageDisplay();
    }

    private void createTableBuilder() {
        this.tableBuilder = Table.builder().addColumnsOfWidth(new float[]{30.0f, 490.0f, 35.0f, 35.0f, 35.0f, 35.0f, 100.0f}).borderColor(Color.LIGHT_GRAY).borderWidth(1.0f);
    }

    private void createHeaderRow() {
        this.tableBuilder.addRow(Row.builder().padding(7.0f).horizontalAlignment(HorizontalAlignment.CENTER).font(HEADER_FONT).fontSize(Integer.valueOf(12)).verticalAlignment(VerticalAlignment.MIDDLE).add((AbstractCell)TextCell.builder().text("#").build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Feature Name").horizontalAlignment(HorizontalAlignment.LEFT)).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("T").textColor(this.reportConfig.getFeatureConfig().totalColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("P").textColor(this.reportConfig.passedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("F").textColor(this.reportConfig.failedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("S").textColor(this.reportConfig.skippedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text("Duration").textColor(this.reportConfig.getFeatureConfig().durationColor())).horizontalAlignment(HorizontalAlignment.LEFT)).build()).build());
    }

    private void createDataRows() {
        int sNo = this.paginationData.getItemFromIndex() + 1;
        FeatureData featureData = (FeatureData)this.displayData;
        List<Feature> features = featureData.getFeatures();
        for (int i = 0; i < features.size(); ++i) {
            Feature feature = features.get(i);
            this.tableBuilder.addRow(Row.builder().padding(6.0f).font(NAME_FONT).fontSize(Integer.valueOf(11)).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.TOP).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(sNo)).fontSize(Integer.valueOf(8))).build()).add(this.createFeatureNameCell(feature)).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(feature.getTotalScenarios())).textColor(this.reportConfig.getFeatureConfig().totalColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(feature.getPassedScenarios())).textColor(this.reportConfig.passedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(feature.getFailedScenarios())).textColor(this.reportConfig.failedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text(String.valueOf(feature.getSkippedScenarios())).textColor(this.reportConfig.skippedColor())).build()).add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text(DateUtil.durationValue(feature.calculatedDuration())).textColor(this.reportConfig.getFeatureConfig().durationColor())).horizontalAlignment(HorizontalAlignment.LEFT)).build()).build());
            ++sNo;
        }
    }

    private void drawTable() {
        Object tableDrawer = ((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)((TableCreator.TableCreatorBuilder)TableCreator.builder().tableBuilder(this.tableBuilder)).document(this.document)).startX(40.0f)).startY(330.0f)).pageSupplier(PageCreator.builder().document(this.document).build().landscapePageSupplier())).build();
        ((TableCreator)tableDrawer).displayTable();
    }

    private AbstractCell createFeatureNameCell(Feature feature) {
        TextSanitizer sanitizer = TextSanitizer.builder().build();
        String featureName = sanitizer.sanitizeText(featureNameTextOptimizer.optimizeTextLines(feature.getName()));
        if (featureNameTextOptimizer.isTextTrimmed()) {
            this.nameCropped = true;
        }
        if (this.reportConfig.isDisplayFeature() && this.reportConfig.isDisplayDetailed()) {
            Annotation annotation = Annotation.builder().title(sanitizer.sanitizeText(feature.getName())).build();
            feature.addAnnotation(annotation);
            return ((TextLinkCell.TextLinkCellBuilder)((TextLinkCell.TextLinkCellBuilder)TextLinkCell.builder().annotation(annotation).text(featureName)).horizontalAlignment(HorizontalAlignment.LEFT)).build();
        }
        return ((TextCell.TextCellBuilder)TextCell.builder().text(featureName).horizontalAlignment(HorizontalAlignment.LEFT)).build();
    }

    private void croppedMessageDisplay() {
        if (this.nameCropped) {
            CroppedMessage.builder().content(this.content).message(CROPPED_MESSAGE).build().displayMessage();
        }
    }

    protected FeatureScenarioDetails(FeatureScenarioDetailsBuilder<?, ?> b) {
        super(b);
        this.paginationData = ((FeatureScenarioDetailsBuilder)b).paginationData;
        this.tableBuilder = ((FeatureScenarioDetailsBuilder)b).tableBuilder;
        this.nameCropped = ((FeatureScenarioDetailsBuilder)b).nameCropped;
    }

    public static FeatureScenarioDetailsBuilder<?, ?> builder() {
        return new FeatureScenarioDetailsBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeatureScenarioDetails)) {
            return false;
        }
        FeatureScenarioDetails other = (FeatureScenarioDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.nameCropped != other.nameCropped) {
            return false;
        }
        PaginationData this$paginationData = this.paginationData;
        PaginationData other$paginationData = other.paginationData;
        if (this$paginationData == null ? other$paginationData != null : !((Object)this$paginationData).equals(other$paginationData)) {
            return false;
        }
        Table.TableBuilder this$tableBuilder = this.tableBuilder;
        Table.TableBuilder other$tableBuilder = other.tableBuilder;
        return !(this$tableBuilder == null ? other$tableBuilder != null : !this$tableBuilder.equals(other$tableBuilder));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof FeatureScenarioDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.nameCropped ? 79 : 97);
        PaginationData $paginationData = this.paginationData;
        result = result * 59 + ($paginationData == null ? 43 : ((Object)$paginationData).hashCode());
        Table.TableBuilder $tableBuilder = this.tableBuilder;
        result = result * 59 + ($tableBuilder == null ? 43 : $tableBuilder.hashCode());
        return result;
    }

    private static final class FeatureScenarioDetailsBuilderImpl
    extends FeatureScenarioDetailsBuilder<FeatureScenarioDetails, FeatureScenarioDetailsBuilderImpl> {
        private FeatureScenarioDetailsBuilderImpl() {
        }

        @Override
        protected FeatureScenarioDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public FeatureScenarioDetails build() {
            return new FeatureScenarioDetails(this);
        }
    }

    public static abstract class FeatureScenarioDetailsBuilder<C extends FeatureScenarioDetails, B extends FeatureScenarioDetailsBuilder<C, B>>
    extends Display.DisplayBuilder<C, B> {
        private PaginationData paginationData;
        private Table.TableBuilder tableBuilder;
        private boolean nameCropped;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B paginationData(PaginationData paginationData) {
            this.paginationData = paginationData;
            return (B)this.self();
        }

        public B tableBuilder(Table.TableBuilder tableBuilder) {
            this.tableBuilder = tableBuilder;
            return (B)this.self();
        }

        public B nameCropped(boolean nameCropped) {
            this.nameCropped = nameCropped;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "FeatureScenarioDetails.FeatureScenarioDetailsBuilder(super=" + super.toString() + ", paginationData=" + this.paginationData + ", tableBuilder=" + this.tableBuilder + ", nameCropped=" + this.nameCropped + ")";
        }
    }
}

