/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf.section.expanded;

import tech.grasshopper.pdf.data.ExecutableData;
import tech.grasshopper.pdf.pojo.cucumber.Executable;
import tech.grasshopper.pdf.section.expanded.ExpandedMediaDisplay;
import tech.grasshopper.pdf.structure.Display;
import tech.grasshopper.pdf.structure.PageCreator;
import tech.grasshopper.pdf.structure.Section;

public class ExpandedSection
extends Section {
    static final String SECTION_TITLE = "EXPANDED SECTION";
    private ExecutableData detailedData;

    @Override
    public void createSection() {
        this.detailedData = (ExecutableData)this.displayData;
        boolean initialPageAdded = false;
        float ylocation = 550.0f;
        for (Executable executable : this.detailedData.getExecutables()) {
            if (executable.getMedia().isEmpty()) continue;
            if (!initialPageAdded) {
                PageCreator.builder().document(this.document).build().createLandscapePageWithHeaderAndNumberAndAddToDocument(SECTION_TITLE);
                initialPageAdded = true;
            }
            Display expandedMediaDisplay = ((ExpandedMediaDisplay.ExpandedMediaDisplayBuilder)((ExpandedMediaDisplay.ExpandedMediaDisplayBuilder)((ExpandedMediaDisplay.ExpandedMediaDisplayBuilder)((Display.DisplayBuilder)ExpandedMediaDisplay.builder().executable(executable)).ylocation(ylocation)).document(this.document)).reportConfig(this.reportConfig)).build();
            ((ExpandedMediaDisplay)expandedMediaDisplay).display();
            ylocation = ((ExpandedMediaDisplay)expandedMediaDisplay).getFinalY();
        }
    }

    protected ExpandedSection(ExpandedSectionBuilder<?, ?> b) {
        super(b);
        this.detailedData = ((ExpandedSectionBuilder)b).detailedData;
    }

    public static ExpandedSectionBuilder<?, ?> builder() {
        return new ExpandedSectionBuilderImpl();
    }

    public void setDetailedData(ExecutableData detailedData) {
        this.detailedData = detailedData;
    }

    @Override
    public String toString() {
        return "ExpandedSection(detailedData=" + this.getDetailedData() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpandedSection)) {
            return false;
        }
        ExpandedSection other = (ExpandedSection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ExecutableData this$detailedData = this.getDetailedData();
        ExecutableData other$detailedData = other.getDetailedData();
        return !(this$detailedData == null ? other$detailedData != null : !this$detailedData.equals(other$detailedData));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ExpandedSection;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExecutableData $detailedData = this.getDetailedData();
        result = result * 59 + ($detailedData == null ? 43 : $detailedData.hashCode());
        return result;
    }

    public ExecutableData getDetailedData() {
        return this.detailedData;
    }

    private static final class ExpandedSectionBuilderImpl
    extends ExpandedSectionBuilder<ExpandedSection, ExpandedSectionBuilderImpl> {
        private ExpandedSectionBuilderImpl() {
        }

        @Override
        protected ExpandedSectionBuilderImpl self() {
            return this;
        }

        @Override
        public ExpandedSection build() {
            return new ExpandedSection(this);
        }
    }

    public static abstract class ExpandedSectionBuilder<C extends ExpandedSection, B extends ExpandedSectionBuilder<C, B>>
    extends Section.SectionBuilder<C, B> {
        private ExecutableData detailedData;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B detailedData(ExecutableData detailedData) {
            this.detailedData = detailedData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ExpandedSection.ExpandedSectionBuilder(super=" + super.toString() + ", detailedData=" + this.detailedData + ")";
        }
    }
}

