/*
 * Decompiled with CFR 0.152.
 */
package tech.grasshopper.pdf;

import java.awt.Color;
import java.io.IOException;
import java.util.Comparator;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.vandeseer.easytable.RepeatedHeaderTableDrawer;
import org.vandeseer.easytable.settings.HorizontalAlignment;
import org.vandeseer.easytable.settings.VerticalAlignment;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.cell.AbstractCell;
import org.vandeseer.easytable.structure.cell.TextCell;
import tech.grasshopper.pdf.tablecell.TableWithinTableCell;

public class SplitTrierTC {
    private Table table;
    private PDDocument document;

    public static void main(String[] args) throws IOException {
        SplitTrierTC st = new SplitTrierTC();
        st.createTable();
    }

    public void createTable() throws IOException {
        this.document = new PDDocument();
        PDPage my_page = new PDPage(PDRectangle.A4);
        this.document.addPage(my_page);
        PDPageContentStream content = new PDPageContentStream(this.document, my_page, PDPageContentStream.AppendMode.APPEND, true);
        content.beginText();
        content.setFont((PDFont)PDType1Font.TIMES_ROMAN, 15.0f);
        content.newLineAtOffset(50.0f, 500.0f);
        content.showText("This line is added to ensure table is drawn on new page when space not available.");
        content.endText();
        content.close();
        Table.TableBuilder builder = Table.builder().addColumnsOfWidth(new float[]{50.0f, 400.0f, 50.0f}).borderColor(Color.LIGHT_GRAY).borderWidth(1.0f).font((PDFont)PDType1Font.TIMES_ROMAN).fontSize(Integer.valueOf(13)).verticalAlignment(VerticalAlignment.TOP).horizontalAlignment(HorizontalAlignment.LEFT).padding(5.0f).addRow(Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text("Repeat Row 1").borderWidth(0.0f)).colSpan(3)).build()).build()).addRow(Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)((TextCell.TextCellBuilder)TextCell.builder().text("Repeat Row 2").borderWidth(0.0f)).colSpan(3)).build()).build());
        for (int i = 1; i < 4; ++i) {
            builder.addRow(Row.builder().add((AbstractCell)TextCell.builder().text(String.valueOf(i)).build()).add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("EASYTABLE PDFBoX EASYTABLE PDFBoX EASYTABLE PDFBoX EASYTABLE PDFBoX EASYTABLE PDFBoX EASYTABLE PDFBoX PDFBoX EASYTABLE PDFBoX PDFBoX EASYTABLE PDFBoX ").lineSpacing(1.0f)).build()).add((AbstractCell)TextCell.builder().text(String.valueOf(i * 10)).build()).build());
        }
        Table.TableBuilder intBuilder = Table.builder().addColumnsOfWidth(new float[]{175.0f, 175.0f}).borderColor(Color.GRAY).borderWidth(1.0f).font((PDFont)PDType1Font.TIMES_ROMAN).fontSize(Integer.valueOf(10)).verticalAlignment(VerticalAlignment.MIDDLE).horizontalAlignment(HorizontalAlignment.CENTER).padding(5.0f).addRow(Row.builder().add((AbstractCell)((TextCell.TextCellBuilder)TextCell.builder().text("Cell 000").colSpan(2)).build()).build()).addRow(Row.builder().add((AbstractCell)TextCell.builder().text("Cell 1").build()).add((AbstractCell)TextCell.builder().text("Cell 2").build()).build()).addRow(Row.builder().add((AbstractCell)TextCell.builder().text("Cell 3 big big big details details").build()).add((AbstractCell)TextCell.builder().text("Cell 4 big big big details details").build()).build()).addRow(Row.builder().add((AbstractCell)TextCell.builder().text("Cell 5").build()).add((AbstractCell)TextCell.builder().text("Cell 6").build()).build()).addRow(Row.builder().add((AbstractCell)TextCell.builder().text("Cell 7").build()).add((AbstractCell)TextCell.builder().text("Cell 8").build()).build());
        builder.addRow(Row.builder().add((AbstractCell)TextCell.builder().text("11").build()).add(((TableWithinTableCell.TableWithinTableCellBuilder)((Object)TableWithinTableCell.builder().table(intBuilder.build()))).build()).add((AbstractCell)TextCell.builder().text("33").build()).build());
        this.table = builder.build();
        ((RepeatedHeaderTableDrawer.RepeatedHeaderTableDrawerBuilder)((RepeatedHeaderTableDrawer.RepeatedHeaderTableDrawerBuilder)((RepeatedHeaderTableDrawer.RepeatedHeaderTableDrawerBuilder)((RepeatedHeaderTableDrawer.RepeatedHeaderTableDrawerBuilder)RepeatedHeaderTableDrawer.builder().table(this.table)).startX(50.0f)).startY(350.0f)).endY(50.0f)).numberOfRowsToRepeat(2).build().draw(() -> this.document, () -> new PDPage(PDRectangle.A4), 50.0f);
        this.document.save("target/splittcreport.pdf");
        this.document.close();
    }

    private Float getHighestCellOf(Row row) {
        return row.getCells().stream().map(AbstractCell::getHeight).max(Comparator.naturalOrder()).orElse(Float.valueOf(row.getHeight()));
    }
}

