/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.binding;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.concurrent.CompletableFuture;
import tech.deplant.java4ever.binding.Crypto;
import tech.deplant.java4ever.binding.EverSdk;
import tech.deplant.java4ever.binding.EverSdkException;

public final class Client {
    public static CompletableFuture<ResultOfGetApiReference> getApiReference(int ctxId) throws EverSdkException {
        return EverSdk.async(ctxId, "client.get_api_reference", null, ResultOfGetApiReference.class);
    }

    public static CompletableFuture<ResultOfVersion> version(int ctxId) throws EverSdkException {
        return EverSdk.async(ctxId, "client.version", null, ResultOfVersion.class);
    }

    public static CompletableFuture<ClientConfig> config(int ctxId) throws EverSdkException {
        return EverSdk.async(ctxId, "client.config", null, ClientConfig.class);
    }

    public static CompletableFuture<ResultOfBuildInfo> buildInfo(int ctxId) throws EverSdkException {
        return EverSdk.async(ctxId, "client.build_info", null, ResultOfBuildInfo.class);
    }

    public static void resolveAppRequest(int ctxId, Long appRequestId, AppRequestResult result) throws EverSdkException {
        EverSdk.asyncVoid(ctxId, "client.resolve_app_request", new ParamsOfResolveAppRequest(appRequestId, result));
    }

    public record ResultOfGetApiReference(JsonNode api) {
    }

    public record ResultOfVersion(String version) {
    }

    public record ClientConfig(BindingConfig binding, NetworkConfig network, CryptoConfig crypto, AbiConfig abi, BocConfig boc, ProofsConfig proofs, String localStoragePath) {
    }

    public record ResultOfBuildInfo(Long buildNumber, BuildInfoDependency[] dependencies) {
    }

    public record ParamsOfResolveAppRequest(Long appRequestId, AppRequestResult result) {
    }

    public static sealed interface AppRequestResult {

        public record Ok(JsonNode result) implements AppRequestResult
        {
            @JsonProperty(value="type")
            public String type() {
                return "Ok";
            }
        }

        public record Error(String text) implements AppRequestResult
        {
            @JsonProperty(value="type")
            public String type() {
                return "Error";
            }
        }
    }

    public record CryptoConfig(Crypto.MnemonicDictionary mnemonicDictionary, Integer mnemonicWordCount, String hdkeyDerivationPath) {
    }

    public static enum NetworkQueriesProtocol {
        HTTP,
        WS;

    }

    public record BocConfig(Long cacheMaxSize) {
    }

    public record ParamsOfAppRequest(Long appRequestId, JsonNode requestData) {
    }

    public record NetworkConfig(String serverAddress, String[] endpoints, Integer networkRetriesCount, Long maxReconnectTimeout, Long reconnectTimeout, Integer messageRetriesCount, Long messageProcessingTimeout, Long waitForTimeout, Long outOfSyncThreshold, Integer sendingEndpointCount, Long latencyDetectionInterval, Long maxLatency, Long queryTimeout, NetworkQueriesProtocol queriesProtocol, Long firstRempStatusTimeout, Long nextRempStatusTimeout, Long signatureId, String accessKey) {
    }

    public record ClientError(Long code, String message, JsonNode data) {
    }

    public record ProofsConfig(Boolean cacheInLocalStorage) {
    }

    public record BindingConfig(String library, String version) {
    }

    public record BuildInfoDependency(String name, String gitCommit) {
    }

    public record AbiConfig(Long workchain, Long messageExpirationTimeout, Long messageExpirationTimeoutGrowFactor) {
    }

    public static enum ClientErrorCode {
        NotImplemented(1),
        InvalidHex(2),
        InvalidBase64(3),
        InvalidAddress(4),
        CallbackParamsCantBeConvertedToJson(5),
        WebsocketConnectError(6),
        WebsocketReceiveError(7),
        WebsocketSendError(8),
        HttpClientCreateError(9),
        HttpRequestCreateError(10),
        HttpRequestSendError(11),
        HttpRequestParseError(12),
        CallbackNotRegistered(13),
        NetModuleNotInit(14),
        InvalidConfig(15),
        CannotCreateRuntime(16),
        InvalidContextHandle(17),
        CannotSerializeResult(18),
        CannotSerializeError(19),
        CannotConvertJsValueToJson(20),
        CannotReceiveSpawnedResult(21),
        SetTimerError(22),
        InvalidParams(23),
        ContractsAddressConversionFailed(24),
        UnknownFunction(25),
        AppRequestError(26),
        NoSuchRequest(27),
        CanNotSendRequestResult(28),
        CanNotReceiveRequestResult(29),
        CanNotParseRequestResult(30),
        UnexpectedCallbackResponse(31),
        CanNotParseNumber(32),
        InternalError(33),
        InvalidHandle(34),
        LocalStorageError(35),
        InvalidData(36);

        private final Integer value;

        private ClientErrorCode(Integer value) {
            this.value = value;
        }

        @JsonValue
        public Integer value() {
            return this.value;
        }
    }
}

