/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.datatype;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Objects;
import tech.deplant.commons.Numbers;
import tech.deplant.commons.Strings;
import tech.deplant.java4ever.framework.datatype.AbiType;
import tech.deplant.java4ever.framework.datatype.AbiTypePrefix;
import tech.deplant.java4ever.framework.datatype.AbiValue;

public final class Uint
extends Record
implements AbiValue<BigInteger> {
    private final int size;
    private final BigInteger value;

    @JsonCreator
    public Uint(Object value) {
        BigInteger bigInteger;
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        block9: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, BigInteger.class, BigDecimal.class, Instant.class, String.class, String.class}, (Object)object2, n)) {
                case 0: {
                    Integer i = (Integer)object2;
                    bigInteger = BigInteger.valueOf(i.intValue()).abs();
                    break block9;
                }
                case 1: {
                    Long l = (Long)object2;
                    bigInteger = BigInteger.valueOf(l).abs();
                    break block9;
                }
                case 2: {
                    BigInteger bi = (BigInteger)object2;
                    bigInteger = bi.abs();
                    break block9;
                }
                case 3: {
                    BigDecimal bd = (BigDecimal)object2;
                    bigInteger = bd.toBigInteger().abs();
                    break block9;
                }
                case 4: {
                    Instant inst = (Instant)object2;
                    bigInteger = BigInteger.valueOf(inst.getEpochSecond()).abs();
                    break block9;
                }
                case 5: {
                    String str = (String)object2;
                    if (!Strings.isHexadecimal((String)str)) {
                        n = 6;
                        continue block9;
                    }
                    bigInteger = Numbers.hexStringToBigInt((String)str);
                    break block9;
                }
                case 6: {
                    String str = (String)object2;
                    bigInteger = new BigInteger(str);
                    break block9;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(value) + " class: " + value.getClass().getName());
                }
            }
            break;
        }
        this(bigInteger);
    }

    public Uint(BigInteger value) {
        this(0, value);
    }

    public Uint(int size, BigInteger value) {
        this.size = size;
        this.value = value;
    }

    public static Uint of(int size, Object objectValue) {
        Uint uint;
        Object object = objectValue;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        block10: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, BigInteger.class, BigDecimal.class, Instant.class, String.class, String.class, String.class}, (Object)object2, n)) {
                case 0: {
                    Integer i = (Integer)object2;
                    uint = new Uint(size, BigInteger.valueOf(i.intValue()).abs());
                    break block10;
                }
                case 1: {
                    Long l = (Long)object2;
                    uint = new Uint(size, BigInteger.valueOf(l).abs());
                    break block10;
                }
                case 2: {
                    BigInteger bi = (BigInteger)object2;
                    uint = new Uint(size, bi.abs());
                    break block10;
                }
                case 3: {
                    BigDecimal bd = (BigDecimal)object2;
                    uint = new Uint(size, bd.toBigInteger().abs());
                    break block10;
                }
                case 4: {
                    Instant inst = (Instant)object2;
                    uint = new Uint(size, BigInteger.valueOf(inst.getEpochSecond()).abs());
                    break block10;
                }
                case 5: {
                    String str = (String)object2;
                    if (str.length() < 3 || !"-0x".equals(str.substring(0, 3)) && !"0x".equals(str.substring(0, 2))) {
                        n = 6;
                        continue block10;
                    }
                    uint = new Uint(size, Numbers.hexStringToBigInt((String)str));
                    break block10;
                }
                case 6: {
                    String str = (String)object2;
                    if (str.matches("[0-9]+")) {
                        n = 7;
                        continue block10;
                    }
                    uint = new Uint(size, Numbers.hexStringToBigInt((String)str));
                    break block10;
                }
                case 7: {
                    String str = (String)object2;
                    uint = new Uint(size, new BigInteger(str));
                    break block10;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(objectValue) + " class: " + objectValue.getClass().getName());
                }
            }
            break;
        }
        return uint;
    }

    public BigInteger toBigInteger() {
        return this.value();
    }

    @Override
    public String toString() {
        return "0x" + this.value().toString(16);
    }

    @Override
    public BigInteger toJava() {
        return this.toBigInteger();
    }

    @Override
    @JsonValue
    public String toABI() {
        return this.toString();
    }

    @Override
    public AbiType type() {
        return new AbiType(AbiTypePrefix.UINT, this.size(), false);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Uint.class, "size;value", "size", "value"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Uint.class, "size;value", "size", "value"}, this, o);
    }

    public int size() {
        return this.size;
    }

    public BigInteger value() {
        return this.value;
    }
}

