/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.datatype;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.util.Objects;
import tech.deplant.commons.Strings;
import tech.deplant.java4ever.framework.datatype.AbiType;
import tech.deplant.java4ever.framework.datatype.AbiTypePrefix;
import tech.deplant.java4ever.framework.datatype.AbiValue;
import tech.deplant.java4ever.framework.datatype.Uint;

public record Address(int wid, BigInteger value) implements AbiValue<String>
{
    public static final Address ZERO = new Address(0, BigInteger.ZERO);

    @JsonCreator
    public Address(String address) {
        this(Integer.parseInt(address.split(":")[0]), new BigInteger(address.split(":")[1], 16));
    }

    public Address(int wid, String hash) {
        this(wid, Uint.of(256, (Object)hash).toBigInteger());
    }

    public Address(BigInteger value) {
        this(0, value);
    }

    public static Address fromJava(Object input) {
        Object object = input;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Address.class, String.class, BigInteger.class}, (Object)object2, n)) {
            case 0 -> {
                Address a;
                yield a = (Address)object2;
            }
            case 1 -> {
                String s = (String)object2;
                yield new Address(s);
            }
            case 2 -> {
                BigInteger bi = (BigInteger)object2;
                yield new Address(0, bi);
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(input) + " class: " + input.getClass().getName());
        };
    }

    public static Address fromABI(Object output) {
        return new Address(output.toString());
    }

    public static Address ofNullable(Object nullableObject) {
        return null == nullableObject ? ZERO : new Address(nullableObject.toString());
    }

    public boolean isZeroAddress() {
        return this.value.equals(BigInteger.ZERO);
    }

    public String makeAddrStd() {
        return this.toString();
    }

    @Override
    public String toString() {
        return this.wid() + ":" + Strings.padLeftZeros((String)this.value().toString(16), (int)64);
    }

    @Override
    public String toJava() {
        return this.toString();
    }

    @Override
    @JsonValue
    public String toABI() {
        return this.toString();
    }

    @Override
    public AbiType type() {
        return new AbiType(AbiTypePrefix.ADDRESS, 0, false);
    }
}

