/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import java.util.concurrent.CompletableFuture;
import tech.deplant.java4ever.binding.Crypto;
import tech.deplant.java4ever.binding.EverSdk;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Credentials;

public record Seed(String phrase, int words, Crypto.MnemonicDictionary dictionary) {
    public static final int DEFAULT_WORD_COUNT = 12;
    public static final int TON_WORD_COUNT = 24;
    public static final String HD_PATH = "m/44'/396'/0'/0/0";

    public Seed(String phrase, int words) {
        this(phrase, words, Crypto.MnemonicDictionary.English);
    }

    private static String generateMnemonicPhraseFromRandom(int contextId, int words) throws EverSdkException {
        return ((Crypto.ResultOfMnemonicFromRandom)EverSdk.await((CompletableFuture)Crypto.mnemonicFromRandom((int)contextId, (Crypto.MnemonicDictionary)Crypto.MnemonicDictionary.English, (Integer)words))).phrase();
    }

    public static Seed ofRandom(int contextId) throws EverSdkException {
        return new Seed(((Crypto.ResultOfMnemonicFromRandom)EverSdk.await((CompletableFuture)Crypto.mnemonicFromRandom((int)contextId, (Crypto.MnemonicDictionary)Crypto.MnemonicDictionary.English, (Integer)12))).phrase(), 12, Crypto.MnemonicDictionary.English);
    }

    public static Seed ofRandomTon(int contextId) throws EverSdkException {
        return new Seed(((Crypto.ResultOfMnemonicFromRandom)EverSdk.await((CompletableFuture)Crypto.mnemonicFromRandom((int)contextId, (Crypto.MnemonicDictionary)Crypto.MnemonicDictionary.Ton, (Integer)24))).phrase(), 24, Crypto.MnemonicDictionary.Ton);
    }

    public boolean verifySeedPhrase(int contextId) throws EverSdkException {
        return ((Crypto.ResultOfMnemonicVerify)EverSdk.await((CompletableFuture)Crypto.mnemonicVerify((int)contextId, (String)this.phrase(), (Crypto.MnemonicDictionary)this.dictionary(), (Integer)this.words()))).valid();
    }

    public Credentials deriveCredentials(int contextId, String path) throws EverSdkException {
        Crypto.KeyPair derived = (Crypto.KeyPair)EverSdk.await((CompletableFuture)Crypto.mnemonicDeriveSignKeys((int)contextId, (String)this.phrase(), (String)path, (Crypto.MnemonicDictionary)this.dictionary(), (Integer)this.words()));
        return new Credentials(derived.publicKey(), derived.secretKey());
    }

    public Credentials deriveCredentials(int contextId) throws EverSdkException {
        return this.deriveCredentials(contextId, null);
    }
}

