/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.datatype;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.nio.charset.StandardCharsets;
import tech.deplant.commons.Strings;
import tech.deplant.java4ever.framework.datatype.AbiType;
import tech.deplant.java4ever.framework.datatype.AbiTypePrefix;
import tech.deplant.java4ever.framework.datatype.AbiValue;

public record SolBytes(int size, byte[] value) implements AbiValue
{
    public SolBytes(byte[] value) {
        this(0, value);
    }

    public SolBytes(int size, String hexValue) {
        this(size, Strings.hexStringToBytes((String)hexValue.toUpperCase()));
    }

    @JsonCreator
    public SolBytes(String hexValue) {
        this(0, hexValue);
    }

    public byte[] toBytes() {
        return this.value();
    }

    public String toHexString() {
        return Strings.toHexString((byte[])this.value());
    }

    @Override
    public String toString() {
        return new String(this.value(), StandardCharsets.UTF_8);
    }

    public Object toJava() {
        return this.toBytes();
    }

    @Override
    @JsonValue
    public String toABI() {
        return Strings.toHexString((byte[])this.value());
    }

    @Override
    public AbiType type() {
        return new AbiType(AbiTypePrefix.BYTES, this.size(), false);
    }
}

