/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import java.math.BigDecimal;
import java.math.BigInteger;

public interface CurrencyUnit {
    public BigDecimal factor();

    public int decimals();

    public static BigInteger VALUE(CurrencyUnit unit, String amount) {
        return CurrencyUnit.VALUE(unit, new BigDecimal(amount));
    }

    public static BigInteger VALUE(CurrencyUnit unit, BigDecimal amount) {
        return amount.multiply(unit.factor()).toBigInteger();
    }

    default public BigInteger nanos(BigDecimal decimalAmount) {
        return decimalAmount.multiply(this.factor()).toBigInteger();
    }

    default public BigInteger nanos(String stringAmount) {
        return this.nanos(new BigDecimal(stringAmount));
    }

    public static enum Tokens implements CurrencyUnit
    {
        QUBE(9),
        BRIDGE(9),
        LEND(9),
        WETH(18);

        private final BigDecimal factor;
        private final int decimals;

        private Tokens(int decimals) {
            this.decimals = decimals;
            this.factor = BigDecimal.TEN.pow(decimals);
        }

        @Override
        public int decimals() {
            return this.decimals;
        }

        @Override
        public BigDecimal factor() {
            return this.factor;
        }
    }

    public static enum Ever implements CurrencyUnit
    {
        NANOEVER(0),
        MICROEVER(3),
        MILLIEVER(6),
        EVER(9),
        KILOEVER(12),
        MEGAEVER(15),
        GIGAEVER(18);

        private final BigDecimal factor;
        private final int decimals;

        private Ever(int decimals) {
            this.decimals = decimals;
            this.factor = BigDecimal.TEN.pow(decimals);
        }

        @Override
        public int decimals() {
            return this.decimals;
        }

        @Override
        public BigDecimal factor() {
            return this.factor;
        }
    }

    public static class CustomToken
    implements CurrencyUnit {
        private final BigDecimal factor;
        private final int decimals;

        public CustomToken(int decimals) {
            this.decimals = decimals;
            this.factor = BigDecimal.TEN.pow(decimals);
        }

        @Override
        public BigDecimal factor() {
            return this.factor;
        }

        @Override
        public int decimals() {
            return this.decimals;
        }
    }
}

