/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.Map;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.EverSdkContext;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.artifact.JsonFile;
import tech.deplant.java4ever.framework.artifact.JsonResource;
import tech.deplant.java4ever.framework.datatype.SolStruct;
import tech.deplant.java4ever.framework.datatype.Uint;

public record ContractAbi(Abi.AbiContract abiContract) {
    private static final System.Logger logger = System.getLogger(ContractAbi.class.getName());

    public static ContractAbi ofString(String jsonString) throws JsonProcessingException {
        return new ContractAbi((Abi.AbiContract)JsonContext.ABI_JSON_MAPPER().readValue(jsonString, Abi.AbiContract.class));
    }

    public static ContractAbi ofResource(String resourceName) throws JsonProcessingException {
        return ContractAbi.ofString(new JsonResource(resourceName).get());
    }

    public static ContractAbi ofFile(String filePath) throws JsonProcessingException {
        return ContractAbi.ofString(new JsonFile(filePath).get());
    }

    public static ContractAbi ofJsonNode(JsonNode node) throws JsonProcessingException {
        return ContractAbi.ofString(JsonContext.ABI_JSON_MAPPER().writeValueAsString((Object)node));
    }

    public String json() throws JsonProcessingException {
        return JsonContext.ABI_JSON_MAPPER().setSerializationInclusion(JsonInclude.Include.NON_NULL).writeValueAsString((Object)this.abiContract());
    }

    public String functionId(Sdk sdk, String name) throws EverSdkException {
        return Uint.of(32, (Object)Abi.calcFunctionId((EverSdkContext)sdk.context(), (Abi.ABI)this.ABI(), (String)name, (Boolean)false).functionId()).toABI();
    }

    public boolean hasHeader(String name) {
        return Arrays.asList(this.header()).contains(name);
    }

    public boolean hasFunction(String name) {
        return Arrays.stream(this.functions()).anyMatch(function -> name.equals(function.name()));
    }

    public boolean hasInitDataParam(String initDataName) {
        return Arrays.stream(this.data()).anyMatch(data -> initDataName.equals(data.name()));
    }

    public boolean hasInput(String functionName, String inputName) {
        return Arrays.stream(this.functions()).anyMatch(function -> functionName.equals(function.name()) && Arrays.stream(function.inputs()).anyMatch(input -> inputName.equals(input.name())));
    }

    public boolean hasOutput(String functionName, String outputName) {
        return Arrays.stream(this.functions()).anyMatch(function -> functionName.equals(function.name()) && Arrays.stream(function.outputs()).anyMatch(output -> outputName.equals(output.name())));
    }

    private Abi.AbiFunction findFunction(String name) {
        return Arrays.stream(this.functions()).filter(function -> name.equals(function.name())).findAny().orElseThrow();
    }

    private Abi.AbiEvent findEvent(String name) {
        return Arrays.stream(this.events()).filter(event -> name.equals(event.name())).findAny().orElseThrow();
    }

    private Abi.AbiParam findParam(Abi.AbiParam[] paramArr, String name) {
        return Arrays.stream(paramArr).filter(input -> name.equals(input.name())).findAny().orElseThrow();
    }

    public Abi.AbiParam functionInputType(String functionName, String inputName) {
        return this.findParam(this.findFunction(functionName).inputs(), inputName);
    }

    public Abi.AbiParam initDataType(String initDataName) {
        Abi.AbiData dataParam = Arrays.stream(this.data()).filter(data -> initDataName.equals(data.name())).findAny().orElseThrow();
        return new Abi.AbiParam(dataParam.name(), dataParam.type(), dataParam.components());
    }

    public Abi.AbiParam functionOutputType(String functionName, String outputName) {
        return this.findParam(this.findFunction(functionName).outputs(), outputName);
    }

    public Abi.AbiParam eventInputType(String functionName, String inputName) {
        return this.findParam(this.findEvent(functionName).inputs(), inputName);
    }

    public Abi.AbiData[] data() {
        return this.abiContract().data();
    }

    public Abi.AbiFunction[] functions() {
        return this.abiContract().functions();
    }

    public Abi.AbiEvent[] events() {
        return this.abiContract().events();
    }

    public String[] header() {
        return this.abiContract().header();
    }

    public Abi.ABI ABI() {
        return new Abi.ABI.Contract(this.abiContract());
    }

    public Abi.ABI functionCallABI(String functionName) {
        return new Abi.ABI.Contract(new Abi.AbiContract(this.abiContract().abiVersionMajor(), this.abiContract().abiVersion(), this.abiContract().version(), this.abiContract().header(), new Abi.AbiFunction[]{this.findFunction(functionName)}, new Abi.AbiEvent[0], new Abi.AbiData[0], new Abi.AbiParam[0]));
    }

    public Map<String, Object> convertFunctionOutputs(String functionName, Map<String, Object> functionOutputs) throws EverSdkException {
        Abi.AbiParam[] functionParams = Arrays.stream(this.functions()).filter(function -> functionName.equals(function.name())).findAny().orElseThrow(() -> new EverSdkException(new EverSdkException.ErrorResult(-303L, "No such function: " + functionName + " in ABI"), (Throwable)new Exception())).outputs();
        return SolStruct.fromABI(functionParams, functionOutputs).values();
    }

    public Map<String, Object> convertFunctionInputs(String functionName, Map<String, Object> functionInputs) throws EverSdkException {
        Abi.AbiParam[] functionParams = Arrays.stream(this.functions()).filter(function -> functionName.equals(function.name())).findAny().orElseThrow(() -> new EverSdkException(new EverSdkException.ErrorResult(-303L, "No such function: " + functionName + " in ABI"), (Throwable)new Exception())).inputs();
        return SolStruct.fromJava(functionParams, functionInputs).values();
    }

    public Map<String, Object> convertInitDataInputs(Map<String, Object> initDataInputs) throws EverSdkException {
        Abi.AbiParam[] initDataParams = (Abi.AbiParam[])Arrays.stream(this.data()).map(data -> new Abi.AbiParam(data.name(), data.type(), data.components())).toArray(Abi.AbiParam[]::new);
        return SolStruct.fromJava(initDataParams, initDataInputs).values();
    }
}

