/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import tech.deplant.commons.Objs;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.EverSdkContext;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.binding.JsonContext;
import tech.deplant.java4ever.binding.Processing;
import tech.deplant.java4ever.framework.ContractAbi;
import tech.deplant.java4ever.framework.Credentials;
import tech.deplant.java4ever.framework.DebugOptions;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.Tvc;
import tech.deplant.java4ever.framework.contract.AbstractContract;
import tech.deplant.java4ever.framework.contract.Contract;
import tech.deplant.java4ever.framework.contract.Giver;
import tech.deplant.java4ever.framework.datatype.Address;
import tech.deplant.java4ever.framework.template.AbstractTemplate;
import tech.deplant.java4ever.framework.template.Template;

public record DeployHandle<RETURN extends Contract>(Class<RETURN> clazz, Sdk sdk, Template template, long workchainId, Credentials credentials, Map<String, Object> initialDataFields, Map<String, Object> constructorInputs, Abi.FunctionHeader constructorHeader, DebugOptions debugOptions) {
    private static System.Logger logger = System.getLogger(DeployHandle.class.getName());
    private static JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().addModules(new Module[]{new ParameterNamesModule(), new Jdk8Module(), new JavaTimeModule()})).build();

    public DeployHandle(Class<RETURN> clazz, Sdk sdk, ContractAbi abi, Tvc tvc, long workchainId, Credentials credentials, Map<String, Object> initialDataFields, Map<String, Object> constructorInputs, Abi.FunctionHeader constructorHeader) {
        this(clazz, sdk, new AbstractTemplate(abi, tvc), workchainId, credentials, initialDataFields, constructorInputs, constructorHeader);
    }

    public DeployHandle(Class<RETURN> clazz, Sdk sdk, Template template, long workchainId, Credentials credentials, Map<String, Object> initialDataFields, Map<String, Object> constructorInputs, Abi.FunctionHeader constructorHeader) {
        this(clazz, sdk, template, workchainId, credentials, initialDataFields, constructorInputs, constructorHeader, new DebugOptions(false, 60000L, false, new ContractAbi[0]));
    }

    public DeployHandle<RETURN> withDebugTree(boolean enabled, long timeout, boolean throwErrors, ContractAbi ... treeAbis) {
        return new DeployHandle<RETURN>(this.clazz(), this.sdk(), this.template(), this.workchainId(), this.credentials(), this.initialDataFields(), this.constructorInputs(), this.constructorHeader(), new DebugOptions(enabled, timeout, throwErrors, treeAbis));
    }

    public DeployHandle<RETURN> withDebugTree(DebugOptions debugOptions) {
        return new DeployHandle<RETURN>(this.clazz(), this.sdk(), this.template(), this.workchainId(), this.credentials(), this.initialDataFields(), this.constructorInputs(), this.constructorHeader(), debugOptions);
    }

    public <T extends Contract> DeployHandle<T> withReturnClass(Class<T> returnClass) {
        return new DeployHandle<T>(returnClass, this.sdk(), this.template(), this.workchainId(), this.credentials(), this.initialDataFields(), this.constructorInputs(), this.constructorHeader());
    }

    public DeployHandle<RETURN> withConstructorHeader(Abi.FunctionHeader constructorHeader) {
        return new DeployHandle<RETURN>(this.clazz(), this.sdk(), this.template(), this.workchainId(), this.credentials(), this.initialDataFields(), this.constructorInputs(), constructorHeader);
    }

    public DeployHandle<RETURN> withConstructorInputs(Map<String, Object> constructorInputs) {
        return new DeployHandle<RETURN>(this.clazz(), this.sdk(), this.template(), this.workchainId(), this.credentials(), this.initialDataFields(), constructorInputs, this.constructorHeader());
    }

    public DeployHandle<RETURN> withInitDataFields(Map<String, Object> initialDataFields) {
        return new DeployHandle<RETURN>(this.clazz(), this.sdk(), this.template(), this.workchainId(), this.credentials(), initialDataFields, this.constructorInputs(), this.constructorHeader());
    }

    public DeployHandle<RETURN> withCredentials(Credentials credentials) {
        return new DeployHandle<RETURN>(this.clazz(), this.sdk(), this.template(), this.workchainId(), credentials, this.initialDataFields(), this.constructorInputs(), this.constructorHeader());
    }

    public Abi.DeploySet toDeploySet() throws EverSdkException {
        return new Abi.DeploySet(this.template().tvc().base64String(), null, null, Long.valueOf(this.workchainId()), JsonContext.ABI_JSON_MAPPER().valueToTree(this.template().abi().convertInitDataInputs(this.initialDataFields())), Objects.requireNonNullElse(this.credentials(), Credentials.NONE).publicKey());
    }

    public Abi.CallSet toConstructorCallSet() throws EverSdkException {
        return new Abi.CallSet("constructor", this.constructorHeader(), JsonContext.ABI_JSON_MAPPER().valueToTree(this.template().abi().convertFunctionInputs("constructor", this.constructorInputs())));
    }

    public Abi.Signer toSigner() {
        return ((Credentials)Objs.notNullElse((Object)this.credentials(), (Object)Credentials.NONE)).signer();
    }

    public String toAddress() throws EverSdkException {
        return Abi.encodeMessage((EverSdkContext)this.sdk().context(), (Abi.ABI)this.template().abi().ABI(), null, (Abi.DeploySet)this.toDeploySet(), null, (Abi.Signer)this.toSigner(), null, null).address();
    }

    public RETURN deployWithGiver(Giver giver, BigInteger value) throws EverSdkException {
        String address = this.toAddress();
        try {
            new AbstractContract(this.sdk(), address, this.template().abi()).waitForTransaction(new Address(giver.address()), false, () -> {
                try {
                    giver.give(address, value).callTree(false, new ContractAbi[0]);
                }
                catch (EverSdkException e) {
                    logger.log(System.Logger.Level.ERROR, () -> "Error! Message: " + e.getMessage());
                    throw new RuntimeException(e);
                }
            });
            return this.deploy(address);
        }
        catch (InterruptedException e) {
            logger.log(System.Logger.Level.ERROR, () -> "Wait for giver funds interrupted! Message: " + e.getMessage());
            throw new EverSdkException(new EverSdkException.ErrorResult(-400L, "EVER-SDK call interrupted!"), (Throwable)e);
        }
        catch (TimeoutException e) {
            logger.log(System.Logger.Level.ERROR, () -> "Wait for giver funds timeout! Timeout: " + this.sdk().context().timeout() + " Message: " + e.getMessage());
            throw new EverSdkException(new EverSdkException.ErrorResult(-402L, "EVER-SDK Execution expired on Timeout! Current timeout: " + this.sdk().context().timeout()), (Throwable)e);
        }
    }

    public RETURN deploy() throws EverSdkException {
        String address = this.toAddress();
        return this.deploy(address);
    }

    private RETURN deploy(String address) throws EverSdkException {
        Processing.processMessage((EverSdkContext)this.sdk().context(), (Abi.ABI)this.template().abi().ABI(), (String)address, (Abi.DeploySet)this.toDeploySet(), (Abi.CallSet)this.toConstructorCallSet(), (Abi.Signer)this.toSigner(), null, null, (Boolean)false);
        Map<String, Credentials> contractMap = Map.of("sdk", this.sdk(), "address", address, "abi", this.template().abi(), "credentials", this.credentials());
        return (RETURN)((Contract)Contract.instantiate(this.clazz(), this.sdk(), address, this.template().abi(), this.credentials()));
    }
}

