/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.Map;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.EverSdkContext;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Sdk;
import tech.deplant.java4ever.framework.artifact.JsonFile;
import tech.deplant.java4ever.framework.artifact.JsonResource;
import tech.deplant.java4ever.framework.datatype.SolStruct;
import tech.deplant.java4ever.framework.datatype.TypePrefix;
import tech.deplant.java4ever.framework.datatype.Uint;

public record ContractAbi(Abi.AbiContract abiContract) {
    private static final System.Logger logger = System.getLogger(ContractAbi.class.getName());

    public static ContractAbi ofString(String jsonString) throws JsonProcessingException {
        return new ContractAbi((Abi.AbiContract)EverSdkContext.Builder.DEFAULT_MAPPER.readValue(jsonString, Abi.AbiContract.class));
    }

    public static ContractAbi ofResource(String resourceName) throws JsonProcessingException {
        return ContractAbi.ofString(new JsonResource(resourceName).get());
    }

    public static ContractAbi ofFile(String filePath) throws JsonProcessingException {
        return ContractAbi.ofString(new JsonFile(filePath).get());
    }

    public static ContractAbi ofJsonNode(JsonNode node) throws JsonProcessingException {
        return ContractAbi.ofString(EverSdkContext.Builder.DEFAULT_MAPPER.writeValueAsString((Object)node));
    }

    public String json() throws JsonProcessingException {
        return EverSdkContext.Builder.DEFAULT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL).writeValueAsString((Object)this.abiContract());
    }

    public String functionId(Sdk sdk, String name) throws EverSdkException {
        return Uint.fromJava(32, Abi.calcFunctionId((EverSdkContext)sdk.context(), (Abi.ABI)this.ABI(), (String)name, (Boolean)false).functionId()).toABI();
    }

    public boolean hasHeader(String name) {
        return Arrays.asList(this.header()).contains(name);
    }

    public boolean hasFunction(String name) {
        return Arrays.stream(this.functions()).anyMatch(function -> name.equals(function.name()));
    }

    public boolean hasInitDataParam(String initDataName) {
        return Arrays.stream(this.data()).anyMatch(data -> initDataName.equals(data.name()));
    }

    public boolean hasInput(String functionName, String inputName) {
        return Arrays.stream(this.functions()).anyMatch(function -> functionName.equals(function.name()) && Arrays.stream(function.inputs()).anyMatch(input -> inputName.equals(input.name())));
    }

    public boolean hasOutput(String functionName, String outputName) {
        return Arrays.stream(this.functions()).anyMatch(function -> functionName.equals(function.name()) && Arrays.stream(function.outputs()).anyMatch(output -> outputName.equals(output.name())));
    }

    private Abi.AbiFunction findFunction(Abi.AbiFunction[] functionArr, String name) {
        return Arrays.stream(functionArr).filter(function -> name.equals(function.name())).findAny().orElseThrow();
    }

    private Abi.AbiEvent findEvent(Abi.AbiEvent[] functionArr, String name) {
        return Arrays.stream(functionArr).filter(event -> name.equals(event.name())).findAny().orElseThrow();
    }

    private Abi.AbiParam findParam(Abi.AbiParam[] paramArr, String name) {
        return Arrays.stream(paramArr).filter(input -> name.equals(input.name())).findAny().orElseThrow();
    }

    public Abi.AbiParam functionInputType(String functionName, String inputName) {
        return this.findParam(this.findFunction(this.functions(), functionName).inputs(), inputName);
    }

    public Abi.AbiParam initDataType(String initDataName) {
        Abi.AbiData dataParam = Arrays.stream(this.data()).filter(data -> initDataName.equals(data.name())).findAny().orElseThrow();
        return new Abi.AbiParam(dataParam.name(), dataParam.type(), dataParam.components());
    }

    public Abi.AbiParam functionOutputType(String functionName, String outputName) {
        return this.findParam(this.findFunction(this.functions(), functionName).outputs(), outputName);
    }

    public Abi.AbiParam eventInputType(String functionName, String inputName) {
        return this.findParam(this.findEvent(this.events(), functionName).inputs(), inputName);
    }

    public Abi.AbiData[] data() {
        return this.abiContract().data();
    }

    public Abi.AbiFunction[] functions() {
        return this.abiContract().functions();
    }

    public Abi.AbiEvent[] events() {
        return this.abiContract().events();
    }

    public String[] header() {
        return this.abiContract().header();
    }

    public Abi.ABI ABI() {
        return new Abi.ABI.Contract(this.abiContract());
    }

    public Map<String, Object> convertFunctionOutputs(String functionName, Map<String, Object> functionOutputs) throws EverSdkException {
        Abi.AbiParam[] functionParams = Arrays.stream(this.functions()).filter(function -> functionName.equals(function.name())).findAny().orElseThrow(() -> new EverSdkException(new EverSdkException.ErrorResult(-303, "No such function: " + functionName + " in ABI"), (Throwable)new Exception())).outputs();
        return SolStruct.fromABI(functionParams, functionOutputs).values();
    }

    public Map<String, Object> convertFunctionInputs(String functionName, Map<String, Object> functionInputs) throws EverSdkException {
        Abi.AbiParam[] functionParams = Arrays.stream(this.functions()).filter(function -> functionName.equals(function.name())).findAny().orElseThrow(() -> new EverSdkException(new EverSdkException.ErrorResult(-303, "No such function: " + functionName + " in ABI"), (Throwable)new Exception())).inputs();
        return SolStruct.fromJava(functionParams, functionInputs).values();
    }

    public Map<String, Object> convertInitDataInputs(Map<String, Object> initDataInputs) throws EverSdkException {
        Abi.AbiParam[] initDataParams = (Abi.AbiParam[])Arrays.stream(this.data()).map(data -> new Abi.AbiParam(data.name(), data.type(), data.components())).toArray(Abi.AbiParam[]::new);
        return SolStruct.fromJava(initDataParams, initDataInputs).values();
    }

    public record AbiTypeDetails(TypePrefix type, int size, boolean isArray) {
    }
}

