/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.HexFormat;
import java.util.TimeZone;

public class Data {
    private static System.Logger logger = System.getLogger(Data.class.getName());

    public static String base64ToHexString(String base64string) {
        return HexFormat.of().formatHex(Base64.getDecoder().decode(base64string));
    }

    public static LocalDateTime longToDateTime(long unixTime) {
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(unixTime), TimeZone.getTimeZone("Europe/Moscow").toZoneId());
    }

    public static String dateTimeToString(LocalDateTime dateTime) {
        return dateTime.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    public static String decimalToString(BigDecimal decimalAmount, int scale) {
        return decimalAmount.movePointRight(scale).toBigIntegerExact().toString();
    }

    public static BigInteger hexToBigInt(String hexUint) {
        if (hexUint.startsWith("0x")) {
            hexUint = hexUint.substring(2);
        }
        return new BigInteger(hexUint, 16);
    }

    public static BigDecimal hexToDec(String stringAmount, int scale) {
        if (((String)stringAmount).startsWith("-0x")) {
            stringAmount = "-" + ((String)stringAmount).substring(3);
        } else if (((String)stringAmount).startsWith("0x")) {
            stringAmount = ((String)stringAmount).substring(2);
        }
        return Data.stringToDecimal((String)stringAmount, scale, 16);
    }

    public static BigDecimal strToDec(String stringAmount, int scale) {
        return Data.stringToDecimal(stringAmount, scale, 10);
    }

    private static BigDecimal stringToDecimal(String stringAmount, int scale, int base) {
        return new BigDecimal(new BigInteger(stringAmount, base), scale);
    }

    public static String strToHex(String text) {
        char[] hexCode = "0123456789ABCDEF".toCharArray();
        try {
            byte[] data = text.getBytes(StandardCharsets.UTF_8.name());
            StringBuilder r = new StringBuilder(data.length * 2);
            for (byte b : data) {
                r.append(hexCode[b >> 4 & 0xF]);
                r.append(hexCode[b & 0xF]);
            }
            return r.toString();
        }
        catch (UnsupportedEncodingException e) {
            logger.log(System.Logger.Level.ERROR, () -> e.getMessage());
            return null;
        }
    }

    public static String hexToStr(String text) {
        int len = text.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("hexBinary needs to be even-length: " + text);
        }
        byte[] out = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int h = Data.hexCharToBin(text.charAt(i));
            int l = Data.hexCharToBin(text.charAt(i + 1));
            if (h == -1 || l == -1) {
                throw new IllegalArgumentException("contains illegal character for hexBinary: " + text);
            }
            out[i / 2] = (byte)(h * 16 + l);
        }
        return new String(out, StandardCharsets.UTF_8);
    }

    public static String padLeftZeros(String inputString, int length) {
        if (inputString.length() >= length) {
            return inputString;
        }
        StringBuilder sb = new StringBuilder();
        while (sb.length() < length - inputString.length()) {
            sb.append('0');
        }
        sb.append(inputString);
        return sb.toString();
    }

    private static int hexCharToBin(char hex) {
        return switch (hex) {
            case '0' -> 0;
            case '1' -> 1;
            case '2' -> 2;
            case '3' -> 3;
            case '4' -> 4;
            case '5' -> 5;
            case '6' -> 6;
            case '7' -> 7;
            case '8' -> 8;
            case '9' -> 9;
            case 'A' -> 10;
            case 'B' -> 11;
            case 'C' -> 12;
            case 'D' -> 13;
            case 'E' -> 14;
            case 'F' -> 15;
            default -> -1;
        };
    }
}

