/*
 * Decompiled with CFR 0.152.
 */
package tech.deplant.java4ever.framework.abi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.deplant.java4ever.binding.Abi;
import tech.deplant.java4ever.binding.ContextBuilder;
import tech.deplant.java4ever.binding.EverSdkException;
import tech.deplant.java4ever.framework.Address;
import tech.deplant.java4ever.framework.abi.AbiAddress;
import tech.deplant.java4ever.framework.abi.AbiString;
import tech.deplant.java4ever.framework.abi.AbiTvmCell;
import tech.deplant.java4ever.framework.abi.AbiUint;
import tech.deplant.java4ever.framework.abi.AbiValueType;
import tech.deplant.java4ever.framework.artifact.JsonFile;
import tech.deplant.java4ever.framework.artifact.JsonResource;

public record ContractAbi(@JsonProperty(value="ABI version") Integer abiVersion, @JsonProperty(value="abi_version") Number abiVersionOld, String version, String[] header, Abi.AbiData[] data, Abi.AbiParam[] fields, Abi.AbiFunction[] functions, Abi.AbiEvent[] events) {
    private static Logger log = LoggerFactory.getLogger(ContractAbi.class);

    public static ContractAbi ofString(String jsonString) throws JsonProcessingException {
        return (ContractAbi)ContextBuilder.DEFAULT_MAPPER.readValue(jsonString, ContractAbi.class);
    }

    public static ContractAbi ofResource(String resourceName) throws JsonProcessingException {
        return ContractAbi.ofString(new JsonResource(resourceName).get());
    }

    public static ContractAbi ofFile(String filePath) throws JsonProcessingException {
        return ContractAbi.ofString(new JsonFile(filePath).get());
    }

    public static ContractAbi ofJsonNode(JsonNode node) throws JsonProcessingException {
        return ContractAbi.ofString(ContextBuilder.DEFAULT_MAPPER.writeValueAsString((Object)node));
    }

    public String json() throws JsonProcessingException {
        return ContextBuilder.DEFAULT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL).writeValueAsString((Object)this);
    }

    public boolean hasHeader(String name) {
        return Arrays.asList(this.header()).contains(name);
    }

    public boolean hasFunction(String name) {
        return Arrays.stream(this.functions()).anyMatch(function -> name.equals(function.name()));
    }

    public boolean hasInitDataParam(String initDataName) {
        return Arrays.stream(this.data()).anyMatch(data -> initDataName.equals(data.name()));
    }

    public boolean hasInput(String functionName, String inputName) {
        return Arrays.stream(this.functions()).anyMatch(function -> functionName.equals(function.name()) && Arrays.stream(function.inputs()).anyMatch(input -> inputName.equals(input.name())));
    }

    public boolean hasOutput(String functionName, String outputName) {
        return Arrays.stream(this.functions()).anyMatch(function -> functionName.equals(function.name()) && Arrays.stream(function.outputs()).anyMatch(output -> outputName.equals(output.name())));
    }

    private Abi.AbiFunction findFunction(Abi.AbiFunction[] functionArr, String name) {
        return Arrays.stream(functionArr).filter(function -> name.equals(function.name())).findAny().orElseThrow();
    }

    private Abi.AbiEvent findEvent(Abi.AbiEvent[] functionArr, String name) {
        return Arrays.stream(functionArr).filter(event -> name.equals(event.name())).findAny().orElseThrow();
    }

    private Abi.AbiParam findParam(Abi.AbiParam[] paramArr, String name) {
        return Arrays.stream(paramArr).filter(input -> name.equals(input.name())).findAny().orElseThrow();
    }

    public Abi.AbiParam functionInputType(String functionName, String inputName) {
        return this.findParam(this.findFunction(this.functions(), functionName).inputs(), inputName);
    }

    public Abi.AbiParam initDataType(String initDataName) {
        Abi.AbiData dataParam = Arrays.stream(this.data()).filter(data -> initDataName.equals(data.name())).findAny().orElseThrow();
        return new Abi.AbiParam(dataParam.name(), dataParam.type(), dataParam.components());
    }

    public Abi.AbiParam functionOutputType(String functionName, String outputName) {
        return this.findParam(this.findFunction(this.functions(), functionName).outputs(), outputName);
    }

    public Abi.AbiParam eventInputType(String functionName, String inputName) {
        return this.findParam(this.findEvent(this.events(), functionName).inputs(), inputName);
    }

    public Abi.ABI ABI() {
        try {
            return new Abi.ABI.Json(this.json());
        }
        catch (JsonProcessingException e) {
            log.error("This JsonAbi can't be strigified!" + e.getMessage());
            return new Abi.ABI.Json("{}");
        }
    }

    protected Object serializeSingle(AbiValueType type, int size, Object inputValue) throws EverSdkException {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case AbiValueType.UINT, AbiValueType.INT -> {
                Object v0 = inputValue;
                Objects.requireNonNull(v0);
                Object var4_4 = v0;
                int var5_10 = 0;
                block28: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BigInteger.class, Instant.class, String.class, String.class}, (Object)var4_4, var5_10)) {
                        case 0: {
                            BigInteger b = (BigInteger)var4_4;
                            yield new AbiUint(b).serialize();
                        }
                        case 1: {
                            Instant i = (Instant)var4_4;
                            yield new AbiUint(i).serialize();
                        }
                        case 2: {
                            String strPrefixed = (String)var4_4;
                            if (strPrefixed.length() < 2 || !"0x".equals(strPrefixed.substring(0, 2))) {
                                var5_10 = 3;
                                continue block28;
                            }
                            yield new AbiUint(new BigInteger(strPrefixed.substring(2), 16)).serialize();
                        }
                        case 3: {
                            String str = (String)var4_4;
                            yield new AbiUint(size, new BigInteger(str, 16)).serialize();
                        }
                    }
                    break;
                }
                yield inputValue;
            }
            case AbiValueType.STRING, AbiValueType.BYTES, AbiValueType.BYTE -> {
                Object v2 = inputValue;
                Objects.requireNonNull(v2);
                Object var4_5 = v2;
                int var5_11 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class}, (Object)var4_5, var5_11)) {
                    case 0: {
                        String s = (String)var4_5;
                        yield new AbiString(s).serialize();
                    }
                }
                yield inputValue.toString();
            }
            case AbiValueType.ADDRESS -> {
                Object v3 = inputValue;
                Objects.requireNonNull(v3);
                Object var4_6 = v3;
                int var5_12 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Address.class, String.class}, (Object)var4_6, var5_12)) {
                    case 0: {
                        Address a = (Address)var4_6;
                        yield new AbiAddress(a).serialize();
                    }
                    case 1: {
                        String s = (String)var4_6;
                        yield new AbiAddress(s).serialize();
                    }
                }
                yield inputValue;
            }
            case AbiValueType.BOOL -> {
                Object v4 = inputValue;
                Objects.requireNonNull(v4);
                Object var4_7 = v4;
                int var5_13 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class}, (Object)var4_7, var5_13)) {
                    case 0: {
                        Boolean b = (Boolean)var4_7;
                        yield b;
                    }
                }
                yield inputValue;
            }
            case AbiValueType.CELL, AbiValueType.SLICE, AbiValueType.BUILDER -> {
                Object v5 = inputValue;
                Objects.requireNonNull(v5);
                Object var4_8 = v5;
                int var5_14 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, AbiTvmCell.class}, (Object)var4_8, var5_14)) {
                    case 0: {
                        String s = (String)var4_8;
                        yield s;
                    }
                    case 1: {
                        AbiTvmCell abiCell = (AbiTvmCell)var4_8;
                        yield abiCell.serialize();
                    }
                }
                yield inputValue;
            }
            case AbiValueType.TUPLE -> {
                EverSdkException ex = new EverSdkException(new EverSdkException.ErrorResult(-301, "ABI Parsing unexpected! Shouldn't get here!"), (Throwable)new RuntimeException());
                log.warn(ex.toString());
                throw ex;
            }
        };
    }

    protected TypePair typeParser(String typeString) throws EverSdkException {
        Pattern sizePattern = Pattern.compile("([a-zA-Z]+)(\\d{1,3})");
        Matcher matcher = sizePattern.matcher(typeString);
        if (matcher.find()) {
            return new TypePair(AbiValueType.valueOf(matcher.group(1).toUpperCase()), Integer.parseInt(matcher.group(2)));
        }
        Pattern typePattern = Pattern.compile("([a-zA-Z]+)");
        matcher = typePattern.matcher(typeString);
        if (matcher.find()) {
            return new TypePair(AbiValueType.valueOf(matcher.group(1).toUpperCase()), 0);
        }
        EverSdkException ex = new EverSdkException(new EverSdkException.ErrorResult(-300, "ABI Type parsing failed! Type: " + typeString), (Throwable)new RuntimeException());
        log.warn(ex.toString());
        throw ex;
    }

    protected boolean arrayMatcher(String typeString) {
        Pattern arrayPattern = Pattern.compile("([a-zA-Z]+\\d{0,3})(\\[\\])");
        Matcher matcher = arrayPattern.matcher(typeString);
        return matcher.find();
    }

    protected Object serializeTree(Abi.AbiParam param, Object inputValue) throws EverSdkException {
        String typeStringPattern = "([a-zA-Z]+\\d{0,3}\\[?\\]?)";
        Pattern mapPattern = Pattern.compile("(map\\()" + typeStringPattern + "(,)" + typeStringPattern + "(\\))");
        boolean rootIsMap = false;
        String rootTypeString = param.type();
        String keyTypeString = null;
        String valueTypeString = null;
        log.info(rootTypeString);
        Matcher matcher = mapPattern.matcher(rootTypeString);
        while (matcher.find()) {
            rootIsMap = true;
            keyTypeString = matcher.group(2);
            valueTypeString = matcher.group(4);
        }
        if (rootIsMap) {
            boolean keyIsArray = this.arrayMatcher(keyTypeString);
            TypePair keyTypePair = this.typeParser(keyTypeString);
            AbiValueType keyType = keyTypePair.type();
            int keySize = keyTypePair.size();
            boolean valueIsArray = this.arrayMatcher(valueTypeString);
            TypePair valueTypePair = this.typeParser(valueTypeString);
            AbiValueType valueType = valueTypePair.type();
            int valueSize = valueTypePair.size();
            Map mapValue = (Map)inputValue;
            if (mapValue.size() == 1) {
                Object key = mapValue.keySet().toArray()[0];
                Object value = mapValue.values().toArray()[0];
                return Map.of(this.serializeSingle(keyType, keySize, key), this.serializeTree(new Abi.AbiParam(valueTypeString, valueTypeString, param.components()), value));
            }
            EverSdkException ex = new EverSdkException(new EverSdkException.ErrorResult(-302, "ABI Type Conversion fails. Wrong argument! Too many keys provided for single map(type,type) " + String.valueOf(mapValue)), (Throwable)new RuntimeException());
            log.warn(ex.toString());
            throw ex;
        }
        boolean rootIsArray = this.arrayMatcher(rootTypeString);
        TypePair rootTypePair = this.typeParser(rootTypeString);
        AbiValueType rootType = rootTypePair.type();
        int rootSize = rootTypePair.size();
        log.info("Root Is Array: " + rootIsArray);
        if (rootType.equals((Object)AbiValueType.TUPLE)) {
            Map mapValue = (Map)inputValue;
            return Arrays.stream(param.components()).collect(Collectors.toMap(component -> component.name(), component -> {
                try {
                    return this.serializeTree((Abi.AbiParam)component, mapValue.get(component.name()));
                }
                catch (EverSdkException e) {
                    return mapValue.get(component.name());
                }
            }));
        }
        if (rootIsArray) {
            Object[] objectArray;
            Object object = inputValue;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Object[].class, List.class}, (Object)object2, n)) {
                case 0: {
                    String s = (String)object2;
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = this.serializeSingle(rootType, rootSize, s);
                    break;
                }
                case 1: {
                    Object[] arr = (Object[])object2;
                    objectArray = Arrays.stream(arr).map(element -> {
                        try {
                            return this.serializeSingle(rootType, rootSize, element);
                        }
                        catch (EverSdkException e) {
                            return element;
                        }
                    }).toArray();
                    break;
                }
                case 2: {
                    List list = (List)object2;
                    objectArray = list.stream().map(element -> {
                        try {
                            return this.serializeSingle(rootType, rootSize, element);
                        }
                        catch (EverSdkException e) {
                            return element;
                        }
                    }).toArray();
                    break;
                }
                default: {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = this.serializeSingle(rootType, rootSize, inputValue);
                }
            }
            return objectArray;
        }
        return this.serializeSingle(rootType, rootSize, inputValue);
    }

    public Map<String, Object> convertFunctionInputs(String functionName, Map<String, Object> functionInputs) throws EverSdkException {
        if (functionInputs != null) {
            HashMap<String, Object> convertedInputs = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : functionInputs.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (this.hasInput(functionName, key)) {
                    Abi.AbiParam type = this.functionInputType(functionName, key);
                    try {
                        convertedInputs.put(key, this.serializeTree(type, value));
                    }
                    catch (EverSdkException e) {
                        convertedInputs.put(key, value);
                    }
                    continue;
                }
                log.error("ABI Function " + functionName + " doesn't contain input '" + key + "'");
                throw new EverSdkException(new EverSdkException.ErrorResult(-303, "Function " + functionName + " doesn't contain input (" + key + ") in ABI"), (Throwable)new Exception());
            }
            return convertedInputs;
        }
        return null;
    }

    public Map<String, Object> convertInitDataInputs(Map<String, Object> initDataInputs) throws EverSdkException {
        if (initDataInputs != null) {
            HashMap<String, Object> convertedInputs = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : initDataInputs.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (this.hasInitDataParam(key)) {
                    Abi.AbiParam type = this.initDataType(key);
                    try {
                        convertedInputs.put(key, this.serializeTree(type, value));
                    }
                    catch (EverSdkException e) {
                        convertedInputs.put(key, value);
                    }
                    continue;
                }
                log.error("ABI doesn't contain initData parameter '" + key + "'");
                throw new EverSdkException(new EverSdkException.ErrorResult(-304, "ABI doesn't contain initData parameter '" + key + "'"), (Throwable)new Exception());
            }
            return convertedInputs;
        }
        return null;
    }

    record TypePair(AbiValueType type, Integer size) {
    }
}

