/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.infrastructure;

import com.squareup.moshi.Moshi;
import com.squareup.moshi._MoshiKotlinExtensionsKt;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.carpentum.sdk.payment.internal.api.ApiUtils;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ApiAbstractionsKt;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ApiClient;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ApiInfrastructureResponse;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ClientError;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Informational;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Redirection;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.RequestConfig;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.RequestMethod;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ResponseExtensionsKt;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Serializer;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.ServerError;
import tech.carpentum.sdk.payment.internal.generated.infrastructure.Success;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0004J\u0012\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0004J\"\u0010\f\u001a\u00020\u0003\"\n\b\u0000\u0010\r\u0018\u0001*\u00020\u00012\u0006\u0010\u000b\u001a\u0002H\rH\u0084\b\u00a2\u0006\u0002\u0010\u000eJ/\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\r0\u0010\"\u0006\b\u0000\u0010\u0011\u0018\u0001\"\u0006\b\u0001\u0010\r\u0018\u00012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0013H\u0084\bJ(\u0010\u0014\u001a\u00020\u0015\"\u0006\b\u0000\u0010\r\u0018\u00012\u0006\u0010\u0016\u001a\u0002H\r2\b\b\u0002\u0010\u0017\u001a\u00020\u0003H\u0084\b\u00a2\u0006\u0002\u0010\u0018J.\u0010\u0019\u001a\u0004\u0018\u0001H\r\"\u0006\b\u0000\u0010\r\u0018\u00012\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u0084\b\u00a2\u0006\u0002\u0010\u001cJ\u001c\u0010\u001d\u001a\u00020\u001e\"\u0004\b\u0000\u0010\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\r0\u0013H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ApiClient;", "", "baseUrl", "", "(Ljava/lang/String;)V", "getBaseUrl", "()Ljava/lang/String;", "guessContentTypeFromFile", "file", "Ljava/io/File;", "parameterToString", "value", "parseDateToQueryString", "T", "(Ljava/lang/Object;)Ljava/lang/String;", "request", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ApiInfrastructureResponse;", "I", "requestConfig", "Ltech/carpentum/sdk/payment/internal/generated/infrastructure/RequestConfig;", "requestBody", "Lokhttp3/RequestBody;", "content", "mediaType", "(Ljava/lang/Object;Ljava/lang/String;)Lokhttp3/RequestBody;", "responseBody", "body", "Lokhttp3/ResponseBody;", "(Lokhttp3/ResponseBody;Ljava/lang/String;)Ljava/lang/Object;", "updateAuthParams", "", "Companion", "payment-client-v2"})
public class ApiClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String baseUrl;
    @NotNull
    protected static final String ContentType = "Content-Type";
    @NotNull
    protected static final String Accept = "Accept";
    @NotNull
    public static final String Authorization = "Authorization";
    @NotNull
    protected static final String JsonMediaType = "application/json";
    @NotNull
    protected static final String FormDataMediaType = "multipart/form-data";
    @NotNull
    protected static final String FormUrlEncMediaType = "application/x-www-form-urlencoded";
    @NotNull
    protected static final String XmlMediaType = "application/xml";
    @NotNull
    private static final Map<String, String> apiKey;
    @NotNull
    private static final Map<String, String> apiKeyPrefix;
    @Nullable
    private static String username;
    @Nullable
    private static String password;
    @Nullable
    private static String accessToken;
    @NotNull
    private static final Lazy<OkHttpClient> client$delegate;
    @NotNull
    private static final OkHttpClient.Builder builder;

    public ApiClient(@NotNull String baseUrl) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        this.baseUrl = baseUrl;
    }

    @NotNull
    public final String getBaseUrl() {
        return this.baseUrl;
    }

    @NotNull
    protected final String guessContentTypeFromFile(@NotNull File file) {
        String contentType;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = contentType = URLConnection.guessContentTypeFromName(file.getName());
        return string == null ? "application/octet-stream" : string;
    }

    protected final /* synthetic */ <T> RequestBody requestBody(T content, String mediaType) {
        RequestBody requestBody;
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        boolean $i$f$requestBody = false;
        if (content instanceof File) {
            requestBody = RequestBody.Companion.create((File)content, MediaType.Companion.parse(mediaType));
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormDataMediaType)) {
            MultipartBody.Builder builder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
            boolean bl = false;
            boolean bl2 = false;
            MultipartBody.Builder $this$requestBody_u24lambda_u2d1 = builder;
            boolean bl3 = false;
            if (content == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            }
            Map $this$forEach$iv = (Map)content;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl4 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Headers partHeaders;
                String[] stringArray;
                Map.Entry element$iv;
                Map.Entry $dstr$key$value = element$iv = iterator.next();
                boolean bl5 = false;
                Map.Entry entry = $dstr$key$value;
                boolean bl6 = false;
                String key = (String)entry.getKey();
                Map.Entry entry2 = $dstr$key$value;
                boolean bl7 = false;
                Object value = entry2.getValue();
                if (value instanceof File) {
                    stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key + "\"; filename=\"" + ((File)value).getName() + '\"'};
                    partHeaders = Headers.Companion.of(stringArray);
                    MediaType fileMediaType = MediaType.Companion.parse(this.guessContentTypeFromFile((File)value));
                    $this$requestBody_u24lambda_u2d1.addPart(partHeaders, RequestBody.Companion.create((File)value, fileMediaType));
                    continue;
                }
                stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key + '\"'};
                partHeaders = Headers.Companion.of(stringArray);
                $this$requestBody_u24lambda_u2d1.addPart(partHeaders, RequestBody.Companion.create(this.parameterToString(value), null));
            }
            requestBody = (RequestBody)builder.build();
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormUrlEncMediaType)) {
            FormBody.Builder builder = new FormBody.Builder(null, 1, null);
            boolean bl = false;
            boolean bl8 = false;
            FormBody.Builder $this$requestBody_u24lambda_u2d3 = builder;
            boolean bl9 = false;
            if (content == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            }
            Map $this$forEach$iv = (Map)content;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl10 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$key$value = element$iv = iterator.next();
                boolean bl11 = false;
                Map.Entry value = $dstr$key$value;
                boolean bl12 = false;
                String key = (String)value.getKey();
                Map.Entry entry = $dstr$key$value;
                boolean bl13 = false;
                value = entry.getValue();
                $this$requestBody_u24lambda_u2d3.add(key, this.parameterToString(value));
            }
            requestBody = (RequestBody)builder.build();
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)JsonMediaType)) {
            Moshi moshi2 = Serializer.getMoshi();
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            String string = moshi2.adapter(Object.class).toJson(content);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moshi.adapter(T::class.java).toJson(content)");
            requestBody = RequestBody.Companion.create(string, MediaType.Companion.parse(mediaType));
        } else {
            if (Intrinsics.areEqual((Object)mediaType, (Object)XmlMediaType)) {
                throw new UnsupportedOperationException("xml not currently supported.");
            }
            throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
        }
        return requestBody;
    }

    public static /* synthetic */ RequestBody requestBody$default(ApiClient this_, Object content, String mediaType, int n, Object object) {
        RequestBody requestBody;
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: requestBody");
        }
        if ((n & 2) != 0) {
            mediaType = JsonMediaType;
        }
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        boolean $i$f$requestBody = false;
        if (content instanceof File) {
            requestBody = RequestBody.Companion.create((File)content, MediaType.Companion.parse(mediaType));
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormDataMediaType)) {
            object = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
            boolean bl = false;
            boolean bl2 = false;
            MultipartBody.Builder $this$requestBody_u24lambda_u2d1 = (MultipartBody.Builder)object;
            boolean bl3 = false;
            if (content == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            }
            Map $this$forEach$iv = (Map)content;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl4 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Headers partHeaders;
                String[] stringArray;
                Map.Entry element$iv;
                Map.Entry $dstr$key$value = element$iv = iterator.next();
                boolean bl5 = false;
                Map.Entry entry = $dstr$key$value;
                boolean bl6 = false;
                String key = (String)entry.getKey();
                Map.Entry entry2 = $dstr$key$value;
                boolean bl7 = false;
                Object value = entry2.getValue();
                if (value instanceof File) {
                    stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key + "\"; filename=\"" + ((File)value).getName() + '\"'};
                    partHeaders = Headers.Companion.of(stringArray);
                    MediaType fileMediaType = MediaType.Companion.parse(this_.guessContentTypeFromFile((File)value));
                    $this$requestBody_u24lambda_u2d1.addPart(partHeaders, RequestBody.Companion.create((File)value, fileMediaType));
                    continue;
                }
                stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key + '\"'};
                partHeaders = Headers.Companion.of(stringArray);
                $this$requestBody_u24lambda_u2d1.addPart(partHeaders, RequestBody.Companion.create(this_.parameterToString(value), null));
            }
            requestBody = (RequestBody)((MultipartBody.Builder)object).build();
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)FormUrlEncMediaType)) {
            object = new FormBody.Builder(null, 1, null);
            boolean bl = false;
            boolean bl8 = false;
            FormBody.Builder $this$requestBody_u24lambda_u2d3 = (FormBody.Builder)object;
            boolean bl9 = false;
            if (content == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            }
            Map $this$forEach$iv = (Map)content;
            boolean $i$f$forEach = false;
            Map map = $this$forEach$iv;
            boolean bl10 = false;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$key$value = element$iv = iterator.next();
                boolean bl11 = false;
                Map.Entry value = $dstr$key$value;
                boolean bl12 = false;
                String key = (String)value.getKey();
                Map.Entry entry = $dstr$key$value;
                boolean bl13 = false;
                value = entry.getValue();
                $this$requestBody_u24lambda_u2d3.add(key, this_.parameterToString(value));
            }
            requestBody = (RequestBody)((FormBody.Builder)object).build();
        } else if (Intrinsics.areEqual((Object)mediaType, (Object)JsonMediaType)) {
            Moshi moshi2 = Serializer.getMoshi();
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            object = moshi2.adapter(Object.class).toJson(content);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"moshi.adapter(T::class.java).toJson(content)");
            requestBody = RequestBody.Companion.create((String)object, MediaType.Companion.parse(mediaType));
        } else {
            if (Intrinsics.areEqual((Object)mediaType, (Object)XmlMediaType)) {
                throw new UnsupportedOperationException("xml not currently supported.");
            }
            throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
        }
        return requestBody;
    }

    protected final /* synthetic */ <T> T responseBody(ResponseBody body, String mediaType) {
        boolean $i$f$responseBody = false;
        if (body == null) {
            return null;
        }
        String bodyContent = body.string();
        CharSequence charSequence = bodyContent;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual(Object.class, File.class)) {
            File f = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
            f.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(f));
            out.write(bodyContent);
            out.close();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return (T)f;
        }
        charSequence = mediaType;
        if (!Intrinsics.areEqual((Object)charSequence, (Object)JsonMediaType)) {
            throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
        }
        Moshi $this$adapter$iv = Serializer.getMoshi();
        boolean $i$f$adapter = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        return (T)_MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, null).fromJson(bodyContent);
    }

    public static /* synthetic */ Object responseBody$default(ApiClient this_, ResponseBody body, String mediaType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: responseBody");
        }
        if ((n & 2) != 0) {
            mediaType = JsonMediaType;
        }
        boolean $i$f$responseBody = false;
        if (body == null) {
            return null;
        }
        String bodyContent = body.string();
        CharSequence charSequence = bodyContent;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        if (Intrinsics.areEqual(Object.class, File.class)) {
            File f = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
            f.deleteOnExit();
            BufferedWriter out = new BufferedWriter(new FileWriter(f));
            out.write(bodyContent);
            out.close();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            return f;
        }
        charSequence = mediaType;
        if (!Intrinsics.areEqual((Object)charSequence, (Object)JsonMediaType)) {
            throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
        }
        Moshi $this$adapter$iv = Serializer.getMoshi();
        boolean $i$f$adapter = false;
        Intrinsics.reifiedOperationMarker((int)6, (String)"T");
        return _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv, null).fromJson(bodyContent);
    }

    protected <T> void updateAuthParams(@NotNull RequestConfig<T> requestConfig) {
        Intrinsics.checkNotNullParameter(requestConfig, (String)"requestConfig");
        CharSequence charSequence = requestConfig.getHeaders().get(Authorization);
        boolean bl = false;
        boolean bl2 = false;
        if ((charSequence == null || charSequence.length() == 0) && (charSequence = accessToken) != null) {
            CharSequence charSequence2 = charSequence;
            bl2 = false;
            boolean bl3 = false;
            CharSequence accessToken = charSequence2;
            boolean bl4 = false;
            Map<String, String> map = requestConfig.getHeaders();
            String string = Authorization;
            String string2 = Intrinsics.stringPlus((String)"Bearer ", (Object)accessToken);
            boolean bl5 = false;
            map.put(string, string2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final /* synthetic */ <I, T> ApiInfrastructureResponse<T> request(RequestConfig<I> requestConfig) {
        ApiInfrastructureResponse apiInfrastructureResponse;
        String string;
        Request.Builder builder;
        Map<String, String> headers;
        String string2;
        boolean $i$f$forEach;
        Intrinsics.checkNotNullParameter(requestConfig, (String)"requestConfig");
        boolean $i$f$request = false;
        HttpUrl httpUrl = HttpUrl.Companion.parse(this.getBaseUrl());
        if (httpUrl == null) {
            throw new IllegalStateException("baseUrl is invalid.");
        }
        HttpUrl httpUrl2 = httpUrl;
        this.updateAuthParams(requestConfig);
        Object object = new char[]{'/'};
        object = httpUrl2.newBuilder().addPathSegments(StringsKt.trimStart((String)requestConfig.getPath(), (char[])object));
        boolean bl = false;
        boolean bl2 = false;
        Object $this$request_u24lambda_u2d72 = (HttpUrl.Builder)object;
        int n = 0;
        Object $this$forEach$iv = requestConfig.getQuery();
        boolean $i$f$forEach22 = false;
        Map<String, List<String>> map = $this$forEach$iv;
        boolean bl3 = false;
        Iterator<Map.Entry<String, List<String>>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<String>> element$iv4;
            Map.Entry<String, List<String>> query = element$iv4 = iterator.next();
            boolean bl4 = false;
            Iterable $this$forEach$iv2 = query.getValue();
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String queryValue = (String)element$iv2;
                boolean bl5 = false;
                $this$request_u24lambda_u2d72.addQueryParameter(query.getKey(), queryValue);
            }
        }
        HttpUrl url = ((HttpUrl.Builder)object).build();
        object = requestConfig.getHeaders().get(ContentType);
        bl = false;
        bl2 = false;
        if (object == null || object.length() == 0) {
            object = requestConfig.getHeaders();
            String string3 = ContentType;
            String string4 = JsonMediaType;
            boolean $this$request_u24lambda_u2d72 = false;
            object.put(string3, string4);
        }
        object = requestConfig.getHeaders().get(Accept);
        boolean bl6 = false;
        boolean bl7 = false;
        if (object == null || object.length() == 0) {
            object = requestConfig.getHeaders();
            String string5 = Accept;
            String string6 = JsonMediaType;
            boolean $this$request_u24lambda_u2d72 = false;
            object.put(string5, string6);
        }
        if (Intrinsics.areEqual((Object)((string2 = (headers = requestConfig.getHeaders()).get(ContentType)) == null ? "" : string2), (Object)"")) {
            throw new IllegalStateException("Missing Content-Type header. This is required.");
        }
        string2 = headers.get(Accept);
        if (Intrinsics.areEqual((Object)(string2 == null ? "" : string2), (Object)"")) {
            throw new IllegalStateException("Missing Accept header. This is required.");
        }
        String string7 = headers.get(ContentType);
        if (string7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        string7 = StringsKt.substringBefore$default((String)string7, (String)";", null, (int)2, null);
        $this$request_u24lambda_u2d72 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)$this$request_u24lambda_u2d72, (String)"getDefault()");
        $this$request_u24lambda_u2d72 = (Locale)$this$request_u24lambda_u2d72;
        n = 0;
        String string8 = string7;
        if (string8 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string9 = string8.toLowerCase((Locale)$this$request_u24lambda_u2d72);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).toLowerCase(locale)");
        String contentType = string9;
        $this$request_u24lambda_u2d72 = requestConfig.getMethod();
        n = WhenMappings.$EnumSwitchMapping$0[((Enum)$this$request_u24lambda_u2d72).ordinal()];
        switch (n) {
            case 1: {
                boolean bl8;
                boolean bl9;
                FormBody.Builder $this$requestBody_u24lambda_u2d3$iv;
                ApiClient this_$iv;
                Headers partHeaders$iv322;
                Object value$iv;
                Headers headers2;
                String key$iv;
                boolean bl10;
                Headers $dstr$key$value$iv;
                Object object2;
                Map $this$forEach$iv$iv;
                boolean bl11;
                MultipartBody.Builder $this$requestBody_u24lambda_u2d1$iv;
                RequestBody requestBody;
                void content$iv;
                $this$forEach$iv = this;
                I $i$f$forEach22 = requestConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv, MediaType.Companion.parse(contentType));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder builder3 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    boolean bl12 = false;
                    boolean element$iv4 = false;
                    $this$requestBody_u24lambda_u2d1$iv = builder3;
                    bl11 = false;
                    if (content$iv == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv = (Map)content$iv;
                    $i$f$forEach = false;
                    object2 = $this$forEach$iv$iv;
                    boolean bl13 = false;
                    Iterator iterator2 = object2.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        String[] fileMediaType$iv2;
                        Headers element$iv$iv;
                        $dstr$key$value$iv = element$iv$iv = iterator2.next();
                        bl10 = false;
                        Headers headers3 = $dstr$key$value$iv;
                        boolean bl14 = false;
                        key$iv = (String)headers3.getKey();
                        headers2 = $dstr$key$value$iv;
                        boolean bl15 = false;
                        value$iv = headers2.getValue();
                        if (value$iv instanceof File) {
                            String[] stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + "\"; filename=\"" + ((File)value$iv).getName() + '\"'};
                            partHeaders$iv322 = Headers.Companion.of(stringArray);
                            fileMediaType$iv2 = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)value$iv));
                            $this$requestBody_u24lambda_u2d1$iv.addPart(partHeaders$iv322, RequestBody.Companion.create((File)value$iv, (MediaType)fileMediaType$iv2));
                            continue;
                        }
                        fileMediaType$iv2 = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + '\"'};
                        partHeaders$iv322 = Headers.Companion.of(fileMediaType$iv2);
                        $this$requestBody_u24lambda_u2d1$iv.addPart(partHeaders$iv322, RequestBody.Companion.create(this_$iv.parameterToString(value$iv), null));
                    }
                    requestBody = (RequestBody)builder3.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder builder4 = new FormBody.Builder(null, 1, null);
                    boolean bl16 = false;
                    boolean element$iv4 = false;
                    $this$requestBody_u24lambda_u2d3$iv = builder4;
                    bl9 = false;
                    if (content$iv == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv = (Map)content$iv;
                    $i$f$forEach = false;
                    object2 = $this$forEach$iv$iv;
                    boolean bl17 = false;
                    for (Map.Entry element$iv$iv : object2.entrySet()) {
                        $dstr$key$value$iv = element$iv$iv;
                        bl8 = false;
                        value$iv = $dstr$key$value$iv;
                        boolean partHeaders$iv322 = false;
                        key$iv = (String)value$iv.getKey();
                        partHeaders$iv322 = $dstr$key$value$iv;
                        boolean fileMediaType$iv2 = false;
                        value$iv = partHeaders$iv322.getValue();
                        $this$requestBody_u24lambda_u2d3$iv.add(key$iv, this_$iv.parameterToString(value$iv));
                    }
                    requestBody = (RequestBody)builder4.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)JsonMediaType)) {
                    Moshi moshi2 = Serializer.getMoshi();
                    Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                    String string10 = moshi2.adapter(Object.class).toJson((Object)content$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"moshi.adapter(T::class.java).toJson(content)");
                    requestBody = RequestBody.Companion.create(string10, MediaType.Companion.parse(contentType));
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                RequestBody requestBody2 = requestBody;
                builder = builder2.delete(requestBody2);
                break;
            }
            case 2: {
                builder = new Request.Builder().url(url);
                break;
            }
            case 3: {
                builder = new Request.Builder().url(url).head();
                break;
            }
            case 4: {
                RequestBody requestBody;
                boolean bl8;
                boolean bl9;
                FormBody.Builder $this$requestBody_u24lambda_u2d3$iv;
                Headers partHeaders$iv322;
                Object value$iv;
                String key$iv;
                boolean bl10;
                Headers $dstr$key$value$iv;
                Object object2;
                Map $this$forEach$iv$iv;
                boolean bl11;
                MultipartBody.Builder $this$requestBody_u24lambda_u2d1$iv;
                ApiClient this_$iv = this;
                I content$iv = requestConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv, MediaType.Companion.parse(contentType));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder builder5 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    boolean bl18 = false;
                    boolean element$iv4 = false;
                    $this$requestBody_u24lambda_u2d1$iv = builder5;
                    bl11 = false;
                    if (content$iv == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv = (Map)content$iv;
                    $i$f$forEach = false;
                    object2 = $this$forEach$iv$iv;
                    boolean bl19 = false;
                    for (Map.Entry element$iv$iv : object2.entrySet()) {
                        String[] fileMediaType$iv2;
                        $dstr$key$value$iv = element$iv$iv;
                        bl10 = false;
                        value$iv = $dstr$key$value$iv;
                        boolean partHeaders$iv322 = false;
                        key$iv = (String)value$iv.getKey();
                        partHeaders$iv322 = $dstr$key$value$iv;
                        boolean fileMediaType$iv2 = false;
                        value$iv = partHeaders$iv322.getValue();
                        if (value$iv instanceof File) {
                            fileMediaType$iv2 = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + "\"; filename=\"" + ((File)value$iv).getName() + '\"'};
                            partHeaders$iv322 = Headers.Companion.of(fileMediaType$iv2);
                            fileMediaType$iv2 = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)value$iv));
                            $this$requestBody_u24lambda_u2d1$iv.addPart(partHeaders$iv322, RequestBody.Companion.create((File)value$iv, (MediaType)fileMediaType$iv2));
                            continue;
                        }
                        fileMediaType$iv2 = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + '\"'};
                        partHeaders$iv322 = Headers.Companion.of(fileMediaType$iv2);
                        $this$requestBody_u24lambda_u2d1$iv.addPart(partHeaders$iv322, RequestBody.Companion.create(this_$iv.parameterToString(value$iv), null));
                    }
                    requestBody = (RequestBody)builder5.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder builder6 = new FormBody.Builder(null, 1, null);
                    boolean bl20 = false;
                    boolean element$iv4 = false;
                    $this$requestBody_u24lambda_u2d3$iv = builder6;
                    bl9 = false;
                    if (content$iv == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv = (Map)content$iv;
                    $i$f$forEach = false;
                    object2 = $this$forEach$iv$iv;
                    boolean bl21 = false;
                    for (Map.Entry element$iv$iv : object2.entrySet()) {
                        $dstr$key$value$iv = element$iv$iv;
                        bl8 = false;
                        value$iv = $dstr$key$value$iv;
                        boolean partHeaders$iv = false;
                        key$iv = (String)value$iv.getKey();
                        partHeaders$iv322 = $dstr$key$value$iv;
                        boolean fileMediaType$iv3 = false;
                        value$iv = partHeaders$iv322.getValue();
                        $this$requestBody_u24lambda_u2d3$iv.add(key$iv, this_$iv.parameterToString(value$iv));
                    }
                    requestBody = (RequestBody)builder6.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)JsonMediaType)) {
                    Moshi moshi3 = Serializer.getMoshi();
                    Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                    String string11 = moshi3.adapter(Object.class).toJson(content$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"moshi.adapter(T::class.java).toJson(content)");
                    requestBody = RequestBody.Companion.create(string11, MediaType.Companion.parse(contentType));
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                RequestBody requestBody2 = requestBody;
                builder = builder2.patch(requestBody2);
                break;
            }
            case 5: {
                RequestBody requestBody;
                boolean bl8;
                boolean bl9;
                FormBody.Builder $this$requestBody_u24lambda_u2d3$iv;
                Headers partHeaders$iv322;
                Object value$iv;
                String key$iv;
                boolean bl10;
                Headers $dstr$key$value$iv;
                Object object2;
                Map $this$forEach$iv$iv;
                boolean bl11;
                MultipartBody.Builder $this$requestBody_u24lambda_u2d1$iv;
                ApiClient this_$iv = this;
                I content$iv = requestConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv, MediaType.Companion.parse(contentType));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder builder7 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    boolean bl22 = false;
                    boolean element$iv4 = false;
                    $this$requestBody_u24lambda_u2d1$iv = builder7;
                    bl11 = false;
                    if (content$iv == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv = (Map)content$iv;
                    $i$f$forEach = false;
                    object2 = $this$forEach$iv$iv;
                    boolean bl23 = false;
                    for (Map.Entry element$iv$iv : object2.entrySet()) {
                        String[] fileMediaType$iv3;
                        $dstr$key$value$iv = element$iv$iv;
                        bl10 = false;
                        value$iv = $dstr$key$value$iv;
                        boolean partHeaders$iv = false;
                        key$iv = (String)value$iv.getKey();
                        partHeaders$iv322 = $dstr$key$value$iv;
                        boolean fileMediaType$iv3 = false;
                        value$iv = partHeaders$iv322.getValue();
                        if (value$iv instanceof File) {
                            fileMediaType$iv3 = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + "\"; filename=\"" + ((File)value$iv).getName() + '\"'};
                            partHeaders$iv322 = Headers.Companion.of(fileMediaType$iv3);
                            fileMediaType$iv3 = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)value$iv));
                            $this$requestBody_u24lambda_u2d1$iv.addPart(partHeaders$iv322, RequestBody.Companion.create((File)value$iv, (MediaType)fileMediaType$iv3));
                            continue;
                        }
                        fileMediaType$iv3 = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + '\"'};
                        partHeaders$iv322 = Headers.Companion.of(fileMediaType$iv3);
                        $this$requestBody_u24lambda_u2d1$iv.addPart(partHeaders$iv322, RequestBody.Companion.create(this_$iv.parameterToString(value$iv), null));
                    }
                    requestBody = (RequestBody)builder7.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder builder8 = new FormBody.Builder(null, 1, null);
                    boolean bl24 = false;
                    boolean element$iv4 = false;
                    $this$requestBody_u24lambda_u2d3$iv = builder8;
                    bl9 = false;
                    if (content$iv == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv = (Map)content$iv;
                    $i$f$forEach = false;
                    object2 = $this$forEach$iv$iv;
                    boolean bl25 = false;
                    for (Map.Entry element$iv$iv : object2.entrySet()) {
                        $dstr$key$value$iv = element$iv$iv;
                        bl8 = false;
                        value$iv = $dstr$key$value$iv;
                        boolean partHeaders$iv = false;
                        key$iv = (String)value$iv.getKey();
                        partHeaders$iv322 = $dstr$key$value$iv;
                        boolean fileMediaType$iv4 = false;
                        value$iv = partHeaders$iv322.getValue();
                        $this$requestBody_u24lambda_u2d3$iv.add(key$iv, this_$iv.parameterToString(value$iv));
                    }
                    requestBody = (RequestBody)builder8.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)JsonMediaType)) {
                    Moshi moshi4 = Serializer.getMoshi();
                    Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                    String string12 = moshi4.adapter(Object.class).toJson(content$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"moshi.adapter(T::class.java).toJson(content)");
                    requestBody = RequestBody.Companion.create(string12, MediaType.Companion.parse(contentType));
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                RequestBody requestBody2 = requestBody;
                builder = builder2.put(requestBody2);
                break;
            }
            case 6: {
                RequestBody requestBody;
                boolean bl8;
                boolean bl9;
                FormBody.Builder $this$requestBody_u24lambda_u2d3$iv;
                Headers partHeaders$iv322;
                Object value$iv;
                Headers headers2;
                String key$iv;
                boolean bl10;
                Headers $dstr$key$value$iv;
                Object object2;
                Map $this$forEach$iv$iv;
                boolean bl11;
                MultipartBody.Builder $this$requestBody_u24lambda_u2d1$iv;
                ApiClient this_$iv = this;
                I content$iv = requestConfig.getBody();
                Request.Builder builder2 = new Request.Builder().url(url);
                boolean $i$f$requestBody = false;
                if (content$iv instanceof File) {
                    requestBody = RequestBody.Companion.create((File)content$iv, MediaType.Companion.parse(contentType));
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormDataMediaType)) {
                    MultipartBody.Builder builder9 = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM);
                    boolean bl26 = false;
                    boolean element$iv4 = false;
                    $this$requestBody_u24lambda_u2d1$iv = builder9;
                    bl11 = false;
                    if (content$iv == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv = (Map)content$iv;
                    $i$f$forEach = false;
                    object2 = $this$forEach$iv$iv;
                    boolean bl27 = false;
                    for (Map.Entry element$iv$iv : object2.entrySet()) {
                        $dstr$key$value$iv = element$iv$iv;
                        bl10 = false;
                        value$iv = $dstr$key$value$iv;
                        boolean partHeaders$iv = false;
                        key$iv = (String)value$iv.getKey();
                        partHeaders$iv322 = $dstr$key$value$iv;
                        boolean fileMediaType$iv4 = false;
                        value$iv = partHeaders$iv322.getValue();
                        if (value$iv instanceof File) {
                            String[] fileMediaType$iv4 = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + "\"; filename=\"" + ((File)value$iv).getName() + '\"'};
                            partHeaders$iv322 = Headers.Companion.of(fileMediaType$iv4);
                            fileMediaType$iv4 = MediaType.Companion.parse(this_$iv.guessContentTypeFromFile((File)value$iv));
                            $this$requestBody_u24lambda_u2d1$iv.addPart(partHeaders$iv322, RequestBody.Companion.create((File)value$iv, (MediaType)fileMediaType$iv4));
                            continue;
                        }
                        String[] stringArray = new String[]{"Content-Disposition", "form-data; name=\"" + key$iv + '\"'};
                        partHeaders$iv322 = Headers.Companion.of(stringArray);
                        $this$requestBody_u24lambda_u2d1$iv.addPart(partHeaders$iv322, RequestBody.Companion.create(this_$iv.parameterToString(value$iv), null));
                    }
                    requestBody = (RequestBody)builder9.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)FormUrlEncMediaType)) {
                    FormBody.Builder builder10 = new FormBody.Builder(null, 1, null);
                    boolean bl28 = false;
                    boolean element$iv4 = false;
                    $this$requestBody_u24lambda_u2d3$iv = builder10;
                    bl9 = false;
                    if (content$iv == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
                    }
                    $this$forEach$iv$iv = (Map)content$iv;
                    $i$f$forEach = false;
                    object2 = $this$forEach$iv$iv;
                    boolean bl29 = false;
                    for (Map.Entry element$iv$iv : object2.entrySet()) {
                        $dstr$key$value$iv = element$iv$iv;
                        bl8 = false;
                        value$iv = $dstr$key$value$iv;
                        boolean bl30 = false;
                        key$iv = (String)value$iv.getKey();
                        headers2 = $dstr$key$value$iv;
                        boolean bl31 = false;
                        value$iv = headers2.getValue();
                        $this$requestBody_u24lambda_u2d3$iv.add(key$iv, this_$iv.parameterToString(value$iv));
                    }
                    requestBody = (RequestBody)builder10.build();
                } else if (Intrinsics.areEqual((Object)contentType, (Object)JsonMediaType)) {
                    Moshi moshi5 = Serializer.getMoshi();
                    Intrinsics.reifiedOperationMarker((int)4, (String)"I?");
                    String string13 = moshi5.adapter(Object.class).toJson(content$iv);
                    Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"moshi.adapter(T::class.java).toJson(content)");
                    requestBody = RequestBody.Companion.create(string13, MediaType.Companion.parse(contentType));
                } else {
                    if (Intrinsics.areEqual((Object)contentType, (Object)XmlMediaType)) {
                        throw new UnsupportedOperationException("xml not currently supported.");
                    }
                    throw new UnsupportedOperationException("requestBody currently only supports JSON body and File body.");
                }
                RequestBody requestBody2 = requestBody;
                builder = builder2.post(requestBody2);
                break;
            }
            case 7: {
                builder = new Request.Builder().url(url).method("OPTIONS", null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this$request_u24lambda_u2d72 = builder;
        n = 0;
        boolean this_$iv22 = false;
        Object $this$request_u24lambda_u2d9 = (Request.Builder)$this$request_u24lambda_u2d72;
        boolean bl322 = false;
        Object $this$forEach$iv3 = headers;
        boolean $i$f$forEach32 = false;
        Map<String, String> element$iv4 = $this$forEach$iv3;
        boolean $this$requestBody_u24lambda_u2d3$iv = false;
        Iterator<Map.Entry<String, String>> iterator3 = element$iv4.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry<String, String> element$iv3;
            Map.Entry<String, String> header = element$iv3 = iterator3.next();
            boolean bl33 = false;
            $this$request_u24lambda_u2d9.addHeader(header.getKey(), header.getValue());
        }
        Request request = ((Request.Builder)$this$request_u24lambda_u2d72).build();
        Response response = Companion.getClient().newCall(request).execute();
        Object this_$iv22 = Response.header$default((Response)response, (String)ContentType, null, (int)2, null);
        if (this_$iv22 == null) {
            string = null;
        } else {
            $this$request_u24lambda_u2d9 = StringsKt.substringBefore$default((String)this_$iv22, (String)";", null, (int)2, null);
            if ($this$request_u24lambda_u2d9 == null) {
                string = null;
            } else {
                Object bl322 = $this$request_u24lambda_u2d9;
                $this$forEach$iv3 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv3, (String)"getDefault()");
                $this$forEach$iv3 = (Locale)$this$forEach$iv3;
                $i$f$forEach32 = false;
                String string14 = ((String)bl322).toLowerCase((Locale)$this$forEach$iv3);
                string = string14;
                Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"(this as java.lang.String).toLowerCase(locale)");
            }
        }
        String accept = string;
        if (response.isRedirect()) {
            apiInfrastructureResponse = new Redirection(response.code(), response.headers().toMultimap());
        } else if (ResponseExtensionsKt.isInformational(response)) {
            apiInfrastructureResponse = new Informational(response.message(), response.code(), response.headers().toMultimap());
        } else if (response.isSuccessful()) {
            Object object3;
            this_$iv22 = this;
            ResponseBody body$iv = response.body();
            boolean $i$f$responseBody = false;
            if (body$iv == null) {
                object3 = null;
            } else {
                String bodyContent$iv = body$iv.string();
                CharSequence $i$f$forEach32 = bodyContent$iv;
                boolean element$iv4 = false;
                if ($i$f$forEach32.length() == 0) {
                    object3 = null;
                } else {
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T?");
                    if (Intrinsics.areEqual(Object.class, File.class)) {
                        File f$iv = Files.createTempFile("tmp.tech.carpentum.sdk.payment.internal.generated", null, new FileAttribute[0]).toFile();
                        f$iv.deleteOnExit();
                        BufferedWriter out$iv = new BufferedWriter(new FileWriter(f$iv));
                        out$iv.write(bodyContent$iv);
                        out$iv.close();
                        Intrinsics.reifiedOperationMarker((int)1, (String)"T?");
                        object3 = f$iv;
                    } else {
                        String string15 = accept;
                        if (Intrinsics.areEqual((Object)string15, (Object)JsonMediaType)) {
                            Moshi $this$adapter$iv$iv = Serializer.getMoshi();
                            boolean $i$f$adapter = false;
                            Intrinsics.reifiedOperationMarker((int)6, (String)"T?");
                            object3 = _MoshiKotlinExtensionsKt.adapter((Moshi)$this$adapter$iv$iv, null).fromJson(bodyContent$iv);
                        } else {
                            throw new UnsupportedOperationException("responseBody currently only supports JSON body.");
                        }
                    }
                }
            }
            apiInfrastructureResponse = new Success<Object>(object3, response.code(), (Map<String, List<String>>)((Map<String, ? extends List<String>>)response.headers().toMultimap()));
        } else {
            ResponseBody responseBody;
            apiInfrastructureResponse = ResponseExtensionsKt.isClientError(response) ? (ApiInfrastructureResponse)new ClientError(response.message(), (responseBody = response.body()) == null ? null : responseBody.string(), response.code(), response.headers().toMultimap()) : (ApiInfrastructureResponse)new ServerError(response.message(), (responseBody = response.body()) == null ? null : responseBody.string(), response.code(), response.headers().toMultimap());
        }
        return apiInfrastructureResponse;
    }

    @NotNull
    protected final String parameterToString(@Nullable Object value) {
        String string;
        Object object = value;
        if (object == null) {
            string = "";
        } else if (object instanceof Object[]) {
            string = ApiAbstractionsKt.toMultiValue$default((Object[])value, "csv", null, 4, null).toString();
        } else if (object instanceof Iterable) {
            string = ApiAbstractionsKt.toMultiValue$default((Iterable)value, "csv", null, 4, null).toString();
        } else if (((((object instanceof OffsetDateTime ? true : object instanceof OffsetTime) ? true : object instanceof LocalDateTime) ? true : object instanceof LocalDate) ? true : object instanceof LocalTime) ? true : object instanceof Date) {
            ApiClient this_$iv = this;
            boolean $i$f$parseDateToQueryString = false;
            String string2 = Serializer.getMoshi().adapter(Object.class).toJson(value);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"moshi.adapter(T::class.java).toJson(value)");
            string = StringsKt.replace$default((String)string2, (String)"\"", (String)"", (boolean)false, (int)4, null);
        } else {
            string = value.toString();
        }
        return string;
    }

    protected final /* synthetic */ <T> String parseDateToQueryString(T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        boolean $i$f$parseDateToQueryString = false;
        Moshi moshi2 = Serializer.getMoshi();
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        String string = moshi2.adapter(Object.class).toJson(value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moshi.adapter(T::class.java).toJson(value)");
        return StringsKt.replace$default((String)string, (String)"\"", (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final OkHttpClient getClient() {
        return Companion.getClient();
    }

    @NotNull
    public static final OkHttpClient.Builder getBuilder() {
        return Companion.getBuilder();
    }

    static {
        boolean bl = false;
        apiKey = new LinkedHashMap();
        bl = false;
        apiKeyPrefix = new LinkedHashMap();
        client$delegate = LazyKt.lazy((Function0)Companion.client.2.INSTANCE);
        builder = new OkHttpClient.Builder().addInterceptor((Interceptor)ApiUtils.INSTANCE.getLoggingInterceptor());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0084T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001c\u0010\u0016\u001a\u00020\u00178\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0002\u001a\u0004\b\u0019\u0010\u001aR!\u0010\u001b\u001a\u00020\u001c8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b \u0010!\u0012\u0004\b\u001d\u0010\u0002\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010\"\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\r\"\u0004\b$\u0010\u000fR\u001c\u0010%\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\r\"\u0004\b'\u0010\u000f\u00a8\u0006("}, d2={"Ltech/carpentum/sdk/payment/internal/generated/infrastructure/ApiClient$Companion;", "", "()V", "Accept", "", "Authorization", "ContentType", "FormDataMediaType", "FormUrlEncMediaType", "JsonMediaType", "XmlMediaType", "accessToken", "getAccessToken", "()Ljava/lang/String;", "setAccessToken", "(Ljava/lang/String;)V", "apiKey", "", "getApiKey", "()Ljava/util/Map;", "apiKeyPrefix", "getApiKeyPrefix", "builder", "Lokhttp3/OkHttpClient$Builder;", "getBuilder$annotations", "getBuilder", "()Lokhttp3/OkHttpClient$Builder;", "client", "Lokhttp3/OkHttpClient;", "getClient$annotations", "getClient", "()Lokhttp3/OkHttpClient;", "client$delegate", "Lkotlin/Lazy;", "password", "getPassword", "setPassword", "username", "getUsername", "setUsername", "payment-client-v2"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final Map<String, String> getApiKey() {
            return apiKey;
        }

        @NotNull
        public final Map<String, String> getApiKeyPrefix() {
            return apiKeyPrefix;
        }

        @Nullable
        public final String getUsername() {
            return username;
        }

        public final void setUsername(@Nullable String string) {
            username = string;
        }

        @Nullable
        public final String getPassword() {
            return password;
        }

        public final void setPassword(@Nullable String string) {
            password = string;
        }

        @Nullable
        public final String getAccessToken() {
            return accessToken;
        }

        public final void setAccessToken(@Nullable String string) {
            accessToken = string;
        }

        @NotNull
        public final OkHttpClient getClient() {
            Lazy lazy = client$delegate;
            boolean bl = false;
            return (OkHttpClient)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getClient$annotations() {
        }

        @NotNull
        public final OkHttpClient.Builder getBuilder() {
            return builder;
        }

        @JvmStatic
        public static /* synthetic */ void getBuilder$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Companion.class), "client", "getClient()Lokhttp3/OkHttpClient;")))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestMethod.values().length];
            nArray[RequestMethod.DELETE.ordinal()] = 1;
            nArray[RequestMethod.GET.ordinal()] = 2;
            nArray[RequestMethod.HEAD.ordinal()] = 3;
            nArray[RequestMethod.PATCH.ordinal()] = 4;
            nArray[RequestMethod.PUT.ordinal()] = 5;
            nArray[RequestMethod.POST.ordinal()] = 6;
            nArray[RequestMethod.OPTIONS.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

