/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.UpiQRMethodImpl;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface UpiQRMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.UPIQR;

    @NotNull
    public Optional<String> getEmailAddress();

    @NotNull
    public Optional<String> getPaymentOperatorCode();

    @NotNull
    public static Builder builder(UpiQRMethod copyOf) {
        Builder builder = UpiQRMethod.builder();
        builder.emailAddress(copyOf.getEmailAddress().orElse(null));
        builder.paymentOperatorCode(copyOf.getPaymentOperatorCode().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new UpiQRMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder emailAddress(String var1);

        @NotNull
        public Builder paymentOperatorCode(String var1);

        @NotNull
        public UpiQRMethod build();
    }
}

