/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.ToJson;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.CryptoTransferMethodImpl;
import tech.carpentum.sdk.payment.internal.generated.model.CryptoTransferMethodJson;
import tech.carpentum.sdk.payment.model.CryptoTransferMethod;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\bH\u0007\u00a8\u0006\r"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/model/CryptoTransferMethodJsonAdapter;", "", "()V", "fromJson", "Ltech/carpentum/sdk/payment/model/CryptoTransferMethod;", "json", "Ltech/carpentum/sdk/payment/internal/generated/model/CryptoTransferMethodJson;", "fromJsonImpl", "Ltech/carpentum/sdk/payment/internal/generated/model/CryptoTransferMethodImpl;", "model", "toJson", "toJsonImpl", "impl", "payment-client-v2"})
public final class CryptoTransferMethodJsonAdapter {
    @FromJson
    @NotNull
    public final CryptoTransferMethod fromJson(@NotNull CryptoTransferMethodJson json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        CryptoTransferMethod.Builder builder = CryptoTransferMethod.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()");
        CryptoTransferMethod.Builder builder2 = builder;
        builder2.account(json.getAccount());
        builder2.paymentOperatorCode(json.getPaymentOperatorCode());
        builder2.remark(json.getRemark());
        CryptoTransferMethod cryptoTransferMethod = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)cryptoTransferMethod, (String)"builder.build()");
        return cryptoTransferMethod;
    }

    @ToJson
    @NotNull
    public final CryptoTransferMethodJson toJson(@NotNull CryptoTransferMethod model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        CryptoTransferMethodJson json = new CryptoTransferMethodJson();
        json.setAccount(model.getAccount());
        json.setPaymentOperatorCode(model.getPaymentOperatorCode());
        json.setRemark(model.getRemark().orElse(null));
        json.setPaymentMethodCode(model.getPaymentMethodCode().name());
        return json;
    }

    @FromJson
    @NotNull
    public final CryptoTransferMethodImpl fromJsonImpl(@NotNull CryptoTransferMethod model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return (CryptoTransferMethodImpl)model;
    }

    @ToJson
    @NotNull
    public final CryptoTransferMethod toJsonImpl(@NotNull CryptoTransferMethodImpl impl) {
        Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
        return impl;
    }
}

