/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AuthTokenRequest;
import tech.carpentum.sdk.payment.model.MoneyAuthRequest;

@JsonClass(generateAdapter=false)
public class AuthTokenRequestImpl
implements AuthTokenRequest {
    private final String merchantCode;
    private final String secret;
    private final Optional<Integer> validitySecs;
    private final List<@NotNull String> operations;
    private final Optional<MoneyAuthRequest> money;
    private final int hashCode;
    private final String toString;

    @Override
    public String getMerchantCode() {
        return this.merchantCode;
    }

    @Override
    public String getSecret() {
        return this.secret;
    }

    @Override
    public Optional<Integer> getValiditySecs() {
        return this.validitySecs;
    }

    @Override
    public List<@NotNull String> getOperations() {
        return this.operations;
    }

    @Override
    public Optional<MoneyAuthRequest> getMoney() {
        return this.money;
    }

    private AuthTokenRequestImpl(BuilderImpl builder) {
        this.merchantCode = Objects.requireNonNull(builder.merchantCode, "Property 'merchantCode' is required.");
        this.secret = Objects.requireNonNull(builder.secret, "Property 'secret' is required.");
        this.validitySecs = Optional.ofNullable(builder.validitySecs);
        this.operations = Collections.unmodifiableList(builder.operations);
        this.money = Optional.ofNullable(builder.money);
        this.hashCode = Objects.hash(this.merchantCode, this.secret, this.validitySecs, this.operations, this.money);
        this.toString = builder.type + "(merchantCode=" + this.merchantCode + ", secret=" + this.secret + ", validitySecs=" + this.validitySecs + ", operations=" + this.operations + ", money=" + this.money + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthTokenRequestImpl)) {
            return false;
        }
        AuthTokenRequestImpl that = (AuthTokenRequestImpl)obj;
        if (!this.merchantCode.equals(that.merchantCode)) {
            return false;
        }
        if (!this.secret.equals(that.secret)) {
            return false;
        }
        if (!this.validitySecs.equals(that.validitySecs)) {
            return false;
        }
        if (!this.operations.equals(that.operations)) {
            return false;
        }
        return this.money.equals(that.money);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements AuthTokenRequest.Builder {
        private String merchantCode = null;
        private String secret = null;
        private Integer validitySecs = null;
        private List<@NotNull String> operations = new ArrayList<String>();
        private MoneyAuthRequest money = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("AuthTokenRequest");
        }

        @Override
        public BuilderImpl merchantCode(String merchantCode) {
            this.merchantCode = merchantCode;
            return this;
        }

        @Override
        public BuilderImpl secret(String secret) {
            this.secret = secret;
            return this;
        }

        @Override
        public BuilderImpl validitySecs(Integer validitySecs) {
            this.validitySecs = validitySecs;
            return this;
        }

        @Override
        public BuilderImpl operations(List<@NotNull String> operations) {
            this.operations.clear();
            if (operations != null) {
                this.operations.addAll(operations);
            }
            return this;
        }

        @Override
        public BuilderImpl operationsAdd(String item) {
            if (item != null) {
                this.operations.add(item);
            }
            return this;
        }

        @Override
        public BuilderImpl operationsAddAll(List<@NotNull String> operations) {
            if (operations != null) {
                this.operations.addAll(operations);
            }
            return this;
        }

        @Override
        public BuilderImpl money(MoneyAuthRequest money) {
            this.money = money;
            return this;
        }

        @Override
        public AuthTokenRequestImpl build() {
            return new AuthTokenRequestImpl(this);
        }
    }
}

