/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.PaymentOperatorOptionImpl;
import tech.carpentum.sdk.payment.model.IntervalNumberTo;

@JsonClass(generateAdapter=false)
public interface PaymentOperatorOption {
    @NotNull
    public String getCode();

    @NotNull
    public Optional<String> getName();

    @NotNull
    public Boolean getIsAvailable();

    @NotNull
    public IntervalNumberTo getTransactionAmountLimit();

    @NotNull
    public static Builder builder(PaymentOperatorOption copyOf) {
        Builder builder = PaymentOperatorOption.builder();
        builder.code(copyOf.getCode());
        builder.name(copyOf.getName().orElse(null));
        builder.isAvailable(copyOf.getIsAvailable());
        builder.transactionAmountLimit(copyOf.getTransactionAmountLimit());
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new PaymentOperatorOptionImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder code(String var1);

        @NotNull
        public Builder name(String var1);

        @NotNull
        public Builder isAvailable(Boolean var1);

        @NotNull
        public Builder transactionAmountLimit(IntervalNumberTo var1);

        @NotNull
        public PaymentOperatorOption build();
    }
}

