/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.CustomerTransactionFee;
import tech.carpentum.sdk.payment.model.Money;

@JsonClass(generateAdapter=false)
public class CustomerTransactionFeeImpl
implements CustomerTransactionFee {
    private final Optional<Money> minFee;
    private final Optional<Money> maxFee;
    private final int hashCode;
    private final String toString;

    @Override
    public Optional<Money> getMinFee() {
        return this.minFee;
    }

    @Override
    public Optional<Money> getMaxFee() {
        return this.maxFee;
    }

    private CustomerTransactionFeeImpl(BuilderImpl builder) {
        this.minFee = Optional.ofNullable(builder.minFee);
        this.maxFee = Optional.ofNullable(builder.maxFee);
        this.hashCode = Objects.hash(this.minFee, this.maxFee);
        this.toString = builder.type + "(minFee=" + this.minFee + ", maxFee=" + this.maxFee + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerTransactionFeeImpl)) {
            return false;
        }
        CustomerTransactionFeeImpl that = (CustomerTransactionFeeImpl)obj;
        if (!this.minFee.equals(that.minFee)) {
            return false;
        }
        return this.maxFee.equals(that.maxFee);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements CustomerTransactionFee.Builder {
        private Money minFee = null;
        private Money maxFee = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("CustomerTransactionFee");
        }

        @Override
        public BuilderImpl minFee(Money minFee) {
            this.minFee = minFee;
            return this;
        }

        @Override
        public BuilderImpl maxFee(Money maxFee) {
            this.maxFee = maxFee;
            return this;
        }

        @Override
        public CustomerTransactionFeeImpl build() {
            return new CustomerTransactionFeeImpl(this);
        }
    }
}

