/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountCustomerResponseDuitNow;
import tech.carpentum.sdk.payment.model.DuitNowPayMethodResponse;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.IdPayment;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentOperatorIncoming;

@JsonClass(generateAdapter=false)
public class DuitNowPayMethodResponseImpl
implements DuitNowPayMethodResponse {
    private final IdPayin idPayin;
    private final IdPayment idPayment;
    private final AccountCustomerResponseDuitNow accountCustomer;
    private final Money money;
    private final Optional<Money> moneyRequired;
    private final String merchantName;
    private final String reference;
    private final String qrName;
    private final String qrCode;
    private final Optional<PaymentOperatorIncoming> paymentOperator;
    private final String returnUrl;
    private final OffsetDateTime acceptedAt;
    private final OffsetDateTime expireAt;
    private final int hashCode;
    private final String toString;

    @Override
    public IdPayin getIdPayin() {
        return this.idPayin;
    }

    @Override
    public IdPayment getIdPayment() {
        return this.idPayment;
    }

    @Override
    public AccountCustomerResponseDuitNow getAccountCustomer() {
        return this.accountCustomer;
    }

    @Override
    public Money getMoney() {
        return this.money;
    }

    @Override
    public Optional<Money> getMoneyRequired() {
        return this.moneyRequired;
    }

    @Override
    public String getMerchantName() {
        return this.merchantName;
    }

    @Override
    public String getReference() {
        return this.reference;
    }

    @Override
    public String getQrName() {
        return this.qrName;
    }

    @Override
    public String getQrCode() {
        return this.qrCode;
    }

    @Override
    public Optional<PaymentOperatorIncoming> getPaymentOperator() {
        return this.paymentOperator;
    }

    @Override
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Override
    public OffsetDateTime getAcceptedAt() {
        return this.acceptedAt;
    }

    @Override
    public OffsetDateTime getExpireAt() {
        return this.expireAt;
    }

    @Override
    public PayinMethodResponse.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private DuitNowPayMethodResponseImpl(BuilderImpl builder) {
        this.idPayin = Objects.requireNonNull(builder.idPayin, "Property 'idPayin' is required.");
        this.idPayment = Objects.requireNonNull(builder.idPayment, "Property 'idPayment' is required.");
        this.accountCustomer = Objects.requireNonNull(builder.accountCustomer, "Property 'accountCustomer' is required.");
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.moneyRequired = Optional.ofNullable(builder.moneyRequired);
        this.merchantName = Objects.requireNonNull(builder.merchantName, "Property 'merchantName' is required.");
        this.reference = Objects.requireNonNull(builder.reference, "Property 'reference' is required.");
        this.qrName = Objects.requireNonNull(builder.qrName, "Property 'qrName' is required.");
        this.qrCode = Objects.requireNonNull(builder.qrCode, "Property 'qrCode' is required.");
        this.paymentOperator = Optional.ofNullable(builder.paymentOperator);
        this.returnUrl = Objects.requireNonNull(builder.returnUrl, "Property 'returnUrl' is required.");
        this.acceptedAt = Objects.requireNonNull(builder.acceptedAt, "Property 'acceptedAt' is required.");
        this.expireAt = Objects.requireNonNull(builder.expireAt, "Property 'expireAt' is required.");
        this.hashCode = Objects.hash(this.idPayin, this.idPayment, this.accountCustomer, this.money, this.moneyRequired, this.merchantName, this.reference, this.qrName, this.qrCode, this.paymentOperator, this.returnUrl, this.acceptedAt, this.expireAt);
        this.toString = builder.type + "(idPayin=" + this.idPayin + ", idPayment=" + this.idPayment + ", accountCustomer=" + this.accountCustomer + ", money=" + this.money + ", moneyRequired=" + this.moneyRequired + ", merchantName=" + this.merchantName + ", reference=" + this.reference + ", qrName=" + this.qrName + ", qrCode=" + this.qrCode + ", paymentOperator=" + this.paymentOperator + ", returnUrl=" + this.returnUrl + ", acceptedAt=" + this.acceptedAt + ", expireAt=" + this.expireAt + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DuitNowPayMethodResponseImpl)) {
            return false;
        }
        DuitNowPayMethodResponseImpl that = (DuitNowPayMethodResponseImpl)obj;
        if (!this.idPayin.equals(that.idPayin)) {
            return false;
        }
        if (!this.idPayment.equals(that.idPayment)) {
            return false;
        }
        if (!this.accountCustomer.equals(that.accountCustomer)) {
            return false;
        }
        if (!this.money.equals(that.money)) {
            return false;
        }
        if (!this.moneyRequired.equals(that.moneyRequired)) {
            return false;
        }
        if (!this.merchantName.equals(that.merchantName)) {
            return false;
        }
        if (!this.reference.equals(that.reference)) {
            return false;
        }
        if (!this.qrName.equals(that.qrName)) {
            return false;
        }
        if (!this.qrCode.equals(that.qrCode)) {
            return false;
        }
        if (!this.paymentOperator.equals(that.paymentOperator)) {
            return false;
        }
        if (!this.returnUrl.equals(that.returnUrl)) {
            return false;
        }
        if (!this.acceptedAt.equals(that.acceptedAt)) {
            return false;
        }
        return this.expireAt.equals(that.expireAt);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements DuitNowPayMethodResponse.Builder {
        private IdPayin idPayin = null;
        private IdPayment idPayment = null;
        private AccountCustomerResponseDuitNow accountCustomer = null;
        private Money money = null;
        private Money moneyRequired = null;
        private String merchantName = null;
        private String reference = null;
        private String qrName = null;
        private String qrCode = null;
        private PaymentOperatorIncoming paymentOperator = null;
        private String returnUrl = null;
        private OffsetDateTime acceptedAt = null;
        private OffsetDateTime expireAt = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("DuitNowPayMethodResponse");
        }

        @Override
        public BuilderImpl idPayin(IdPayin idPayin) {
            this.idPayin = idPayin;
            return this;
        }

        @Override
        public BuilderImpl idPayment(IdPayment idPayment) {
            this.idPayment = idPayment;
            return this;
        }

        @Override
        public BuilderImpl accountCustomer(AccountCustomerResponseDuitNow accountCustomer) {
            this.accountCustomer = accountCustomer;
            return this;
        }

        @Override
        public BuilderImpl money(Money money) {
            this.money = money;
            return this;
        }

        @Override
        public BuilderImpl moneyRequired(Money moneyRequired) {
            this.moneyRequired = moneyRequired;
            return this;
        }

        @Override
        public BuilderImpl merchantName(String merchantName) {
            this.merchantName = merchantName;
            return this;
        }

        @Override
        public BuilderImpl reference(String reference) {
            this.reference = reference;
            return this;
        }

        @Override
        public BuilderImpl qrName(String qrName) {
            this.qrName = qrName;
            return this;
        }

        @Override
        public BuilderImpl qrCode(String qrCode) {
            this.qrCode = qrCode;
            return this;
        }

        @Override
        public BuilderImpl paymentOperator(PaymentOperatorIncoming paymentOperator) {
            this.paymentOperator = paymentOperator;
            return this;
        }

        @Override
        public BuilderImpl returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        @Override
        public BuilderImpl acceptedAt(OffsetDateTime acceptedAt) {
            this.acceptedAt = acceptedAt;
            return this;
        }

        @Override
        public BuilderImpl expireAt(OffsetDateTime expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @Override
        public DuitNowPayMethodResponseImpl build() {
            return new DuitNowPayMethodResponseImpl(this);
        }
    }
}

