/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.FromJson;
import com.squareup.moshi.ToJson;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.BankTransferMethodImpl;
import tech.carpentum.sdk.payment.internal.generated.model.BankTransferMethodJson;
import tech.carpentum.sdk.payment.model.BankTransferMethod;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\bH\u0007\u00a8\u0006\r"}, d2={"Ltech/carpentum/sdk/payment/internal/generated/model/BankTransferMethodJsonAdapter;", "", "()V", "fromJson", "Ltech/carpentum/sdk/payment/model/BankTransferMethod;", "json", "Ltech/carpentum/sdk/payment/internal/generated/model/BankTransferMethodJson;", "fromJsonImpl", "Ltech/carpentum/sdk/payment/internal/generated/model/BankTransferMethodImpl;", "model", "toJson", "toJsonImpl", "impl", "payment-client-v2"})
public final class BankTransferMethodJsonAdapter {
    @FromJson
    @NotNull
    public final BankTransferMethod fromJson(@NotNull BankTransferMethodJson json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        BankTransferMethod.Builder builder = BankTransferMethod.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()");
        BankTransferMethod.Builder builder2 = builder;
        builder2.account(json.getAccount());
        builder2.paymentOperatorCode(json.getPaymentOperatorCode());
        builder2.emailAddress(json.getEmailAddress());
        builder2.remark(json.getRemark());
        BankTransferMethod bankTransferMethod = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)bankTransferMethod, (String)"builder.build()");
        return bankTransferMethod;
    }

    @ToJson
    @NotNull
    public final BankTransferMethodJson toJson(@NotNull BankTransferMethod model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        BankTransferMethodJson json = new BankTransferMethodJson();
        json.setAccount(model.getAccount());
        json.setPaymentOperatorCode(model.getPaymentOperatorCode());
        json.setEmailAddress(model.getEmailAddress().orElse(null));
        json.setRemark(model.getRemark().orElse(null));
        json.setPaymentMethodCode(model.getPaymentMethodCode().name());
        return json;
    }

    @FromJson
    @NotNull
    public final BankTransferMethodImpl fromJsonImpl(@NotNull BankTransferMethod model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return (BankTransferMethodImpl)model;
    }

    @ToJson
    @NotNull
    public final BankTransferMethod toJsonImpl(@NotNull BankTransferMethodImpl impl) {
        Intrinsics.checkNotNullParameter((Object)impl, (String)"impl");
        return impl;
    }
}

