/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Objects;
import tech.carpentum.sdk.payment.model.Balance;
import tech.carpentum.sdk.payment.model.CurrencyCode;

@JsonClass(generateAdapter=false)
public class BalanceImpl
implements Balance {
    private final CurrencyCode currencyCode;
    private final BigDecimal balance;
    private final BigDecimal availableBalance;
    private final BigDecimal pendingSettlementAmount;
    private final BigDecimal pendingPayoutAmount;
    private final OffsetDateTime lastBalanceMovement;
    private final int hashCode;
    private final String toString;

    @Override
    public CurrencyCode getCurrencyCode() {
        return this.currencyCode;
    }

    @Override
    public BigDecimal getBalance() {
        return this.balance;
    }

    @Override
    public BigDecimal getAvailableBalance() {
        return this.availableBalance;
    }

    @Override
    public BigDecimal getPendingSettlementAmount() {
        return this.pendingSettlementAmount;
    }

    @Override
    public BigDecimal getPendingPayoutAmount() {
        return this.pendingPayoutAmount;
    }

    @Override
    public OffsetDateTime getLastBalanceMovement() {
        return this.lastBalanceMovement;
    }

    private BalanceImpl(BuilderImpl builder) {
        this.currencyCode = Objects.requireNonNull(builder.currencyCode, "Property 'currencyCode' is required.");
        this.balance = Objects.requireNonNull(builder.balance, "Property 'balance' is required.");
        this.availableBalance = Objects.requireNonNull(builder.availableBalance, "Property 'availableBalance' is required.");
        this.pendingSettlementAmount = Objects.requireNonNull(builder.pendingSettlementAmount, "Property 'pendingSettlementAmount' is required.");
        this.pendingPayoutAmount = Objects.requireNonNull(builder.pendingPayoutAmount, "Property 'pendingPayoutAmount' is required.");
        this.lastBalanceMovement = Objects.requireNonNull(builder.lastBalanceMovement, "Property 'lastBalanceMovement' is required.");
        this.hashCode = Objects.hash(this.currencyCode, this.balance, this.availableBalance, this.pendingSettlementAmount, this.pendingPayoutAmount, this.lastBalanceMovement);
        this.toString = builder.type + "(currencyCode=" + this.currencyCode + ", balance=" + this.balance + ", availableBalance=" + this.availableBalance + ", pendingSettlementAmount=" + this.pendingSettlementAmount + ", pendingPayoutAmount=" + this.pendingPayoutAmount + ", lastBalanceMovement=" + this.lastBalanceMovement + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BalanceImpl)) {
            return false;
        }
        BalanceImpl that = (BalanceImpl)obj;
        if (!this.currencyCode.equals(that.currencyCode)) {
            return false;
        }
        if (!this.balance.equals(that.balance)) {
            return false;
        }
        if (!this.availableBalance.equals(that.availableBalance)) {
            return false;
        }
        if (!this.pendingSettlementAmount.equals(that.pendingSettlementAmount)) {
            return false;
        }
        if (!this.pendingPayoutAmount.equals(that.pendingPayoutAmount)) {
            return false;
        }
        return this.lastBalanceMovement.equals(that.lastBalanceMovement);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements Balance.Builder {
        private CurrencyCode currencyCode = null;
        private BigDecimal balance = null;
        private BigDecimal availableBalance = null;
        private BigDecimal pendingSettlementAmount = null;
        private BigDecimal pendingPayoutAmount = null;
        private OffsetDateTime lastBalanceMovement = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("Balance");
        }

        @Override
        public BuilderImpl currencyCode(CurrencyCode currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public BuilderImpl balance(BigDecimal balance) {
            this.balance = balance;
            return this;
        }

        @Override
        public BuilderImpl availableBalance(BigDecimal availableBalance) {
            this.availableBalance = availableBalance;
            return this;
        }

        @Override
        public BuilderImpl pendingSettlementAmount(BigDecimal pendingSettlementAmount) {
            this.pendingSettlementAmount = pendingSettlementAmount;
            return this;
        }

        @Override
        public BuilderImpl pendingPayoutAmount(BigDecimal pendingPayoutAmount) {
            this.pendingPayoutAmount = pendingPayoutAmount;
            return this;
        }

        @Override
        public BuilderImpl lastBalanceMovement(OffsetDateTime lastBalanceMovement) {
            this.lastBalanceMovement = lastBalanceMovement;
            return this;
        }

        @Override
        public BalanceImpl build() {
            return new BalanceImpl(this);
        }
    }
}

