/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.AccountPayinRequestNetBanking;
import tech.carpentum.sdk.payment.model.NetBankingMethod;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class NetBankingMethodImpl
implements NetBankingMethod {
    private final AccountPayinRequestNetBanking account;
    private final String emailAddress;
    private final Optional<String> phoneNumber;
    private final Optional<String> paymentOperatorCode;
    private final int hashCode;
    private final String toString;

    @Override
    public AccountPayinRequestNetBanking getAccount() {
        return this.account;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public Optional<String> getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public Optional<String> getPaymentOperatorCode() {
        return this.paymentOperatorCode;
    }

    @Override
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private NetBankingMethodImpl(BuilderImpl builder) {
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.emailAddress = Objects.requireNonNull(builder.emailAddress, "Property 'emailAddress' is required.");
        this.phoneNumber = Optional.ofNullable(builder.phoneNumber);
        this.paymentOperatorCode = Optional.ofNullable(builder.paymentOperatorCode);
        this.hashCode = Objects.hash(this.account, this.emailAddress, this.phoneNumber, this.paymentOperatorCode);
        this.toString = builder.type + "(account=" + this.account + ", emailAddress=" + this.emailAddress + ", phoneNumber=" + this.phoneNumber + ", paymentOperatorCode=" + this.paymentOperatorCode + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetBankingMethodImpl)) {
            return false;
        }
        NetBankingMethodImpl that = (NetBankingMethodImpl)obj;
        if (!this.account.equals(that.account)) {
            return false;
        }
        if (!this.emailAddress.equals(that.emailAddress)) {
            return false;
        }
        if (!this.phoneNumber.equals(that.phoneNumber)) {
            return false;
        }
        return this.paymentOperatorCode.equals(that.paymentOperatorCode);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements NetBankingMethod.Builder {
        private AccountPayinRequestNetBanking account = null;
        private String emailAddress = null;
        private String phoneNumber = null;
        private String paymentOperatorCode = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("NetBankingMethod");
        }

        @Override
        public BuilderImpl account(AccountPayinRequestNetBanking account) {
            this.account = account;
            return this;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public BuilderImpl phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        @Override
        public NetBankingMethodImpl build() {
            return new NetBankingMethodImpl(this);
        }
    }
}

