/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.OnlineMethodImpl;
import tech.carpentum.sdk.payment.model.AccountPayinRequestOnline;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public interface OnlineMethod
extends PayinMethod {
    public static final PayinMethod.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethod.PaymentMethodCode.ONLINE;

    @NotNull
    public Optional<AccountPayinRequestOnline> getAccount();

    @NotNull
    public Optional<String> getPaymentOperatorCode();

    @NotNull
    public Optional<String> getEmailAddress();

    @NotNull
    public static Builder builder(OnlineMethod copyOf) {
        Builder builder = OnlineMethod.builder();
        builder.account(copyOf.getAccount().orElse(null));
        builder.paymentOperatorCode(copyOf.getPaymentOperatorCode().orElse(null));
        builder.emailAddress(copyOf.getEmailAddress().orElse(null));
        return builder;
    }

    @NotNull
    public static Builder builder() {
        return new OnlineMethodImpl.BuilderImpl();
    }

    public static interface Builder {
        @NotNull
        public Builder account(AccountPayinRequestOnline var1);

        @NotNull
        public Builder paymentOperatorCode(String var1);

        @NotNull
        public Builder emailAddress(String var1);

        @NotNull
        public OnlineMethod build();
    }
}

