/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.PaymentRequested;
import tech.carpentum.sdk.payment.model.SegmentCode;

@JsonClass(generateAdapter=false)
public class PaymentRequestedImpl
implements PaymentRequested {
    private final Money money;
    private final Optional<SegmentCode> segmentCode;
    private final int hashCode;
    private final String toString;

    @Override
    public Money getMoney() {
        return this.money;
    }

    @Override
    public Optional<SegmentCode> getSegmentCode() {
        return this.segmentCode;
    }

    private PaymentRequestedImpl(BuilderImpl builder) {
        this.money = Objects.requireNonNull(builder.money, "Property 'money' is required.");
        this.segmentCode = Optional.ofNullable(builder.segmentCode);
        this.hashCode = Objects.hash(this.money, this.segmentCode);
        this.toString = builder.type + "(money=" + this.money + ", segmentCode=" + this.segmentCode + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PaymentRequestedImpl)) {
            return false;
        }
        PaymentRequestedImpl that = (PaymentRequestedImpl)obj;
        if (!this.money.equals(that.money)) {
            return false;
        }
        return this.segmentCode.equals(that.segmentCode);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements PaymentRequested.Builder {
        private Money money = null;
        private SegmentCode segmentCode = null;
        private final String type;

        public BuilderImpl(String type) {
            this.type = type;
        }

        public BuilderImpl() {
            this("PaymentRequested");
        }

        @Override
        public BuilderImpl money(Money money) {
            this.money = money;
            return this;
        }

        @Override
        public BuilderImpl segmentCode(SegmentCode segmentCode) {
            this.segmentCode = segmentCode;
            return this;
        }

        @Override
        public PaymentRequestedImpl build() {
            return new PaymentRequestedImpl(this);
        }
    }
}

