/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.model;

import com.squareup.moshi.JsonClass;
import java.time.OffsetDateTime;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.internal.generated.model.VaPayMethodResponseImpl;
import tech.carpentum.sdk.payment.model.AccountResponseWithBank;
import tech.carpentum.sdk.payment.model.IdPayin;
import tech.carpentum.sdk.payment.model.Money;
import tech.carpentum.sdk.payment.model.PayinMethodResponse;
import tech.carpentum.sdk.payment.model.PaymentInstruction;

@JsonClass(generateAdapter=false)
public interface VaPayMethodResponse
extends PayinMethodResponse {
    public static final PayinMethodResponse.PaymentMethodCode PAYMENT_METHOD_CODE = PayinMethodResponse.PaymentMethodCode.VAPAY;

    @NotNull
    public IdPayin getIdPayin();

    @NotNull
    public AccountResponseWithBank getAccount();

    @NotNull
    public Money getMoney();

    @NotNull
    public String getReference();

    @NotNull
    public String getReturnUrl();

    @NotNull
    public OffsetDateTime getAcceptedAt();

    @NotNull
    public OffsetDateTime getExpireAt();

    @NotNull
    public @NotNull List<@NotNull PaymentInstruction> getPaymentInstructionList();

    public static Builder builder() {
        return new VaPayMethodResponseImpl.BuilderImpl();
    }

    public static interface Builder {
        public Builder idPayin(IdPayin var1);

        public Builder account(AccountResponseWithBank var1);

        public Builder money(Money var1);

        public Builder reference(String var1);

        public Builder returnUrl(String var1);

        public Builder acceptedAt(OffsetDateTime var1);

        public Builder expireAt(OffsetDateTime var1);

        public Builder paymentInstructionList(List<@NotNull PaymentInstruction> var1);

        public Builder paymentInstructionListAdd(PaymentInstruction var1);

        public Builder paymentInstructionListAddAll(List<@NotNull PaymentInstruction> var1);

        public VaPayMethodResponse build();
    }
}

