/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.Payin;
import tech.carpentum.sdk.payment.model.PayinMethod;
import tech.carpentum.sdk.payment.model.PaymentRequested;

@JsonClass(generateAdapter=false)
public class PayinImpl
implements Payin {
    private final PaymentRequested paymentRequested;
    private final PayinMethod paymentMethod;
    private final Optional<String> callbackUrl;
    private final String returnUrl;
    private final Optional<String> customerIp;
    private final int hashCode;
    private final String toString;

    @Override
    @NotNull
    public PaymentRequested getPaymentRequested() {
        return this.paymentRequested;
    }

    @Override
    @NotNull
    public PayinMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    @Override
    @NotNull
    public Optional<String> getCallbackUrl() {
        return this.callbackUrl;
    }

    @Override
    @NotNull
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Override
    @NotNull
    public Optional<String> getCustomerIp() {
        return this.customerIp;
    }

    private PayinImpl(BuilderImpl builder) {
        this.paymentRequested = Objects.requireNonNull(builder.paymentRequested, "Property 'paymentRequested' is required.");
        this.paymentMethod = Objects.requireNonNull(builder.paymentMethod, "Property 'paymentMethod' is required.");
        this.callbackUrl = Optional.ofNullable(builder.callbackUrl);
        this.returnUrl = Objects.requireNonNull(builder.returnUrl, "Property 'returnUrl' is required.");
        this.customerIp = Optional.ofNullable(builder.customerIp);
        this.hashCode = Objects.hash(this.paymentRequested, this.paymentMethod, this.callbackUrl, this.returnUrl, this.customerIp);
        this.toString = "Payin(paymentRequested=" + this.paymentRequested + ", paymentMethod=" + this.paymentMethod + ", callbackUrl=" + this.callbackUrl + ", returnUrl=" + this.returnUrl + ", customerIp=" + this.customerIp + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Payin)) {
            return false;
        }
        PayinImpl that = (PayinImpl)obj;
        if (!this.paymentRequested.equals(that.paymentRequested)) {
            return false;
        }
        if (!this.paymentMethod.equals(that.paymentMethod)) {
            return false;
        }
        if (!this.callbackUrl.equals(that.callbackUrl)) {
            return false;
        }
        if (!this.returnUrl.equals(that.returnUrl)) {
            return false;
        }
        return this.customerIp.equals(that.customerIp);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements Payin.Builder {
        private PaymentRequested paymentRequested = null;
        private PayinMethod paymentMethod = null;
        private String callbackUrl = null;
        private String returnUrl = null;
        private String customerIp = null;

        @Override
        public BuilderImpl paymentRequested(PaymentRequested paymentRequested) {
            this.paymentRequested = paymentRequested;
            return this;
        }

        @Override
        public BuilderImpl paymentMethod(PayinMethod paymentMethod) {
            this.paymentMethod = paymentMethod;
            return this;
        }

        @Override
        public BuilderImpl callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        @Override
        public BuilderImpl returnUrl(String returnUrl) {
            this.returnUrl = returnUrl;
            return this;
        }

        @Override
        public BuilderImpl customerIp(String customerIp) {
            this.customerIp = customerIp;
            return this;
        }

        @Override
        public PayinImpl build() {
            return new PayinImpl(this);
        }
    }
}

