/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AccountPayinRequestNetBanking;
import tech.carpentum.sdk.payment.model.NetBankingMethod;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class NetBankingMethodImpl
implements NetBankingMethod {
    private final AccountPayinRequestNetBanking account;
    private final String emailAddress;
    private final String phoneNumber;
    private final int hashCode;
    private final String toString;

    @Override
    @NotNull
    public AccountPayinRequestNetBanking getAccount() {
        return this.account;
    }

    @Override
    @NotNull
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    @NotNull
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    @NotNull
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private NetBankingMethodImpl(BuilderImpl builder) {
        this.account = Objects.requireNonNull(builder.account, "Property 'account' is required.");
        this.emailAddress = Objects.requireNonNull(builder.emailAddress, "Property 'emailAddress' is required.");
        this.phoneNumber = Objects.requireNonNull(builder.phoneNumber, "Property 'phoneNumber' is required.");
        this.hashCode = Objects.hash(this.account, this.emailAddress, this.phoneNumber);
        this.toString = "NetBankingMethod(account=" + this.account + ", emailAddress=" + this.emailAddress + ", phoneNumber=" + this.phoneNumber + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetBankingMethod)) {
            return false;
        }
        NetBankingMethodImpl that = (NetBankingMethodImpl)obj;
        if (!this.account.equals(that.account)) {
            return false;
        }
        if (!this.emailAddress.equals(that.emailAddress)) {
            return false;
        }
        return this.phoneNumber.equals(that.phoneNumber);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements NetBankingMethod.Builder {
        private AccountPayinRequestNetBanking account = null;
        private String emailAddress = null;
        private String phoneNumber = null;

        @Override
        public BuilderImpl account(AccountPayinRequestNetBanking account) {
            this.account = account;
            return this;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public BuilderImpl phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @Override
        public NetBankingMethodImpl build() {
            return new NetBankingMethodImpl(this);
        }
    }
}

