/*
 * Decompiled with CFR 0.152.
 */
package tech.carpentum.sdk.payment.internal.generated.model;

import com.squareup.moshi.JsonClass;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import tech.carpentum.sdk.payment.model.AccountPayinRequestP2AV2;
import tech.carpentum.sdk.payment.model.P2AV2Method;
import tech.carpentum.sdk.payment.model.PayinMethod;

@JsonClass(generateAdapter=false)
public class P2AV2MethodImpl
implements P2AV2Method {
    private final Optional<AccountPayinRequestP2AV2> account;
    private final String paymentOperatorCode;
    private final Optional<String> emailAddress;
    private final int hashCode;
    private final String toString;

    @Override
    @NotNull
    public Optional<AccountPayinRequestP2AV2> getAccount() {
        return this.account;
    }

    @Override
    @NotNull
    public String getPaymentOperatorCode() {
        return this.paymentOperatorCode;
    }

    @Override
    @NotNull
    public Optional<String> getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    @NotNull
    public PayinMethod.PaymentMethodCode getPaymentMethodCode() {
        return PAYMENT_METHOD_CODE;
    }

    private P2AV2MethodImpl(BuilderImpl builder) {
        this.account = Optional.ofNullable(builder.account);
        this.paymentOperatorCode = Objects.requireNonNull(builder.paymentOperatorCode, "Property 'paymentOperatorCode' is required.");
        this.emailAddress = Optional.ofNullable(builder.emailAddress);
        this.hashCode = Objects.hash(this.account, this.paymentOperatorCode, this.emailAddress);
        this.toString = "P2AV2Method(account=" + this.account + ", paymentOperatorCode=" + this.paymentOperatorCode + ", emailAddress=" + this.emailAddress + ')';
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof P2AV2Method)) {
            return false;
        }
        P2AV2MethodImpl that = (P2AV2MethodImpl)obj;
        if (!this.account.equals(that.account)) {
            return false;
        }
        if (!this.paymentOperatorCode.equals(that.paymentOperatorCode)) {
            return false;
        }
        return this.emailAddress.equals(that.emailAddress);
    }

    public String toString() {
        return this.toString;
    }

    public static class BuilderImpl
    implements P2AV2Method.Builder {
        private AccountPayinRequestP2AV2 account = null;
        private String paymentOperatorCode = null;
        private String emailAddress = null;

        @Override
        public BuilderImpl account(AccountPayinRequestP2AV2 account) {
            this.account = account;
            return this;
        }

        @Override
        public BuilderImpl paymentOperatorCode(String paymentOperatorCode) {
            this.paymentOperatorCode = paymentOperatorCode;
            return this;
        }

        @Override
        public BuilderImpl emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @Override
        public P2AV2MethodImpl build() {
            return new P2AV2MethodImpl(this);
        }
    }
}

